// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The configuration of a data repository association that links an Amazon FSx for Lustre file system to an Amazon S3 bucket or an Amazon File Cache resource to an Amazon S3 bucket or an NFS file system. The data repository association configuration object is returned in the response of the following operations:
 * + `CreateDataRepositoryAssociation`
 * + `UpdateDataRepositoryAssociation`
 * + `DescribeDataRepositoryAssociations`
 *
 * Data repository associations are supported on Amazon File Cache resources and all FSx for Lustre 2.12 and 2.15 file systems, excluding `scratch_1` deployment type.
 */
public class DataRepositoryAssociation private constructor(builder: Builder) {
    /**
     * The system-generated, unique ID of the data repository association.
     */
    public val associationId: kotlin.String? = builder.associationId
    /**
     * A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created. The task runs if this flag is set to `true`.
     *
     * `BatchImportMetaDataOnCreate` is not supported for data repositories linked to an Amazon File Cache resource.
     */
    public val batchImportMetaDataOnCreate: kotlin.Boolean? = builder.batchImportMetaDataOnCreate
    /**
     * The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The path to the data repository that will be linked to the cache or file system.
     * + For Amazon File Cache, the path can be an NFS data repository that will be linked to the cache. The path can be in one of two formats:
     *    + If you are not using the `DataRepositorySubdirectories` parameter, the path is to an NFS Export directory (or one of its subdirectories) in the format `nsf://nfs-domain-name/exportpath`. You can therefore link a single NFS Export to a single data repository association.
     *    + If you are using the `DataRepositorySubdirectories` parameter, the path is the domain name of the NFS file system in the format `nfs://filer-domain-name`, which indicates the root of the subdirectories specified with the `DataRepositorySubdirectories` parameter.
     * + For Amazon File Cache, the path can be an S3 bucket or prefix in the format `s3://bucket-name/prefix/` (where `prefix` is optional).
     * + For Amazon FSx for Lustre, the path can be an S3 bucket or prefix in the format `s3://bucket-name/prefix/` (where `prefix` is optional).
     */
    public val dataRepositoryPath: kotlin.String? = builder.dataRepositoryPath
    /**
     * For Amazon File Cache, a list of NFS Exports that will be linked with an NFS data repository association. All the subdirectories must be on a single NFS file system. The Export paths are in the format `/exportpath1`. To use this parameter, you must configure `DataRepositoryPath` as the domain name of the NFS file system. The NFS file system domain name in effect is the root of the subdirectories. Note that `DataRepositorySubdirectories` is not supported for S3 data repositories.
     */
    public val dataRepositorySubdirectories: List<String>? = builder.dataRepositorySubdirectories
    /**
     * Provides detailed information about the data repository if its `Lifecycle` is set to `MISCONFIGURED` or `FAILED`.
     */
    public val failureDetails: aws.sdk.kotlin.services.fsx.model.DataRepositoryFailureDetails? = builder.failureDetails
    /**
     * The globally unique ID of the Amazon File Cache resource.
     */
    public val fileCacheId: kotlin.String? = builder.fileCacheId
    /**
     * A path on the Amazon File Cache that points to a high-level directory (such as `/ns1/`) or subdirectory (such as `/ns1/subdir/`) that will be mapped 1-1 with `DataRepositoryPath`. The leading forward slash in the path is required. Two data repository associations cannot have overlapping cache paths. For example, if a data repository is associated with cache path `/ns1/`, then you cannot link another data repository with cache path `/ns1/ns2`.
     *
     * This path specifies the directory in your cache where files will be exported from. This cache directory can be linked to only one data repository (S3 or NFS) and no other data repository can be linked to the directory.
     *
     * The cache path can only be set to root (/) on an NFS DRA when `DataRepositorySubdirectories` is specified. If you specify root (/) as the cache path, you can create only one DRA on the cache.
     *
     * The cache path cannot be set to root (/) for an S3 DRA.
     */
    public val fileCachePath: kotlin.String? = builder.fileCachePath
    /**
     * The globally unique ID of the file system, assigned by Amazon FSx.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * A path on the Amazon FSx for Lustre file system that points to a high-level directory (such as `/ns1/`) or subdirectory (such as `/ns1/subdir/`) that will be mapped 1-1 with `DataRepositoryPath`. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path `/ns1/`, then you cannot link another data repository with file system path `/ns1/ns2`.
     *
     * This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
     *
     * If you specify only a forward slash (`/`) as the file system path, you can link only one data repository to the file system. You can only specify "/" as the file system path for the first data repository associated with a file system.
     */
    public val fileSystemPath: kotlin.String? = builder.fileSystemPath
    /**
     * For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system or cache.
     *
     * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
     */
    public val importedFileChunkSize: kotlin.Int? = builder.importedFileChunkSize
    /**
     * Describes the state of a data repository association. The lifecycle can have the following values:
     * + `CREATING` - The data repository association between the file system or cache and the data repository is being created. The data repository is unavailable.
     * + `AVAILABLE` - The data repository association is available for use.
     * + `MISCONFIGURED` - The data repository association is misconfigured. Until the configuration is corrected, automatic import and automatic export will not work (only for Amazon FSx for Lustre).
     * + `UPDATING` - The data repository association is undergoing a customer initiated update that might affect its availability.
     * + `DELETING` - The data repository association is undergoing a customer initiated deletion.
     * + `FAILED` - The data repository association is in a terminal state that cannot be recovered.
     */
    public val lifecycle: aws.sdk.kotlin.services.fsx.model.DataRepositoryLifecycle? = builder.lifecycle
    /**
     * The configuration for an NFS data repository linked to an Amazon File Cache resource with a data repository association.
     */
    public val nfs: aws.sdk.kotlin.services.fsx.model.NfsDataRepositoryConfiguration? = builder.nfs
    /**
     * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The configuration for an Amazon S3 data repository linked to an Amazon FSx for Lustre file system with a data repository association.
     */
    public val s3: aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration? = builder.s3
    /**
     * A list of `Tag` values, with a maximum of 50 elements.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.DataRepositoryAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataRepositoryAssociation(")
        append("associationId=$associationId,")
        append("batchImportMetaDataOnCreate=$batchImportMetaDataOnCreate,")
        append("creationTime=$creationTime,")
        append("dataRepositoryPath=$dataRepositoryPath,")
        append("dataRepositorySubdirectories=$dataRepositorySubdirectories,")
        append("failureDetails=$failureDetails,")
        append("fileCacheId=$fileCacheId,")
        append("fileCachePath=$fileCachePath,")
        append("fileSystemId=$fileSystemId,")
        append("fileSystemPath=$fileSystemPath,")
        append("importedFileChunkSize=$importedFileChunkSize,")
        append("lifecycle=$lifecycle,")
        append("nfs=$nfs,")
        append("resourceArn=$resourceArn,")
        append("s3=$s3,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationId?.hashCode() ?: 0
        result = 31 * result + (batchImportMetaDataOnCreate?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (dataRepositoryPath?.hashCode() ?: 0)
        result = 31 * result + (dataRepositorySubdirectories?.hashCode() ?: 0)
        result = 31 * result + (failureDetails?.hashCode() ?: 0)
        result = 31 * result + (fileCacheId?.hashCode() ?: 0)
        result = 31 * result + (fileCachePath?.hashCode() ?: 0)
        result = 31 * result + (fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (fileSystemPath?.hashCode() ?: 0)
        result = 31 * result + (importedFileChunkSize ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (nfs?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (s3?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataRepositoryAssociation

        if (associationId != other.associationId) return false
        if (batchImportMetaDataOnCreate != other.batchImportMetaDataOnCreate) return false
        if (creationTime != other.creationTime) return false
        if (dataRepositoryPath != other.dataRepositoryPath) return false
        if (dataRepositorySubdirectories != other.dataRepositorySubdirectories) return false
        if (failureDetails != other.failureDetails) return false
        if (fileCacheId != other.fileCacheId) return false
        if (fileCachePath != other.fileCachePath) return false
        if (fileSystemId != other.fileSystemId) return false
        if (fileSystemPath != other.fileSystemPath) return false
        if (importedFileChunkSize != other.importedFileChunkSize) return false
        if (lifecycle != other.lifecycle) return false
        if (nfs != other.nfs) return false
        if (resourceArn != other.resourceArn) return false
        if (s3 != other.s3) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.DataRepositoryAssociation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The system-generated, unique ID of the data repository association.
         */
        public var associationId: kotlin.String? = null
        /**
         * A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created. The task runs if this flag is set to `true`.
         *
         * `BatchImportMetaDataOnCreate` is not supported for data repositories linked to an Amazon File Cache resource.
         */
        public var batchImportMetaDataOnCreate: kotlin.Boolean? = null
        /**
         * The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The path to the data repository that will be linked to the cache or file system.
         * + For Amazon File Cache, the path can be an NFS data repository that will be linked to the cache. The path can be in one of two formats:
         *    + If you are not using the `DataRepositorySubdirectories` parameter, the path is to an NFS Export directory (or one of its subdirectories) in the format `nsf://nfs-domain-name/exportpath`. You can therefore link a single NFS Export to a single data repository association.
         *    + If you are using the `DataRepositorySubdirectories` parameter, the path is the domain name of the NFS file system in the format `nfs://filer-domain-name`, which indicates the root of the subdirectories specified with the `DataRepositorySubdirectories` parameter.
         * + For Amazon File Cache, the path can be an S3 bucket or prefix in the format `s3://bucket-name/prefix/` (where `prefix` is optional).
         * + For Amazon FSx for Lustre, the path can be an S3 bucket or prefix in the format `s3://bucket-name/prefix/` (where `prefix` is optional).
         */
        public var dataRepositoryPath: kotlin.String? = null
        /**
         * For Amazon File Cache, a list of NFS Exports that will be linked with an NFS data repository association. All the subdirectories must be on a single NFS file system. The Export paths are in the format `/exportpath1`. To use this parameter, you must configure `DataRepositoryPath` as the domain name of the NFS file system. The NFS file system domain name in effect is the root of the subdirectories. Note that `DataRepositorySubdirectories` is not supported for S3 data repositories.
         */
        public var dataRepositorySubdirectories: List<String>? = null
        /**
         * Provides detailed information about the data repository if its `Lifecycle` is set to `MISCONFIGURED` or `FAILED`.
         */
        public var failureDetails: aws.sdk.kotlin.services.fsx.model.DataRepositoryFailureDetails? = null
        /**
         * The globally unique ID of the Amazon File Cache resource.
         */
        public var fileCacheId: kotlin.String? = null
        /**
         * A path on the Amazon File Cache that points to a high-level directory (such as `/ns1/`) or subdirectory (such as `/ns1/subdir/`) that will be mapped 1-1 with `DataRepositoryPath`. The leading forward slash in the path is required. Two data repository associations cannot have overlapping cache paths. For example, if a data repository is associated with cache path `/ns1/`, then you cannot link another data repository with cache path `/ns1/ns2`.
         *
         * This path specifies the directory in your cache where files will be exported from. This cache directory can be linked to only one data repository (S3 or NFS) and no other data repository can be linked to the directory.
         *
         * The cache path can only be set to root (/) on an NFS DRA when `DataRepositorySubdirectories` is specified. If you specify root (/) as the cache path, you can create only one DRA on the cache.
         *
         * The cache path cannot be set to root (/) for an S3 DRA.
         */
        public var fileCachePath: kotlin.String? = null
        /**
         * The globally unique ID of the file system, assigned by Amazon FSx.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * A path on the Amazon FSx for Lustre file system that points to a high-level directory (such as `/ns1/`) or subdirectory (such as `/ns1/subdir/`) that will be mapped 1-1 with `DataRepositoryPath`. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path `/ns1/`, then you cannot link another data repository with file system path `/ns1/ns2`.
         *
         * This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
         *
         * If you specify only a forward slash (`/`) as the file system path, you can link only one data repository to the file system. You can only specify "/" as the file system path for the first data repository associated with a file system.
         */
        public var fileSystemPath: kotlin.String? = null
        /**
         * For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system or cache.
         *
         * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
         */
        public var importedFileChunkSize: kotlin.Int? = null
        /**
         * Describes the state of a data repository association. The lifecycle can have the following values:
         * + `CREATING` - The data repository association between the file system or cache and the data repository is being created. The data repository is unavailable.
         * + `AVAILABLE` - The data repository association is available for use.
         * + `MISCONFIGURED` - The data repository association is misconfigured. Until the configuration is corrected, automatic import and automatic export will not work (only for Amazon FSx for Lustre).
         * + `UPDATING` - The data repository association is undergoing a customer initiated update that might affect its availability.
         * + `DELETING` - The data repository association is undergoing a customer initiated deletion.
         * + `FAILED` - The data repository association is in a terminal state that cannot be recovered.
         */
        public var lifecycle: aws.sdk.kotlin.services.fsx.model.DataRepositoryLifecycle? = null
        /**
         * The configuration for an NFS data repository linked to an Amazon File Cache resource with a data repository association.
         */
        public var nfs: aws.sdk.kotlin.services.fsx.model.NfsDataRepositoryConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The configuration for an Amazon S3 data repository linked to an Amazon FSx for Lustre file system with a data repository association.
         */
        public var s3: aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration? = null
        /**
         * A list of `Tag` values, with a maximum of 50 elements.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.DataRepositoryAssociation) : this() {
            this.associationId = x.associationId
            this.batchImportMetaDataOnCreate = x.batchImportMetaDataOnCreate
            this.creationTime = x.creationTime
            this.dataRepositoryPath = x.dataRepositoryPath
            this.dataRepositorySubdirectories = x.dataRepositorySubdirectories
            this.failureDetails = x.failureDetails
            this.fileCacheId = x.fileCacheId
            this.fileCachePath = x.fileCachePath
            this.fileSystemId = x.fileSystemId
            this.fileSystemPath = x.fileSystemPath
            this.importedFileChunkSize = x.importedFileChunkSize
            this.lifecycle = x.lifecycle
            this.nfs = x.nfs
            this.resourceArn = x.resourceArn
            this.s3 = x.s3
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.DataRepositoryAssociation = DataRepositoryAssociation(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DataRepositoryFailureDetails] inside the given [block]
         */
        public fun failureDetails(block: aws.sdk.kotlin.services.fsx.model.DataRepositoryFailureDetails.Builder.() -> kotlin.Unit) {
            this.failureDetails = aws.sdk.kotlin.services.fsx.model.DataRepositoryFailureDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.NfsDataRepositoryConfiguration] inside the given [block]
         */
        public fun nfs(block: aws.sdk.kotlin.services.fsx.model.NfsDataRepositoryConfiguration.Builder.() -> kotlin.Unit) {
            this.nfs = aws.sdk.kotlin.services.fsx.model.NfsDataRepositoryConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration] inside the given [block]
         */
        public fun s3(block: aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration.Builder.() -> kotlin.Unit) {
            this.s3 = aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
