// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines the SnapLock configuration when creating an FSx for ONTAP SnapLock volume.
 */
public class CreateSnaplockConfiguration private constructor(builder: Builder) {
    /**
     * Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume. The default value is `false`. If you set `AuditLogVolume` to `true`, the SnapLock volume is created as an audit log volume. The minimum retention period for an audit log volume is six months.
     *
     * For more information, see [ SnapLock audit log volumes](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/how-snaplock-works.html#snaplock-audit-log-volume).
     */
    public val auditLogVolume: kotlin.Boolean? = builder.auditLogVolume
    /**
     * The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume.
     */
    public val autocommitPeriod: aws.sdk.kotlin.services.fsx.model.AutocommitPeriod? = builder.autocommitPeriod
    /**
     * Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise volume. Enabling privileged delete allows SnapLock administrators to delete WORM files even if they have active retention periods. `PERMANENTLY_DISABLED` is a terminal state. If privileged delete is permanently disabled on a SnapLock volume, you can't re-enable it. The default value is `DISABLED`.
     *
     * For more information, see [Privileged delete](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html#privileged-delete).
     */
    public val privilegedDelete: aws.sdk.kotlin.services.fsx.model.PrivilegedDelete? = builder.privilegedDelete
    /**
     * Specifies the retention period of an FSx for ONTAP SnapLock volume.
     */
    public val retentionPeriod: aws.sdk.kotlin.services.fsx.model.SnaplockRetentionPeriod? = builder.retentionPeriod
    /**
     * Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is set, it can't be changed. You can choose one of the following retention modes:
     * + `COMPLIANCE`: Files transitioned to write once, read many (WORM) on a Compliance volume can't be deleted until their retention periods expire. This retention mode is used to address government or industry-specific mandates or to protect against ransomware attacks. For more information, see [SnapLock Compliance](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-compliance.html).
     * + `ENTERPRISE`: Files transitioned to WORM on an Enterprise volume can be deleted by authorized users before their retention periods expire using privileged delete. This retention mode is used to advance an organization's data integrity and internal compliance or to test retention settings before using SnapLock Compliance. For more information, see [SnapLock Enterprise](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html).
     */
    public val snaplockType: aws.sdk.kotlin.services.fsx.model.SnaplockType? = builder.snaplockType
    /**
     * Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume. Volume-append mode allows you to create WORM-appendable files and write data to them incrementally. The default value is `false`.
     *
     * For more information, see [Volume-append mode](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/worm-state.html#worm-state-append).
     */
    public val volumeAppendModeEnabled: kotlin.Boolean? = builder.volumeAppendModeEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.CreateSnaplockConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSnaplockConfiguration(")
        append("auditLogVolume=$auditLogVolume,")
        append("autocommitPeriod=$autocommitPeriod,")
        append("privilegedDelete=$privilegedDelete,")
        append("retentionPeriod=$retentionPeriod,")
        append("snaplockType=$snaplockType,")
        append("volumeAppendModeEnabled=$volumeAppendModeEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = auditLogVolume?.hashCode() ?: 0
        result = 31 * result + (autocommitPeriod?.hashCode() ?: 0)
        result = 31 * result + (privilegedDelete?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod?.hashCode() ?: 0)
        result = 31 * result + (snaplockType?.hashCode() ?: 0)
        result = 31 * result + (volumeAppendModeEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSnaplockConfiguration

        if (auditLogVolume != other.auditLogVolume) return false
        if (autocommitPeriod != other.autocommitPeriod) return false
        if (privilegedDelete != other.privilegedDelete) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (snaplockType != other.snaplockType) return false
        if (volumeAppendModeEnabled != other.volumeAppendModeEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.CreateSnaplockConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume. The default value is `false`. If you set `AuditLogVolume` to `true`, the SnapLock volume is created as an audit log volume. The minimum retention period for an audit log volume is six months.
         *
         * For more information, see [ SnapLock audit log volumes](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/how-snaplock-works.html#snaplock-audit-log-volume).
         */
        public var auditLogVolume: kotlin.Boolean? = null
        /**
         * The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume.
         */
        public var autocommitPeriod: aws.sdk.kotlin.services.fsx.model.AutocommitPeriod? = null
        /**
         * Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise volume. Enabling privileged delete allows SnapLock administrators to delete WORM files even if they have active retention periods. `PERMANENTLY_DISABLED` is a terminal state. If privileged delete is permanently disabled on a SnapLock volume, you can't re-enable it. The default value is `DISABLED`.
         *
         * For more information, see [Privileged delete](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html#privileged-delete).
         */
        public var privilegedDelete: aws.sdk.kotlin.services.fsx.model.PrivilegedDelete? = null
        /**
         * Specifies the retention period of an FSx for ONTAP SnapLock volume.
         */
        public var retentionPeriod: aws.sdk.kotlin.services.fsx.model.SnaplockRetentionPeriod? = null
        /**
         * Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is set, it can't be changed. You can choose one of the following retention modes:
         * + `COMPLIANCE`: Files transitioned to write once, read many (WORM) on a Compliance volume can't be deleted until their retention periods expire. This retention mode is used to address government or industry-specific mandates or to protect against ransomware attacks. For more information, see [SnapLock Compliance](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-compliance.html).
         * + `ENTERPRISE`: Files transitioned to WORM on an Enterprise volume can be deleted by authorized users before their retention periods expire using privileged delete. This retention mode is used to advance an organization's data integrity and internal compliance or to test retention settings before using SnapLock Compliance. For more information, see [SnapLock Enterprise](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html).
         */
        public var snaplockType: aws.sdk.kotlin.services.fsx.model.SnaplockType? = null
        /**
         * Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume. Volume-append mode allows you to create WORM-appendable files and write data to them incrementally. The default value is `false`.
         *
         * For more information, see [Volume-append mode](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/worm-state.html#worm-state-append).
         */
        public var volumeAppendModeEnabled: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.CreateSnaplockConfiguration) : this() {
            this.auditLogVolume = x.auditLogVolume
            this.autocommitPeriod = x.autocommitPeriod
            this.privilegedDelete = x.privilegedDelete
            this.retentionPeriod = x.retentionPeriod
            this.snaplockType = x.snaplockType
            this.volumeAppendModeEnabled = x.volumeAppendModeEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.CreateSnaplockConfiguration = CreateSnaplockConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.AutocommitPeriod] inside the given [block]
         */
        public fun autocommitPeriod(block: aws.sdk.kotlin.services.fsx.model.AutocommitPeriod.Builder.() -> kotlin.Unit) {
            this.autocommitPeriod = aws.sdk.kotlin.services.fsx.model.AutocommitPeriod.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.SnaplockRetentionPeriod] inside the given [block]
         */
        public fun retentionPeriod(block: aws.sdk.kotlin.services.fsx.model.SnaplockRetentionPeriod.Builder.() -> kotlin.Unit) {
            this.retentionPeriod = aws.sdk.kotlin.services.fsx.model.SnaplockRetentionPeriod.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
