// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The ONTAP configuration properties of the FSx for ONTAP file system that you are creating.
 */
public class CreateFileSystemOntapConfiguration private constructor(builder: Builder) {
    /**
     * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `30`.
     */
    public val automaticBackupRetentionDays: kotlin.Int? = builder.automaticBackupRetentionDays
    /**
     * A recurring daily time, in the format `HH:MM`. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, `05:00` specifies 5 AM daily.
     */
    public val dailyAutomaticBackupStartTime: kotlin.String? = builder.dailyAutomaticBackupStartTime
    /**
     * Specifies the FSx for ONTAP file system deployment type to use in creating the file system.
     * + `MULTI_AZ_1` - A high availability file system configured for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability. This is a first-generation FSx for ONTAP file system.
     * + `MULTI_AZ_2` - A high availability file system configured for Multi-AZ redundancy to tolerate temporary AZ unavailability. This is a second-generation FSx for ONTAP file system.
     * + `SINGLE_AZ_1` - A file system configured for Single-AZ redundancy. This is a first-generation FSx for ONTAP file system.
     * + `SINGLE_AZ_2` - A file system configured with multiple high-availability (HA) pairs for Single-AZ redundancy. This is a second-generation FSx for ONTAP file system.
     *
     * For information about the use cases for Multi-AZ and Single-AZ deployments, refer to [Choosing a file system deployment type](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-AZ.html).
     */
    public val deploymentType: aws.sdk.kotlin.services.fsx.model.OntapDeploymentType? = builder.deploymentType
    /**
     * The SSD IOPS configuration for the FSx for ONTAP file system.
     */
    public val diskIopsConfiguration: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration? = builder.diskIopsConfiguration
    /**
     * (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created. By default in the Amazon FSx API, Amazon FSx selects an unused IP address range for you from the 198.19.* range. By default in the Amazon FSx console, Amazon FSx chooses the last 64 IP addresses from the VPC’s primary CIDR range to use as the endpoint IP address range for the file system. You can have overlapping endpoint IP addresses for file systems deployed in the same VPC/route tables, as long as they don't overlap with any subnet.
     */
    public val endpointIpAddressRange: kotlin.String? = builder.endpointIpAddressRange
    /**
     * The ONTAP administrative password for the `fsxadmin` user with which you administer your file system using the NetApp ONTAP CLI and REST API.
     */
    public val fsxAdminPassword: kotlin.String? = builder.fsxAdminPassword
    /**
     * Specifies how many high-availability (HA) pairs of file servers will power your file system. First-generation file systems are powered by 1 HA pair. Second-generation multi-AZ file systems are powered by 1 HA pair. Second generation single-AZ file systems are powered by up to 12 HA pairs. The default value is 1. The value of this property affects the values of `StorageCapacity`, `Iops`, and `ThroughputCapacity`. For more information, see [High-availability (HA) pairs](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/administering-file-systems.html#HA-pairs) in the FSx for ONTAP user guide. Block storage protocol support (iSCSI and NVMe over TCP) is disabled on file systems with more than 6 HA pairs. For more information, see [Using block storage protocols](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/supported-fsx-clients.html#using-block-storage).
     *
     * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
     * + The value of `HAPairs` is less than 1 or greater than 12.
     * + The value of `HAPairs` is greater than 1 and the value of `DeploymentType` is `SINGLE_AZ_1`, `MULTI_AZ_1`, or `MULTI_AZ_2`.
     */
    public val haPairs: kotlin.Int? = builder.haPairs
    /**
     * Required when `DeploymentType` is set to `MULTI_AZ_1` or `MULTI_AZ_2`. This specifies the subnet in which you want the preferred file server to be located.
     */
    public val preferredSubnetId: kotlin.String? = builder.preferredSubnetId
    /**
     * (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
     *
     * Amazon FSx manages these route tables for Multi-AZ file systems using tag-based authentication. These route tables are tagged with `Key: AmazonFSx; Value: ManagedByAmazonFSx`. When creating FSx for ONTAP Multi-AZ file systems using CloudFormation we recommend that you add the `Key: AmazonFSx; Value: ManagedByAmazonFSx` tag manually.
     */
    public val routeTableIds: List<String>? = builder.routeTableIds
    /**
     * Sets the throughput capacity for the file system that you're creating in megabytes per second (MBps). For more information, see [Managing throughput capacity](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-throughput-capacity.html) in the FSx for ONTAP User Guide.
     *
     * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
     * + The value of `ThroughputCapacity` and `ThroughputCapacityPerHAPair` are not the same value.
     * + The value of `ThroughputCapacity` when divided by the value of `HAPairs` is outside of the valid range for `ThroughputCapacity`.
     */
    public val throughputCapacity: kotlin.Int? = builder.throughputCapacity
    /**
     * Use to choose the throughput capacity per HA pair, rather than the total throughput for the file system.
     *
     * You can define either the `ThroughputCapacityPerHAPair` or the `ThroughputCapacity` when creating a file system, but not both.
     *
     * This field and `ThroughputCapacity` are the same for file systems powered by one HA pair.
     * + For `SINGLE_AZ_1` and `MULTI_AZ_1` file systems, valid values are 128, 256, 512, 1024, 2048, or 4096 MBps.
     * + For `SINGLE_AZ_2`, valid values are 1536, 3072, or 6144 MBps.
     * + For `MULTI_AZ_2`, valid values are 384, 768, 1536, 3072, or 6144 MBps.
     *
     * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
     * + The value of `ThroughputCapacity` and `ThroughputCapacityPerHAPair` are not the same value for file systems with one HA pair.
     * + The value of deployment type is `SINGLE_AZ_2` and `ThroughputCapacity` / `ThroughputCapacityPerHAPair` is not a valid HA pair (a value between 1 and 12).
     * + The value of `ThroughputCapacityPerHAPair` is not a valid value.
     */
    public val throughputCapacityPerHaPair: kotlin.Int? = builder.throughputCapacityPerHaPair
    /**
     * A recurring weekly time, in the format `D:HH:MM`.
     *
     * `D` is the day of the week, for which 1 represents Monday and 7 represents Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia](https://en.wikipedia.org/wiki/ISO_week_date).
     *
     * `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour.
     *
     * For example, `1:05:00` specifies maintenance at 5 AM Monday.
     */
    public val weeklyMaintenanceStartTime: kotlin.String? = builder.weeklyMaintenanceStartTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.CreateFileSystemOntapConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFileSystemOntapConfiguration(")
        append("automaticBackupRetentionDays=$automaticBackupRetentionDays,")
        append("dailyAutomaticBackupStartTime=$dailyAutomaticBackupStartTime,")
        append("deploymentType=$deploymentType,")
        append("diskIopsConfiguration=$diskIopsConfiguration,")
        append("endpointIpAddressRange=$endpointIpAddressRange,")
        append("fsxAdminPassword=*** Sensitive Data Redacted ***,")
        append("haPairs=$haPairs,")
        append("preferredSubnetId=$preferredSubnetId,")
        append("routeTableIds=$routeTableIds,")
        append("throughputCapacity=$throughputCapacity,")
        append("throughputCapacityPerHaPair=$throughputCapacityPerHaPair,")
        append("weeklyMaintenanceStartTime=$weeklyMaintenanceStartTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = automaticBackupRetentionDays ?: 0
        result = 31 * result + (dailyAutomaticBackupStartTime?.hashCode() ?: 0)
        result = 31 * result + (deploymentType?.hashCode() ?: 0)
        result = 31 * result + (diskIopsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (endpointIpAddressRange?.hashCode() ?: 0)
        result = 31 * result + (fsxAdminPassword?.hashCode() ?: 0)
        result = 31 * result + (haPairs ?: 0)
        result = 31 * result + (preferredSubnetId?.hashCode() ?: 0)
        result = 31 * result + (routeTableIds?.hashCode() ?: 0)
        result = 31 * result + (throughputCapacity ?: 0)
        result = 31 * result + (throughputCapacityPerHaPair ?: 0)
        result = 31 * result + (weeklyMaintenanceStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFileSystemOntapConfiguration

        if (automaticBackupRetentionDays != other.automaticBackupRetentionDays) return false
        if (dailyAutomaticBackupStartTime != other.dailyAutomaticBackupStartTime) return false
        if (deploymentType != other.deploymentType) return false
        if (diskIopsConfiguration != other.diskIopsConfiguration) return false
        if (endpointIpAddressRange != other.endpointIpAddressRange) return false
        if (fsxAdminPassword != other.fsxAdminPassword) return false
        if (haPairs != other.haPairs) return false
        if (preferredSubnetId != other.preferredSubnetId) return false
        if (routeTableIds != other.routeTableIds) return false
        if (throughputCapacity != other.throughputCapacity) return false
        if (throughputCapacityPerHaPair != other.throughputCapacityPerHaPair) return false
        if (weeklyMaintenanceStartTime != other.weeklyMaintenanceStartTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.CreateFileSystemOntapConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `30`.
         */
        public var automaticBackupRetentionDays: kotlin.Int? = null
        /**
         * A recurring daily time, in the format `HH:MM`. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, `05:00` specifies 5 AM daily.
         */
        public var dailyAutomaticBackupStartTime: kotlin.String? = null
        /**
         * Specifies the FSx for ONTAP file system deployment type to use in creating the file system.
         * + `MULTI_AZ_1` - A high availability file system configured for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability. This is a first-generation FSx for ONTAP file system.
         * + `MULTI_AZ_2` - A high availability file system configured for Multi-AZ redundancy to tolerate temporary AZ unavailability. This is a second-generation FSx for ONTAP file system.
         * + `SINGLE_AZ_1` - A file system configured for Single-AZ redundancy. This is a first-generation FSx for ONTAP file system.
         * + `SINGLE_AZ_2` - A file system configured with multiple high-availability (HA) pairs for Single-AZ redundancy. This is a second-generation FSx for ONTAP file system.
         *
         * For information about the use cases for Multi-AZ and Single-AZ deployments, refer to [Choosing a file system deployment type](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-AZ.html).
         */
        public var deploymentType: aws.sdk.kotlin.services.fsx.model.OntapDeploymentType? = null
        /**
         * The SSD IOPS configuration for the FSx for ONTAP file system.
         */
        public var diskIopsConfiguration: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration? = null
        /**
         * (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created. By default in the Amazon FSx API, Amazon FSx selects an unused IP address range for you from the 198.19.* range. By default in the Amazon FSx console, Amazon FSx chooses the last 64 IP addresses from the VPC’s primary CIDR range to use as the endpoint IP address range for the file system. You can have overlapping endpoint IP addresses for file systems deployed in the same VPC/route tables, as long as they don't overlap with any subnet.
         */
        public var endpointIpAddressRange: kotlin.String? = null
        /**
         * The ONTAP administrative password for the `fsxadmin` user with which you administer your file system using the NetApp ONTAP CLI and REST API.
         */
        public var fsxAdminPassword: kotlin.String? = null
        /**
         * Specifies how many high-availability (HA) pairs of file servers will power your file system. First-generation file systems are powered by 1 HA pair. Second-generation multi-AZ file systems are powered by 1 HA pair. Second generation single-AZ file systems are powered by up to 12 HA pairs. The default value is 1. The value of this property affects the values of `StorageCapacity`, `Iops`, and `ThroughputCapacity`. For more information, see [High-availability (HA) pairs](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/administering-file-systems.html#HA-pairs) in the FSx for ONTAP user guide. Block storage protocol support (iSCSI and NVMe over TCP) is disabled on file systems with more than 6 HA pairs. For more information, see [Using block storage protocols](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/supported-fsx-clients.html#using-block-storage).
         *
         * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         * + The value of `HAPairs` is less than 1 or greater than 12.
         * + The value of `HAPairs` is greater than 1 and the value of `DeploymentType` is `SINGLE_AZ_1`, `MULTI_AZ_1`, or `MULTI_AZ_2`.
         */
        public var haPairs: kotlin.Int? = null
        /**
         * Required when `DeploymentType` is set to `MULTI_AZ_1` or `MULTI_AZ_2`. This specifies the subnet in which you want the preferred file server to be located.
         */
        public var preferredSubnetId: kotlin.String? = null
        /**
         * (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
         *
         * Amazon FSx manages these route tables for Multi-AZ file systems using tag-based authentication. These route tables are tagged with `Key: AmazonFSx; Value: ManagedByAmazonFSx`. When creating FSx for ONTAP Multi-AZ file systems using CloudFormation we recommend that you add the `Key: AmazonFSx; Value: ManagedByAmazonFSx` tag manually.
         */
        public var routeTableIds: List<String>? = null
        /**
         * Sets the throughput capacity for the file system that you're creating in megabytes per second (MBps). For more information, see [Managing throughput capacity](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-throughput-capacity.html) in the FSx for ONTAP User Guide.
         *
         * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         * + The value of `ThroughputCapacity` and `ThroughputCapacityPerHAPair` are not the same value.
         * + The value of `ThroughputCapacity` when divided by the value of `HAPairs` is outside of the valid range for `ThroughputCapacity`.
         */
        public var throughputCapacity: kotlin.Int? = null
        /**
         * Use to choose the throughput capacity per HA pair, rather than the total throughput for the file system.
         *
         * You can define either the `ThroughputCapacityPerHAPair` or the `ThroughputCapacity` when creating a file system, but not both.
         *
         * This field and `ThroughputCapacity` are the same for file systems powered by one HA pair.
         * + For `SINGLE_AZ_1` and `MULTI_AZ_1` file systems, valid values are 128, 256, 512, 1024, 2048, or 4096 MBps.
         * + For `SINGLE_AZ_2`, valid values are 1536, 3072, or 6144 MBps.
         * + For `MULTI_AZ_2`, valid values are 384, 768, 1536, 3072, or 6144 MBps.
         *
         * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         * + The value of `ThroughputCapacity` and `ThroughputCapacityPerHAPair` are not the same value for file systems with one HA pair.
         * + The value of deployment type is `SINGLE_AZ_2` and `ThroughputCapacity` / `ThroughputCapacityPerHAPair` is not a valid HA pair (a value between 1 and 12).
         * + The value of `ThroughputCapacityPerHAPair` is not a valid value.
         */
        public var throughputCapacityPerHaPair: kotlin.Int? = null
        /**
         * A recurring weekly time, in the format `D:HH:MM`.
         *
         * `D` is the day of the week, for which 1 represents Monday and 7 represents Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia](https://en.wikipedia.org/wiki/ISO_week_date).
         *
         * `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour.
         *
         * For example, `1:05:00` specifies maintenance at 5 AM Monday.
         */
        public var weeklyMaintenanceStartTime: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.CreateFileSystemOntapConfiguration) : this() {
            this.automaticBackupRetentionDays = x.automaticBackupRetentionDays
            this.dailyAutomaticBackupStartTime = x.dailyAutomaticBackupStartTime
            this.deploymentType = x.deploymentType
            this.diskIopsConfiguration = x.diskIopsConfiguration
            this.endpointIpAddressRange = x.endpointIpAddressRange
            this.fsxAdminPassword = x.fsxAdminPassword
            this.haPairs = x.haPairs
            this.preferredSubnetId = x.preferredSubnetId
            this.routeTableIds = x.routeTableIds
            this.throughputCapacity = x.throughputCapacity
            this.throughputCapacityPerHaPair = x.throughputCapacityPerHaPair
            this.weeklyMaintenanceStartTime = x.weeklyMaintenanceStartTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.CreateFileSystemOntapConfiguration = CreateFileSystemOntapConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration] inside the given [block]
         */
        public fun diskIopsConfiguration(block: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration.Builder.() -> kotlin.Unit) {
            this.diskIopsConfiguration = aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
