// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The Lustre metadata performance configuration for the creation of an Amazon FSx for Lustre file system using a `PERSISTENT_2` deployment type. The configuration uses a Metadata IOPS value to set the maximum rate of metadata disk IOPS supported by the file system.
 *
 * After creation, the file system supports increasing metadata performance. For more information on Metadata IOPS, see [Lustre metadata performance configuration](https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-metadata-performance.html#metadata-configuration) in the *Amazon FSx for Lustre User Guide*.
 */
public class CreateFileSystemLustreMetadataConfiguration private constructor(builder: Builder) {
    /**
     * (USER_PROVISIONED mode only) Specifies the number of Metadata IOPS to provision for the file system. This parameter sets the maximum rate of metadata disk IOPS supported by the file system. Valid values are `1500`, `3000`, `6000`, `12000`, and multiples of `12000` up to a maximum of `192000`.
     *
     * Iops doesn’t have a default value. If you're using USER_PROVISIONED mode, you can choose to specify a valid value. If you're using AUTOMATIC mode, you cannot specify a value because FSx for Lustre automatically sets the value based on your file system storage capacity.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * The metadata configuration mode for provisioning Metadata IOPS for an FSx for Lustre file system using a `PERSISTENT_2` deployment type.
     * + In AUTOMATIC mode, FSx for Lustre automatically provisions and scales the number of Metadata IOPS for your file system based on your file system storage capacity.
     * + In USER_PROVISIONED mode, you specify the number of Metadata IOPS to provision for your file system.
     */
    public val mode: aws.sdk.kotlin.services.fsx.model.MetadataConfigurationMode? = builder.mode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.CreateFileSystemLustreMetadataConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFileSystemLustreMetadataConfiguration(")
        append("iops=$iops,")
        append("mode=$mode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = iops ?: 0
        result = 31 * result + (mode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFileSystemLustreMetadataConfiguration

        if (iops != other.iops) return false
        if (mode != other.mode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.CreateFileSystemLustreMetadataConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * (USER_PROVISIONED mode only) Specifies the number of Metadata IOPS to provision for the file system. This parameter sets the maximum rate of metadata disk IOPS supported by the file system. Valid values are `1500`, `3000`, `6000`, `12000`, and multiples of `12000` up to a maximum of `192000`.
         *
         * Iops doesn’t have a default value. If you're using USER_PROVISIONED mode, you can choose to specify a valid value. If you're using AUTOMATIC mode, you cannot specify a value because FSx for Lustre automatically sets the value based on your file system storage capacity.
         */
        public var iops: kotlin.Int? = null
        /**
         * The metadata configuration mode for provisioning Metadata IOPS for an FSx for Lustre file system using a `PERSISTENT_2` deployment type.
         * + In AUTOMATIC mode, FSx for Lustre automatically provisions and scales the number of Metadata IOPS for your file system based on your file system storage capacity.
         * + In USER_PROVISIONED mode, you specify the number of Metadata IOPS to provision for your file system.
         */
        public var mode: aws.sdk.kotlin.services.fsx.model.MetadataConfigurationMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.CreateFileSystemLustreMetadataConfiguration) : this() {
            this.iops = x.iops
            this.mode = x.mode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.CreateFileSystemLustreMetadataConfiguration = CreateFileSystemLustreMetadataConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
