// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateDataRepositoryAssociationRequest private constructor(builder: Builder) {
    /**
     * Set to `true` to run an import data repository task to import metadata from the data repository to the file system after the data repository association is created. Default is `false`.
     */
    public val batchImportMetaDataOnCreate: kotlin.Boolean? = builder.batchImportMetaDataOnCreate
    /**
     * (Optional) An idempotency token for resource creation, in a string of up to 63 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3 bucket or prefix in the format `s3://bucket-name/prefix/` (where `prefix` is optional). This path specifies where in the S3 data repository files will be imported from or exported to.
     */
    public val dataRepositoryPath: kotlin.String? = builder.dataRepositoryPath
    /**
     * The globally unique ID of the file system, assigned by Amazon FSx.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * A path on the file system that points to a high-level directory (such as `/ns1/`) or subdirectory (such as `/ns1/subdir/`) that will be mapped 1-1 with `DataRepositoryPath`. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path `/ns1/`, then you cannot link another data repository with file system path `/ns1/ns2`.
     *
     * This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
     *
     * If you specify only a forward slash (`/`) as the file system path, you can link only one data repository to the file system. You can only specify "/" as the file system path for the first data repository associated with a file system.
     */
    public val fileSystemPath: kotlin.String? = builder.fileSystemPath
    /**
     * For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
     *
     * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
     */
    public val importedFileChunkSize: kotlin.Int? = builder.importedFileChunkSize
    /**
     * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
     */
    public val s3: aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration? = builder.s3
    /**
     * A list of `Tag` values, with a maximum of 50 elements.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryAssociationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDataRepositoryAssociationRequest(")
        append("batchImportMetaDataOnCreate=$batchImportMetaDataOnCreate,")
        append("clientRequestToken=$clientRequestToken,")
        append("dataRepositoryPath=$dataRepositoryPath,")
        append("fileSystemId=$fileSystemId,")
        append("fileSystemPath=$fileSystemPath,")
        append("importedFileChunkSize=$importedFileChunkSize,")
        append("s3=$s3,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchImportMetaDataOnCreate?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (dataRepositoryPath?.hashCode() ?: 0)
        result = 31 * result + (fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (fileSystemPath?.hashCode() ?: 0)
        result = 31 * result + (importedFileChunkSize ?: 0)
        result = 31 * result + (s3?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDataRepositoryAssociationRequest

        if (batchImportMetaDataOnCreate != other.batchImportMetaDataOnCreate) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (dataRepositoryPath != other.dataRepositoryPath) return false
        if (fileSystemId != other.fileSystemId) return false
        if (fileSystemPath != other.fileSystemPath) return false
        if (importedFileChunkSize != other.importedFileChunkSize) return false
        if (s3 != other.s3) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryAssociationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Set to `true` to run an import data repository task to import metadata from the data repository to the file system after the data repository association is created. Default is `false`.
         */
        public var batchImportMetaDataOnCreate: kotlin.Boolean? = null
        /**
         * (Optional) An idempotency token for resource creation, in a string of up to 63 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3 bucket or prefix in the format `s3://bucket-name/prefix/` (where `prefix` is optional). This path specifies where in the S3 data repository files will be imported from or exported to.
         */
        public var dataRepositoryPath: kotlin.String? = null
        /**
         * The globally unique ID of the file system, assigned by Amazon FSx.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * A path on the file system that points to a high-level directory (such as `/ns1/`) or subdirectory (such as `/ns1/subdir/`) that will be mapped 1-1 with `DataRepositoryPath`. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path `/ns1/`, then you cannot link another data repository with file system path `/ns1/ns2`.
         *
         * This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
         *
         * If you specify only a forward slash (`/`) as the file system path, you can link only one data repository to the file system. You can only specify "/" as the file system path for the first data repository associated with a file system.
         */
        public var fileSystemPath: kotlin.String? = null
        /**
         * For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
         *
         * The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
         */
        public var importedFileChunkSize: kotlin.Int? = null
        /**
         * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
         */
        public var s3: aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration? = null
        /**
         * A list of `Tag` values, with a maximum of 50 elements.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryAssociationRequest) : this() {
            this.batchImportMetaDataOnCreate = x.batchImportMetaDataOnCreate
            this.clientRequestToken = x.clientRequestToken
            this.dataRepositoryPath = x.dataRepositoryPath
            this.fileSystemId = x.fileSystemId
            this.fileSystemPath = x.fileSystemPath
            this.importedFileChunkSize = x.importedFileChunkSize
            this.s3 = x.s3
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryAssociationRequest = CreateDataRepositoryAssociationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration] inside the given [block]
         */
        public fun s3(block: aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration.Builder.() -> kotlin.Unit) {
            this.s3 = aws.sdk.kotlin.services.fsx.model.S3DataRepositoryConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
