// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CopyBackupRequest private constructor(builder: Builder) {
    /**
     * (Optional) An idempotency token for resource creation, in a string of up to 63 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * A Boolean flag indicating whether tags from the source backup should be copied to the backup copy. This value defaults to `false`.
     *
     * If you set `CopyTags` to `true` and the source backup has existing tags, you can use the `Tags` parameter to create new tags, provided that the sum of the source backup tags and the new tags doesn't exceed 50. Both sets of tags are merged. If there are tag conflicts (for example, two tags with the same key but different values), the tags created with the `Tags` parameter take precedence.
     */
    public val copyTags: kotlin.Boolean? = builder.copyTags
    /**
     * Specifies the ID of the Key Management Service (KMS) key to use for encrypting data on Amazon FSx file systems, as follows:
     * + Amazon FSx for Lustre `PERSISTENT_1` and `PERSISTENT_2` deployment types only.`SCRATCH_1` and `SCRATCH_2` types are encrypted using the Amazon FSx service KMS key for your account.
     * + Amazon FSx for NetApp ONTAP
     * + Amazon FSx for OpenZFS
     * + Amazon FSx for Windows File Server
     *
     * If a `KmsKeyId` isn't specified, the Amazon FSx-managed KMS key for your account is used. For more information, see [Encrypt](https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html) in the *Key Management Service API Reference*.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The ID of the source backup. Specifies the ID of the backup that's being copied.
     */
    public val sourceBackupId: kotlin.String? = builder.sourceBackupId
    /**
     * The source Amazon Web Services Region of the backup. Specifies the Amazon Web Services Region from which the backup is being copied. The source and destination Regions must be in the same Amazon Web Services partition. If you don't specify a Region, `SourceRegion` defaults to the Region where the request is sent from (in-Region copy).
     */
    public val sourceRegion: kotlin.String? = builder.sourceRegion
    /**
     * A list of `Tag` values, with a maximum of 50 elements.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.CopyBackupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyBackupRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("copyTags=$copyTags,")
        append("kmsKeyId=$kmsKeyId,")
        append("sourceBackupId=$sourceBackupId,")
        append("sourceRegion=$sourceRegion,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (copyTags?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (sourceBackupId?.hashCode() ?: 0)
        result = 31 * result + (sourceRegion?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyBackupRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (copyTags != other.copyTags) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (sourceBackupId != other.sourceBackupId) return false
        if (sourceRegion != other.sourceRegion) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.CopyBackupRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * (Optional) An idempotency token for resource creation, in a string of up to 63 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * A Boolean flag indicating whether tags from the source backup should be copied to the backup copy. This value defaults to `false`.
         *
         * If you set `CopyTags` to `true` and the source backup has existing tags, you can use the `Tags` parameter to create new tags, provided that the sum of the source backup tags and the new tags doesn't exceed 50. Both sets of tags are merged. If there are tag conflicts (for example, two tags with the same key but different values), the tags created with the `Tags` parameter take precedence.
         */
        public var copyTags: kotlin.Boolean? = null
        /**
         * Specifies the ID of the Key Management Service (KMS) key to use for encrypting data on Amazon FSx file systems, as follows:
         * + Amazon FSx for Lustre `PERSISTENT_1` and `PERSISTENT_2` deployment types only.`SCRATCH_1` and `SCRATCH_2` types are encrypted using the Amazon FSx service KMS key for your account.
         * + Amazon FSx for NetApp ONTAP
         * + Amazon FSx for OpenZFS
         * + Amazon FSx for Windows File Server
         *
         * If a `KmsKeyId` isn't specified, the Amazon FSx-managed KMS key for your account is used. For more information, see [Encrypt](https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html) in the *Key Management Service API Reference*.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The ID of the source backup. Specifies the ID of the backup that's being copied.
         */
        public var sourceBackupId: kotlin.String? = null
        /**
         * The source Amazon Web Services Region of the backup. Specifies the Amazon Web Services Region from which the backup is being copied. The source and destination Regions must be in the same Amazon Web Services partition. If you don't specify a Region, `SourceRegion` defaults to the Region where the request is sent from (in-Region copy).
         */
        public var sourceRegion: kotlin.String? = null
        /**
         * A list of `Tag` values, with a maximum of 50 elements.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.CopyBackupRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.copyTags = x.copyTags
            this.kmsKeyId = x.kmsKeyId
            this.sourceBackupId = x.sourceBackupId
            this.sourceRegion = x.sourceRegion
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.CopyBackupRequest = CopyBackupRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
