// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides a report detailing the data repository task results of the files processed that match the criteria specified in the report `Scope` parameter. FSx delivers the report to the file system's linked data repository in Amazon S3, using the path specified in the report `Path` parameter. You can specify whether or not a report gets generated for a task using the `Enabled` parameter.
 */
public class CompletionReport private constructor(builder: Builder) {
    /**
     * Set `Enabled` to `True` to generate a `CompletionReport` when the task completes. If set to `true`, then you need to provide a report `Scope`, `Path`, and `Format`. Set `Enabled` to `False` if you do not want a `CompletionReport` generated when the task completes.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * Required if `Enabled` is set to `true`. Specifies the format of the `CompletionReport`. `REPORT_CSV_20191124` is the only format currently supported. When `Format` is set to `REPORT_CSV_20191124`, the `CompletionReport` is provided in CSV format, and is delivered to `{path}/task-{id}/failures.csv`.
     */
    public val format: aws.sdk.kotlin.services.fsx.model.ReportFormat? = builder.format
    /**
     * Required if `Enabled` is set to `true`. Specifies the location of the report on the file system's linked S3 data repository. An absolute path that defines where the completion report will be stored in the destination location. The `Path` you provide must be located within the file system’s ExportPath. An example `Path` value is "s3://amzn-s3-demo-bucket/myExportPath/optionalPrefix". The report provides the following information for each file in the report: FilePath, FileStatus, and ErrorCode.
     */
    public val path: kotlin.String? = builder.path
    /**
     * Required if `Enabled` is set to `true`. Specifies the scope of the `CompletionReport`; `FAILED_FILES_ONLY` is the only scope currently supported. When `Scope` is set to `FAILED_FILES_ONLY`, the `CompletionReport` only contains information about files that the data repository task failed to process.
     */
    public val scope: aws.sdk.kotlin.services.fsx.model.ReportScope? = builder.scope

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.CompletionReport = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CompletionReport(")
        append("enabled=$enabled,")
        append("format=$format,")
        append("path=$path,")
        append("scope=$scope")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CompletionReport

        if (enabled != other.enabled) return false
        if (format != other.format) return false
        if (path != other.path) return false
        if (scope != other.scope) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.CompletionReport = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Set `Enabled` to `True` to generate a `CompletionReport` when the task completes. If set to `true`, then you need to provide a report `Scope`, `Path`, and `Format`. Set `Enabled` to `False` if you do not want a `CompletionReport` generated when the task completes.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * Required if `Enabled` is set to `true`. Specifies the format of the `CompletionReport`. `REPORT_CSV_20191124` is the only format currently supported. When `Format` is set to `REPORT_CSV_20191124`, the `CompletionReport` is provided in CSV format, and is delivered to `{path}/task-{id}/failures.csv`.
         */
        public var format: aws.sdk.kotlin.services.fsx.model.ReportFormat? = null
        /**
         * Required if `Enabled` is set to `true`. Specifies the location of the report on the file system's linked S3 data repository. An absolute path that defines where the completion report will be stored in the destination location. The `Path` you provide must be located within the file system’s ExportPath. An example `Path` value is "s3://amzn-s3-demo-bucket/myExportPath/optionalPrefix". The report provides the following information for each file in the report: FilePath, FileStatus, and ErrorCode.
         */
        public var path: kotlin.String? = null
        /**
         * Required if `Enabled` is set to `true`. Specifies the scope of the `CompletionReport`; `FAILED_FILES_ONLY` is the only scope currently supported. When `Scope` is set to `FAILED_FILES_ONLY`, the `CompletionReport` only contains information about files that the data repository task failed to process.
         */
        public var scope: aws.sdk.kotlin.services.fsx.model.ReportScope? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.CompletionReport) : this() {
            this.enabled = x.enabled
            this.format = x.format
            this.path = x.path
            this.scope = x.scope
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.CompletionReport = CompletionReport(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
