// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Sets the autocommit period of files in an FSx for ONTAP SnapLock volume, which determines how long the files must remain unmodified before they're automatically transitioned to the write once, read many (WORM) state.
 *
 * For more information, see [Autocommit](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/worm-state.html#worm-state-autocommit).
 */
public class AutocommitPeriod private constructor(builder: Builder) {
    /**
     * Defines the type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. The default value is `NONE`.
     */
    public val type: aws.sdk.kotlin.services.fsx.model.AutocommitPeriodType? = builder.type
    /**
     * Defines the amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. The following ranges are valid:
     * + `Minutes`: 5 - 65,535
     * + `Hours`: 1 - 65,535
     * + `Days`: 1 - 3,650
     * + `Months`: 1 - 120
     * + `Years`: 1 - 10
     */
    public val value: kotlin.Int? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.AutocommitPeriod = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutocommitPeriod(")
        append("type=$type,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = type?.hashCode() ?: 0
        result = 31 * result + (value ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutocommitPeriod

        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.AutocommitPeriod = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Defines the type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. The default value is `NONE`.
         */
        public var type: aws.sdk.kotlin.services.fsx.model.AutocommitPeriodType? = null
        /**
         * Defines the amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. The following ranges are valid:
         * + `Minutes`: 5 - 65,535
         * + `Hours`: 1 - 65,535
         * + `Days`: 1 - 3,650
         * + `Months`: 1 - 120
         * + `Years`: 1 - 10
         */
        public var value: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.AutocommitPeriod) : this() {
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.AutocommitPeriod = AutocommitPeriod(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
