// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a data repository association's automatic export policy. The `AutoExportPolicy` defines the types of updated objects on the file system that will be automatically exported to the data repository. As you create, modify, or delete files, Amazon FSx for Lustre automatically exports the defined changes asynchronously once your application finishes modifying the file.
 *
 * The `AutoExportPolicy` is only supported on Amazon FSx for Lustre file systems with a data repository association.
 */
public class AutoExportPolicy private constructor(builder: Builder) {
    /**
     * The `AutoExportPolicy` can have the following event values:
     * + `NEW` - New files and directories are automatically exported to the data repository as they are added to the file system.
     * + `CHANGED` - Changes to files and directories on the file system are automatically exported to the data repository.
     * + `DELETED` - Files and directories are automatically deleted on the data repository when they are deleted on the file system.
     *
     * You can define any combination of event types for your `AutoExportPolicy`.
     */
    public val events: List<EventType>? = builder.events

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.AutoExportPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoExportPolicy(")
        append("events=$events")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = events?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoExportPolicy

        if (events != other.events) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.AutoExportPolicy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The `AutoExportPolicy` can have the following event values:
         * + `NEW` - New files and directories are automatically exported to the data repository as they are added to the file system.
         * + `CHANGED` - Changes to files and directories on the file system are automatically exported to the data repository.
         * + `DELETED` - Files and directories are automatically deleted on the data repository when they are deleted on the file system.
         *
         * You can define any combination of event types for your `AutoExportPolicy`.
         */
        public var events: List<EventType>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.AutoExportPolicy) : this() {
            this.events = x.events
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.AutoExportPolicy = AutoExportPolicy(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
