// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A DNS alias that is associated with the file system. You can use a DNS alias to access a file system using user-defined DNS names, in addition to the default DNS name that Amazon FSx assigns to the file system. For more information, see [DNS aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html) in the *FSx for Windows File Server User Guide*.
 */
public class Alias private constructor(builder: Builder) {
    /**
     * Describes the state of the DNS alias.
     * + AVAILABLE - The DNS alias is associated with an Amazon FSx file system.
     * + CREATING - Amazon FSx is creating the DNS alias and associating it with the file system.
     * + CREATE_FAILED - Amazon FSx was unable to associate the DNS alias with the file system.
     * + DELETING - Amazon FSx is disassociating the DNS alias from the file system and deleting it.
     * + DELETE_FAILED - Amazon FSx was unable to disassociate the DNS alias from the file system.
     */
    public val lifecycle: aws.sdk.kotlin.services.fsx.model.AliasLifecycle? = builder.lifecycle
    /**
     * The name of the DNS alias. The alias name has to meet the following requirements:
     * + Formatted as a fully-qualified domain name (FQDN), `hostname.domain`, for example, `accounting.example.com`.
     * + Can contain alphanumeric characters, the underscore (_), and the hyphen (-).
     * + Cannot start or end with a hyphen.
     * + Can start with a numeric.
     *
     * For DNS names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them: as uppercase letters, lowercase letters, or the corresponding letters in escape codes.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.Alias = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Alias(")
        append("lifecycle=$lifecycle,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lifecycle?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Alias

        if (lifecycle != other.lifecycle) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.Alias = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Describes the state of the DNS alias.
         * + AVAILABLE - The DNS alias is associated with an Amazon FSx file system.
         * + CREATING - Amazon FSx is creating the DNS alias and associating it with the file system.
         * + CREATE_FAILED - Amazon FSx was unable to associate the DNS alias with the file system.
         * + DELETING - Amazon FSx is disassociating the DNS alias from the file system and deleting it.
         * + DELETE_FAILED - Amazon FSx was unable to disassociate the DNS alias from the file system.
         */
        public var lifecycle: aws.sdk.kotlin.services.fsx.model.AliasLifecycle? = null
        /**
         * The name of the DNS alias. The alias name has to meet the following requirements:
         * + Formatted as a fully-qualified domain name (FQDN), `hostname.domain`, for example, `accounting.example.com`.
         * + Can contain alphanumeric characters, the underscore (_), and the hyphen (-).
         * + Cannot start or end with a hyphen.
         * + Can start with a numeric.
         *
         * For DNS names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them: as uppercase letters, lowercase letters, or the corresponding letters in escape codes.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.Alias) : this() {
            this.lifecycle = x.lifecycle
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.Alias = Alias(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
