// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a specific Amazon FSx administrative action for the current Windows, Lustre, OpenZFS, or ONTAP file system or volume.
 */
public class AdministrativeAction private constructor(builder: Builder) {
    /**
     * Describes the type of administrative action, as follows:
     * + `FILE_SYSTEM_UPDATE` - A file system update administrative action initiated from the Amazon FSx console, API (`UpdateFileSystem`), or CLI (`update-file-system`).
     * + `THROUGHPUT_OPTIMIZATION` - After the `FILE_SYSTEM_UPDATE` task to increase a file system's throughput capacity has been completed successfully, a `THROUGHPUT_OPTIMIZATION` task starts.You can track the storage-optimization progress using the `ProgressPercent` property. When `THROUGHPUT_OPTIMIZATION` has been completed successfully, the parent `FILE_SYSTEM_UPDATE` action status changes to `COMPLETED`. For more information, see [Managing throughput capacity](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html) in the *Amazon FSx for Windows File Server User Guide*.
     * + `STORAGE_OPTIMIZATION` - After the `FILE_SYSTEM_UPDATE` task to increase a file system's storage capacity has completed successfully, a `STORAGE_OPTIMIZATION` task starts.
     *    + For Windows and ONTAP, storage optimization is the process of migrating the file system data to newer larger disks.
     *    + For Lustre, storage optimization consists of rebalancing the data across the existing and newly added file servers.
     * You can track the storage-optimization progress using the `ProgressPercent` property. When `STORAGE_OPTIMIZATION` has been completed successfully, the parent `FILE_SYSTEM_UPDATE` action status changes to `COMPLETED`. For more information, see [Managing storage capacity](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html) in the *Amazon FSx for Windows File Server User Guide*, [Managing storage capacity](https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html) in the *Amazon FSx for Lustre User Guide*, and [Managing storage capacity and provisioned IOPS](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-storage-capacity.html) in the *Amazon FSx for NetApp ONTAP User Guide*.
     * + `FILE_SYSTEM_ALIAS_ASSOCIATION` - A file system update to associate a new Domain Name System (DNS) alias with the file system. For more information, see [ AssociateFileSystemAliases](https://docs.aws.amazon.com/fsx/latest/APIReference/API_AssociateFileSystemAliases.html).
     * + `FILE_SYSTEM_ALIAS_DISASSOCIATION` - A file system update to disassociate a DNS alias from the file system. For more information, see [DisassociateFileSystemAliases](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DisassociateFileSystemAliases.html).
     * + `IOPS_OPTIMIZATION` - After the `FILE_SYSTEM_UPDATE` task to increase a file system's throughput capacity has been completed successfully, a `IOPS_OPTIMIZATION` task starts.You can track the storage-optimization progress using the `ProgressPercent` property. When `IOPS_OPTIMIZATION` has been completed successfully, the parent `FILE_SYSTEM_UPDATE` action status changes to `COMPLETED`. For more information, see [Managing provisioned SSD IOPS](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-provisioned-ssd-iops.html) in the Amazon FSx for Windows File Server User Guide.
     * + `STORAGE_TYPE_OPTIMIZATION` - After the `FILE_SYSTEM_UPDATE` task to increase a file system's throughput capacity has been completed successfully, a `STORAGE_TYPE_OPTIMIZATION` task starts.You can track the storage-optimization progress using the `ProgressPercent` property. When `STORAGE_TYPE_OPTIMIZATION` has been completed successfully, the parent `FILE_SYSTEM_UPDATE` action status changes to `COMPLETED`.
     * + `VOLUME_UPDATE` - A volume update to an Amazon FSx for OpenZFS volume initiated from the Amazon FSx console, API (`UpdateVolume`), or CLI (`update-volume`).
     * + `VOLUME_RESTORE` - An Amazon FSx for OpenZFS volume is returned to the state saved by the specified snapshot, initiated from an API (`RestoreVolumeFromSnapshot`) or CLI (`restore-volume-from-snapshot`).
     * + `SNAPSHOT_UPDATE` - A snapshot update to an Amazon FSx for OpenZFS volume initiated from the Amazon FSx console, API (`UpdateSnapshot`), or CLI (`update-snapshot`).
     * + `RELEASE_NFS_V3_LOCKS` - Tracks the release of Network File System (NFS) V3 locks on an Amazon FSx for OpenZFS file system.
     * + `DOWNLOAD_DATA_FROM_BACKUP` - An FSx for ONTAP backup is being restored to a new volume on a second-generation file system. Once the all the file metadata is loaded onto the volume, you can mount the volume with read-only access. during this process.
     * + `VOLUME_INITIALIZE_WITH_SNAPSHOT` - A volume is being created from a snapshot on a different FSx for OpenZFS file system. You can initiate this from the Amazon FSx console, API (`CreateVolume`), or CLI (`create-volume`) when using the using the `FULL_COPY` strategy.
     * + `VOLUME_UPDATE_WITH_SNAPSHOT` - A volume is being updated from a snapshot on a different FSx for OpenZFS file system. You can initiate this from the Amazon FSx console, API (`CopySnapshotAndUpdateVolume`), or CLI (`copy-snapshot-and-update-volume`).
     */
    public val administrativeActionType: aws.sdk.kotlin.services.fsx.model.AdministrativeActionType? = builder.administrativeActionType
    /**
     * Provides information about a failed administrative action.
     */
    public val failureDetails: aws.sdk.kotlin.services.fsx.model.AdministrativeActionFailureDetails? = builder.failureDetails
    /**
     * The percentage-complete status of a `STORAGE_OPTIMIZATION` or `DOWNLOAD_DATA_FROM_BACKUP` administrative action. Does not apply to any other administrative action type.
     */
    public val progressPercent: kotlin.Int? = builder.progressPercent
    /**
     * The remaining bytes to transfer for the FSx for OpenZFS snapshot that you're copying.
     */
    public val remainingTransferBytes: kotlin.Long? = builder.remainingTransferBytes
    /**
     * The time that the administrative action request was received.
     */
    public val requestTime: aws.smithy.kotlin.runtime.time.Instant? = builder.requestTime
    /**
     * The status of the administrative action, as follows:
     * + `FAILED` - Amazon FSx failed to process the administrative action successfully.
     * + `IN_PROGRESS` - Amazon FSx is processing the administrative action.
     * + `PENDING` - Amazon FSx is waiting to process the administrative action.
     * + `COMPLETED` - Amazon FSx has finished processing the administrative task.For a backup restore to a second-generation FSx for ONTAP file system, indicates that all data has been downloaded to the volume, and clients now have read-write access to volume.
     * + `UPDATED_OPTIMIZING` - For a storage-capacity increase update, Amazon FSx has updated the file system with the new storage capacity, and is now performing the storage-optimization process.
     * + `PENDING` - For a backup restore to a second-generation FSx for ONTAP file system, indicates that the file metadata is being downloaded onto the volume. The volume's Lifecycle state is CREATING.
     * + `IN_PROGRESS` - For a backup restore to a second-generation FSx for ONTAP file system, indicates that all metadata has been downloaded to the new volume and client can access data with read-only access while Amazon FSx downloads the file data to the volume. Track the progress of this process with the `ProgressPercent` element.
     */
    public val status: aws.sdk.kotlin.services.fsx.model.Status? = builder.status
    /**
     * The target value for the administration action, provided in the `UpdateFileSystem` operation. Returned for `FILE_SYSTEM_UPDATE` administrative actions.
     */
    public val targetFileSystemValues: aws.sdk.kotlin.services.fsx.model.FileSystem? = builder.targetFileSystemValues
    /**
     * A snapshot of an Amazon FSx for OpenZFS volume.
     */
    public val targetSnapshotValues: aws.sdk.kotlin.services.fsx.model.Snapshot? = builder.targetSnapshotValues
    /**
     * Describes an Amazon FSx volume.
     */
    public val targetVolumeValues: aws.sdk.kotlin.services.fsx.model.Volume? = builder.targetVolumeValues
    /**
     * The number of bytes that have transferred for the FSx for OpenZFS snapshot that you're copying.
     */
    public val totalTransferBytes: kotlin.Long? = builder.totalTransferBytes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.AdministrativeAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdministrativeAction(")
        append("administrativeActionType=$administrativeActionType,")
        append("failureDetails=$failureDetails,")
        append("progressPercent=$progressPercent,")
        append("remainingTransferBytes=$remainingTransferBytes,")
        append("requestTime=$requestTime,")
        append("status=$status,")
        append("targetFileSystemValues=$targetFileSystemValues,")
        append("targetSnapshotValues=$targetSnapshotValues,")
        append("targetVolumeValues=$targetVolumeValues,")
        append("totalTransferBytes=$totalTransferBytes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = administrativeActionType?.hashCode() ?: 0
        result = 31 * result + (failureDetails?.hashCode() ?: 0)
        result = 31 * result + (progressPercent ?: 0)
        result = 31 * result + (remainingTransferBytes?.hashCode() ?: 0)
        result = 31 * result + (requestTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetFileSystemValues?.hashCode() ?: 0)
        result = 31 * result + (targetSnapshotValues?.hashCode() ?: 0)
        result = 31 * result + (targetVolumeValues?.hashCode() ?: 0)
        result = 31 * result + (totalTransferBytes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdministrativeAction

        if (administrativeActionType != other.administrativeActionType) return false
        if (failureDetails != other.failureDetails) return false
        if (progressPercent != other.progressPercent) return false
        if (remainingTransferBytes != other.remainingTransferBytes) return false
        if (requestTime != other.requestTime) return false
        if (status != other.status) return false
        if (targetFileSystemValues != other.targetFileSystemValues) return false
        if (targetSnapshotValues != other.targetSnapshotValues) return false
        if (targetVolumeValues != other.targetVolumeValues) return false
        if (totalTransferBytes != other.totalTransferBytes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.AdministrativeAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Describes the type of administrative action, as follows:
         * + `FILE_SYSTEM_UPDATE` - A file system update administrative action initiated from the Amazon FSx console, API (`UpdateFileSystem`), or CLI (`update-file-system`).
         * + `THROUGHPUT_OPTIMIZATION` - After the `FILE_SYSTEM_UPDATE` task to increase a file system's throughput capacity has been completed successfully, a `THROUGHPUT_OPTIMIZATION` task starts.You can track the storage-optimization progress using the `ProgressPercent` property. When `THROUGHPUT_OPTIMIZATION` has been completed successfully, the parent `FILE_SYSTEM_UPDATE` action status changes to `COMPLETED`. For more information, see [Managing throughput capacity](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html) in the *Amazon FSx for Windows File Server User Guide*.
         * + `STORAGE_OPTIMIZATION` - After the `FILE_SYSTEM_UPDATE` task to increase a file system's storage capacity has completed successfully, a `STORAGE_OPTIMIZATION` task starts.
         *    + For Windows and ONTAP, storage optimization is the process of migrating the file system data to newer larger disks.
         *    + For Lustre, storage optimization consists of rebalancing the data across the existing and newly added file servers.
         * You can track the storage-optimization progress using the `ProgressPercent` property. When `STORAGE_OPTIMIZATION` has been completed successfully, the parent `FILE_SYSTEM_UPDATE` action status changes to `COMPLETED`. For more information, see [Managing storage capacity](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html) in the *Amazon FSx for Windows File Server User Guide*, [Managing storage capacity](https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html) in the *Amazon FSx for Lustre User Guide*, and [Managing storage capacity and provisioned IOPS](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-storage-capacity.html) in the *Amazon FSx for NetApp ONTAP User Guide*.
         * + `FILE_SYSTEM_ALIAS_ASSOCIATION` - A file system update to associate a new Domain Name System (DNS) alias with the file system. For more information, see [ AssociateFileSystemAliases](https://docs.aws.amazon.com/fsx/latest/APIReference/API_AssociateFileSystemAliases.html).
         * + `FILE_SYSTEM_ALIAS_DISASSOCIATION` - A file system update to disassociate a DNS alias from the file system. For more information, see [DisassociateFileSystemAliases](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DisassociateFileSystemAliases.html).
         * + `IOPS_OPTIMIZATION` - After the `FILE_SYSTEM_UPDATE` task to increase a file system's throughput capacity has been completed successfully, a `IOPS_OPTIMIZATION` task starts.You can track the storage-optimization progress using the `ProgressPercent` property. When `IOPS_OPTIMIZATION` has been completed successfully, the parent `FILE_SYSTEM_UPDATE` action status changes to `COMPLETED`. For more information, see [Managing provisioned SSD IOPS](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-provisioned-ssd-iops.html) in the Amazon FSx for Windows File Server User Guide.
         * + `STORAGE_TYPE_OPTIMIZATION` - After the `FILE_SYSTEM_UPDATE` task to increase a file system's throughput capacity has been completed successfully, a `STORAGE_TYPE_OPTIMIZATION` task starts.You can track the storage-optimization progress using the `ProgressPercent` property. When `STORAGE_TYPE_OPTIMIZATION` has been completed successfully, the parent `FILE_SYSTEM_UPDATE` action status changes to `COMPLETED`.
         * + `VOLUME_UPDATE` - A volume update to an Amazon FSx for OpenZFS volume initiated from the Amazon FSx console, API (`UpdateVolume`), or CLI (`update-volume`).
         * + `VOLUME_RESTORE` - An Amazon FSx for OpenZFS volume is returned to the state saved by the specified snapshot, initiated from an API (`RestoreVolumeFromSnapshot`) or CLI (`restore-volume-from-snapshot`).
         * + `SNAPSHOT_UPDATE` - A snapshot update to an Amazon FSx for OpenZFS volume initiated from the Amazon FSx console, API (`UpdateSnapshot`), or CLI (`update-snapshot`).
         * + `RELEASE_NFS_V3_LOCKS` - Tracks the release of Network File System (NFS) V3 locks on an Amazon FSx for OpenZFS file system.
         * + `DOWNLOAD_DATA_FROM_BACKUP` - An FSx for ONTAP backup is being restored to a new volume on a second-generation file system. Once the all the file metadata is loaded onto the volume, you can mount the volume with read-only access. during this process.
         * + `VOLUME_INITIALIZE_WITH_SNAPSHOT` - A volume is being created from a snapshot on a different FSx for OpenZFS file system. You can initiate this from the Amazon FSx console, API (`CreateVolume`), or CLI (`create-volume`) when using the using the `FULL_COPY` strategy.
         * + `VOLUME_UPDATE_WITH_SNAPSHOT` - A volume is being updated from a snapshot on a different FSx for OpenZFS file system. You can initiate this from the Amazon FSx console, API (`CopySnapshotAndUpdateVolume`), or CLI (`copy-snapshot-and-update-volume`).
         */
        public var administrativeActionType: aws.sdk.kotlin.services.fsx.model.AdministrativeActionType? = null
        /**
         * Provides information about a failed administrative action.
         */
        public var failureDetails: aws.sdk.kotlin.services.fsx.model.AdministrativeActionFailureDetails? = null
        /**
         * The percentage-complete status of a `STORAGE_OPTIMIZATION` or `DOWNLOAD_DATA_FROM_BACKUP` administrative action. Does not apply to any other administrative action type.
         */
        public var progressPercent: kotlin.Int? = null
        /**
         * The remaining bytes to transfer for the FSx for OpenZFS snapshot that you're copying.
         */
        public var remainingTransferBytes: kotlin.Long? = null
        /**
         * The time that the administrative action request was received.
         */
        public var requestTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the administrative action, as follows:
         * + `FAILED` - Amazon FSx failed to process the administrative action successfully.
         * + `IN_PROGRESS` - Amazon FSx is processing the administrative action.
         * + `PENDING` - Amazon FSx is waiting to process the administrative action.
         * + `COMPLETED` - Amazon FSx has finished processing the administrative task.For a backup restore to a second-generation FSx for ONTAP file system, indicates that all data has been downloaded to the volume, and clients now have read-write access to volume.
         * + `UPDATED_OPTIMIZING` - For a storage-capacity increase update, Amazon FSx has updated the file system with the new storage capacity, and is now performing the storage-optimization process.
         * + `PENDING` - For a backup restore to a second-generation FSx for ONTAP file system, indicates that the file metadata is being downloaded onto the volume. The volume's Lifecycle state is CREATING.
         * + `IN_PROGRESS` - For a backup restore to a second-generation FSx for ONTAP file system, indicates that all metadata has been downloaded to the new volume and client can access data with read-only access while Amazon FSx downloads the file data to the volume. Track the progress of this process with the `ProgressPercent` element.
         */
        public var status: aws.sdk.kotlin.services.fsx.model.Status? = null
        /**
         * The target value for the administration action, provided in the `UpdateFileSystem` operation. Returned for `FILE_SYSTEM_UPDATE` administrative actions.
         */
        public var targetFileSystemValues: aws.sdk.kotlin.services.fsx.model.FileSystem? = null
        /**
         * A snapshot of an Amazon FSx for OpenZFS volume.
         */
        public var targetSnapshotValues: aws.sdk.kotlin.services.fsx.model.Snapshot? = null
        /**
         * Describes an Amazon FSx volume.
         */
        public var targetVolumeValues: aws.sdk.kotlin.services.fsx.model.Volume? = null
        /**
         * The number of bytes that have transferred for the FSx for OpenZFS snapshot that you're copying.
         */
        public var totalTransferBytes: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.AdministrativeAction) : this() {
            this.administrativeActionType = x.administrativeActionType
            this.failureDetails = x.failureDetails
            this.progressPercent = x.progressPercent
            this.remainingTransferBytes = x.remainingTransferBytes
            this.requestTime = x.requestTime
            this.status = x.status
            this.targetFileSystemValues = x.targetFileSystemValues
            this.targetSnapshotValues = x.targetSnapshotValues
            this.targetVolumeValues = x.targetVolumeValues
            this.totalTransferBytes = x.totalTransferBytes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.AdministrativeAction = AdministrativeAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.AdministrativeActionFailureDetails] inside the given [block]
         */
        public fun failureDetails(block: aws.sdk.kotlin.services.fsx.model.AdministrativeActionFailureDetails.Builder.() -> kotlin.Unit) {
            this.failureDetails = aws.sdk.kotlin.services.fsx.model.AdministrativeActionFailureDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.FileSystem] inside the given [block]
         */
        public fun targetFileSystemValues(block: aws.sdk.kotlin.services.fsx.model.FileSystem.Builder.() -> kotlin.Unit) {
            this.targetFileSystemValues = aws.sdk.kotlin.services.fsx.model.FileSystem.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.Snapshot] inside the given [block]
         */
        public fun targetSnapshotValues(block: aws.sdk.kotlin.services.fsx.model.Snapshot.Builder.() -> kotlin.Unit) {
            this.targetSnapshotValues = aws.sdk.kotlin.services.fsx.model.Snapshot.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.Volume] inside the given [block]
         */
        public fun targetVolumeValues(block: aws.sdk.kotlin.services.fsx.model.Volume.Builder.() -> kotlin.Unit) {
            this.targetVolumeValues = aws.sdk.kotlin.services.fsx.model.Volume.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
