// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * An Active Directory error.
 */
public class ActiveDirectoryError private constructor(builder: Builder) : FSxException(builder.message) {

    /**
     * The directory ID of the directory that an error pertains to.
     */
    public val activeDirectoryId: kotlin.String? = builder.activeDirectoryId
    /**
     * The type of Active Directory error.
     */
    public val type: aws.sdk.kotlin.services.fsx.model.ActiveDirectoryErrorType? = builder.type

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.ActiveDirectoryError = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActiveDirectoryError(")
        append("activeDirectoryId=$activeDirectoryId,")
        append("message=$message,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeDirectoryId?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActiveDirectoryError

        if (activeDirectoryId != other.activeDirectoryId) return false
        if (message != other.message) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.ActiveDirectoryError = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The directory ID of the directory that an error pertains to.
         */
        public var activeDirectoryId: kotlin.String? = null
        /**
         * A detailed error message.
         */
        public var message: kotlin.String? = null
        /**
         * The type of Active Directory error.
         */
        public var type: aws.sdk.kotlin.services.fsx.model.ActiveDirectoryErrorType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.ActiveDirectoryError) : this() {
            this.activeDirectoryId = x.activeDirectoryId
            this.message = x.message
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.ActiveDirectoryError = ActiveDirectoryError(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
