// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.serde

import aws.sdk.kotlin.services.fsx.model.StorageType
import aws.sdk.kotlin.services.fsx.model.UpdateFileSystemLustreConfiguration
import aws.sdk.kotlin.services.fsx.model.UpdateFileSystemOntapConfiguration
import aws.sdk.kotlin.services.fsx.model.UpdateFileSystemOpenZfsConfiguration
import aws.sdk.kotlin.services.fsx.model.UpdateFileSystemRequest
import aws.sdk.kotlin.services.fsx.model.UpdateFileSystemWindowsConfiguration
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateFileSystemOperationSerializer: HttpSerializer.NonStreaming<UpdateFileSystemRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateFileSystemRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeUpdateFileSystemOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeUpdateFileSystemOperationBody(context: ExecutionContext, input: UpdateFileSystemRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientRequestToken"))
    val FILESYSTEMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FileSystemId"))
    val LUSTRECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LustreConfiguration"))
    val ONTAPCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OntapConfiguration"))
    val OPENZFSCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OpenZFSConfiguration"))
    val STORAGECAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("StorageCapacity"))
    val STORAGETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("StorageType"))
    val WINDOWSCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("WindowsConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(FILESYSTEMID_DESCRIPTOR)
        field(LUSTRECONFIGURATION_DESCRIPTOR)
        field(ONTAPCONFIGURATION_DESCRIPTOR)
        field(OPENZFSCONFIGURATION_DESCRIPTOR)
        field(STORAGECAPACITY_DESCRIPTOR)
        field(STORAGETYPE_DESCRIPTOR)
        field(WINDOWSCONFIGURATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.fileSystemId?.let { field(FILESYSTEMID_DESCRIPTOR, it) }
        input.lustreConfiguration?.let { field(LUSTRECONFIGURATION_DESCRIPTOR, it, ::serializeUpdateFileSystemLustreConfigurationDocument) }
        input.ontapConfiguration?.let { field(ONTAPCONFIGURATION_DESCRIPTOR, it, ::serializeUpdateFileSystemOntapConfigurationDocument) }
        input.openZfsConfiguration?.let { field(OPENZFSCONFIGURATION_DESCRIPTOR, it, ::serializeUpdateFileSystemOpenZfsConfigurationDocument) }
        input.storageCapacity?.let { field(STORAGECAPACITY_DESCRIPTOR, it) }
        input.storageType?.let { field(STORAGETYPE_DESCRIPTOR, it.value) }
        input.windowsConfiguration?.let { field(WINDOWSCONFIGURATION_DESCRIPTOR, it, ::serializeUpdateFileSystemWindowsConfigurationDocument) }
    }
    return serializer.toByteArray()
}
