// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.serde

import aws.sdk.kotlin.services.fsx.model.DescribeFileSystemsResponse
import aws.sdk.kotlin.services.fsx.model.FSxException
import aws.sdk.kotlin.services.fsx.model.FileSystem
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeFileSystemsOperationDeserializer: HttpDeserializer.NonStreaming<DescribeFileSystemsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeFileSystemsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeFileSystemsError(context, call, payload)
        }
        val builder = DescribeFileSystemsResponse.Builder()

        if (payload != null) {
            deserializeDescribeFileSystemsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeFileSystemsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw FSxException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedCall, payload)
        "FileSystemNotFound" -> FileSystemNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        else -> FSxException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeFileSystemsOperationBody(builder: DescribeFileSystemsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FILESYSTEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FileSystems"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FILESYSTEMS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FILESYSTEMS_DESCRIPTOR.index -> builder.fileSystems =
                    deserializer.deserializeList(FILESYSTEMS_DESCRIPTOR) {
                        val col0 = mutableListOf<FileSystem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFileSystemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
