// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.serde

import aws.sdk.kotlin.services.fsx.model.DataRepositoryLifecycle
import aws.sdk.kotlin.services.fsx.model.DeleteDataRepositoryAssociationResponse
import aws.sdk.kotlin.services.fsx.model.FSxException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteDataRepositoryAssociationOperationDeserializer: HttpDeserializer.NonStreaming<DeleteDataRepositoryAssociationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeleteDataRepositoryAssociationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteDataRepositoryAssociationError(context, call, payload)
        }
        val builder = DeleteDataRepositoryAssociationResponse.Builder()

        if (payload != null) {
            deserializeDeleteDataRepositoryAssociationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeleteDataRepositoryAssociationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw FSxException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedCall, payload)
        "DataRepositoryAssociationNotFound" -> DataRepositoryAssociationNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        "IncompatibleParameterError" -> IncompatibleParameterErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceLimitExceeded" -> ServiceLimitExceededDeserializer().deserialize(context, wrappedCall, payload)
        else -> FSxException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteDataRepositoryAssociationOperationBody(builder: DeleteDataRepositoryAssociationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSOCIATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AssociationId"))
    val DELETEDATAINFILESYSTEM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("DeleteDataInFileSystem"))
    val LIFECYCLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Lifecycle"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSOCIATIONID_DESCRIPTOR)
        field(DELETEDATAINFILESYSTEM_DESCRIPTOR)
        field(LIFECYCLE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSOCIATIONID_DESCRIPTOR.index -> builder.associationId = deserializeString()
                DELETEDATAINFILESYSTEM_DESCRIPTOR.index -> builder.deleteDataInFileSystem = deserializeBoolean()
                LIFECYCLE_DESCRIPTOR.index -> builder.lifecycle = deserializeString().let { DataRepositoryLifecycle.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
