// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.paginators

import aws.sdk.kotlin.services.fsx.FSxClient
import aws.sdk.kotlin.services.fsx.model.DescribeBackupsRequest
import aws.sdk.kotlin.services.fsx.model.DescribeBackupsResponse
import aws.sdk.kotlin.services.fsx.model.DescribeDataRepositoryAssociationsRequest
import aws.sdk.kotlin.services.fsx.model.DescribeDataRepositoryAssociationsResponse
import aws.sdk.kotlin.services.fsx.model.DescribeDataRepositoryTasksRequest
import aws.sdk.kotlin.services.fsx.model.DescribeDataRepositoryTasksResponse
import aws.sdk.kotlin.services.fsx.model.DescribeFileCachesRequest
import aws.sdk.kotlin.services.fsx.model.DescribeFileCachesResponse
import aws.sdk.kotlin.services.fsx.model.DescribeFileSystemAliasesRequest
import aws.sdk.kotlin.services.fsx.model.DescribeFileSystemAliasesResponse
import aws.sdk.kotlin.services.fsx.model.DescribeFileSystemsRequest
import aws.sdk.kotlin.services.fsx.model.DescribeFileSystemsResponse
import aws.sdk.kotlin.services.fsx.model.DescribeSnapshotsRequest
import aws.sdk.kotlin.services.fsx.model.DescribeSnapshotsResponse
import aws.sdk.kotlin.services.fsx.model.DescribeStorageVirtualMachinesRequest
import aws.sdk.kotlin.services.fsx.model.DescribeStorageVirtualMachinesResponse
import aws.sdk.kotlin.services.fsx.model.DescribeVolumesRequest
import aws.sdk.kotlin.services.fsx.model.DescribeVolumesResponse
import aws.sdk.kotlin.services.fsx.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.fsx.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.fsx.model.StorageVirtualMachine
import aws.sdk.kotlin.services.fsx.model.Volume
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeBackupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeBackupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBackupsResponse]
 */
public fun FSxClient.describeBackupsPaginated(initialRequest: DescribeBackupsRequest = DescribeBackupsRequest { }): Flow<DescribeBackupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeBackupsPaginated.describeBackups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeBackupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBackupsResponse]
 */
public fun FSxClient.describeBackupsPaginated(block: DescribeBackupsRequest.Builder.() -> Unit): Flow<DescribeBackupsResponse> =
    describeBackupsPaginated(DescribeBackupsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeDataRepositoryAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDataRepositoryAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDataRepositoryAssociationsResponse]
 */
public fun FSxClient.describeDataRepositoryAssociationsPaginated(initialRequest: DescribeDataRepositoryAssociationsRequest = DescribeDataRepositoryAssociationsRequest { }): Flow<DescribeDataRepositoryAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeDataRepositoryAssociationsPaginated.describeDataRepositoryAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDataRepositoryAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDataRepositoryAssociationsResponse]
 */
public fun FSxClient.describeDataRepositoryAssociationsPaginated(block: DescribeDataRepositoryAssociationsRequest.Builder.() -> Unit): Flow<DescribeDataRepositoryAssociationsResponse> =
    describeDataRepositoryAssociationsPaginated(DescribeDataRepositoryAssociationsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeDataRepositoryTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDataRepositoryTasksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDataRepositoryTasksResponse]
 */
public fun FSxClient.describeDataRepositoryTasksPaginated(initialRequest: DescribeDataRepositoryTasksRequest = DescribeDataRepositoryTasksRequest { }): Flow<DescribeDataRepositoryTasksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeDataRepositoryTasksPaginated.describeDataRepositoryTasks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDataRepositoryTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDataRepositoryTasksResponse]
 */
public fun FSxClient.describeDataRepositoryTasksPaginated(block: DescribeDataRepositoryTasksRequest.Builder.() -> Unit): Flow<DescribeDataRepositoryTasksResponse> =
    describeDataRepositoryTasksPaginated(DescribeDataRepositoryTasksRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeFileCachesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeFileCachesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFileCachesResponse]
 */
public fun FSxClient.describeFileCachesPaginated(initialRequest: DescribeFileCachesRequest = DescribeFileCachesRequest { }): Flow<DescribeFileCachesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeFileCachesPaginated.describeFileCaches(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeFileCachesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFileCachesResponse]
 */
public fun FSxClient.describeFileCachesPaginated(block: DescribeFileCachesRequest.Builder.() -> Unit): Flow<DescribeFileCachesResponse> =
    describeFileCachesPaginated(DescribeFileCachesRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeFileSystemAliasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeFileSystemAliasesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFileSystemAliasesResponse]
 */
public fun FSxClient.describeFileSystemAliasesPaginated(initialRequest: DescribeFileSystemAliasesRequest): Flow<DescribeFileSystemAliasesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeFileSystemAliasesPaginated.describeFileSystemAliases(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeFileSystemAliasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFileSystemAliasesResponse]
 */
public fun FSxClient.describeFileSystemAliasesPaginated(block: DescribeFileSystemAliasesRequest.Builder.() -> Unit): Flow<DescribeFileSystemAliasesResponse> =
    describeFileSystemAliasesPaginated(DescribeFileSystemAliasesRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeFileSystemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeFileSystemsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFileSystemsResponse]
 */
public fun FSxClient.describeFileSystemsPaginated(initialRequest: DescribeFileSystemsRequest = DescribeFileSystemsRequest { }): Flow<DescribeFileSystemsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeFileSystemsPaginated.describeFileSystems(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeFileSystemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFileSystemsResponse]
 */
public fun FSxClient.describeFileSystemsPaginated(block: DescribeFileSystemsRequest.Builder.() -> Unit): Flow<DescribeFileSystemsResponse> =
    describeFileSystemsPaginated(DescribeFileSystemsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeSnapshotsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSnapshotsResponse]
 */
public fun FSxClient.describeSnapshotsPaginated(initialRequest: DescribeSnapshotsRequest = DescribeSnapshotsRequest { }): Flow<DescribeSnapshotsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeSnapshotsPaginated.describeSnapshots(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSnapshotsResponse]
 */
public fun FSxClient.describeSnapshotsPaginated(block: DescribeSnapshotsRequest.Builder.() -> Unit): Flow<DescribeSnapshotsResponse> =
    describeSnapshotsPaginated(DescribeSnapshotsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeStorageVirtualMachinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeStorageVirtualMachinesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStorageVirtualMachinesResponse]
 */
public fun FSxClient.describeStorageVirtualMachinesPaginated(initialRequest: DescribeStorageVirtualMachinesRequest = DescribeStorageVirtualMachinesRequest { }): Flow<DescribeStorageVirtualMachinesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeStorageVirtualMachinesPaginated.describeStorageVirtualMachines(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeStorageVirtualMachinesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStorageVirtualMachinesResponse]
 */
public fun FSxClient.describeStorageVirtualMachinesPaginated(block: DescribeStorageVirtualMachinesRequest.Builder.() -> Unit): Flow<DescribeStorageVirtualMachinesResponse> =
    describeStorageVirtualMachinesPaginated(DescribeStorageVirtualMachinesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeStorageVirtualMachinesPaginated]
 * to access the nested member [StorageVirtualMachine]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StorageVirtualMachine]
 */
@JvmName("describeStorageVirtualMachinesResponseStorageVirtualMachine")
public fun Flow<DescribeStorageVirtualMachinesResponse>.storageVirtualMachines(): Flow<StorageVirtualMachine> =
    transform() { response ->
        response.storageVirtualMachines?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeVolumesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeVolumesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeVolumesResponse]
 */
public fun FSxClient.describeVolumesPaginated(initialRequest: DescribeVolumesRequest = DescribeVolumesRequest { }): Flow<DescribeVolumesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeVolumesPaginated.describeVolumes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeVolumesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeVolumesResponse]
 */
public fun FSxClient.describeVolumesPaginated(block: DescribeVolumesRequest.Builder.() -> Unit): Flow<DescribeVolumesResponse> =
    describeVolumesPaginated(DescribeVolumesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeVolumesPaginated]
 * to access the nested member [Volume]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Volume]
 */
@JvmName("describeVolumesResponseVolume")
public fun Flow<DescribeVolumesResponse>.volumes(): Flow<Volume> =
    transform() { response ->
        response.volumes?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun FSxClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun FSxClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())
