// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system. For more information, see [ File access auditing](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/file-access-auditing.html).
 */
public class WindowsAuditLogConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN.
     *
     * The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. The name of the Amazon Kinesis Data Firehose delivery stream must begin with the `aws-fsx` prefix.
     *
     * The destination ARN (either CloudWatch Logs log group or Kinesis Data Firehose delivery stream) must be in the same Amazon Web Services partition, Amazon Web Services Region, and Amazon Web Services account as your Amazon FSx file system.
     */
    public val auditLogDestination: kotlin.String? = builder.auditLogDestination
    /**
     * Sets which attempt type is logged by Amazon FSx for file and folder accesses.
     * + `SUCCESS_ONLY` - only successful attempts to access files or folders are logged.
     * + `FAILURE_ONLY` - only failed attempts to access files or folders are logged.
     * + `SUCCESS_AND_FAILURE` - both successful attempts and failed attempts to access files or folders are logged.
     * + `DISABLED` - access auditing of files and folders is turned off.
     */
    public val fileAccessAuditLogLevel: aws.sdk.kotlin.services.fsx.model.WindowsAccessAuditLogLevel? = builder.fileAccessAuditLogLevel
    /**
     * Sets which attempt type is logged by Amazon FSx for file share accesses.
     * + `SUCCESS_ONLY` - only successful attempts to access file shares are logged.
     * + `FAILURE_ONLY` - only failed attempts to access file shares are logged.
     * + `SUCCESS_AND_FAILURE` - both successful attempts and failed attempts to access file shares are logged.
     * + `DISABLED` - access auditing of file shares is turned off.
     */
    public val fileShareAccessAuditLogLevel: aws.sdk.kotlin.services.fsx.model.WindowsAccessAuditLogLevel? = builder.fileShareAccessAuditLogLevel

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.WindowsAuditLogConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WindowsAuditLogConfiguration(")
        append("auditLogDestination=$auditLogDestination,")
        append("fileAccessAuditLogLevel=$fileAccessAuditLogLevel,")
        append("fileShareAccessAuditLogLevel=$fileShareAccessAuditLogLevel")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = auditLogDestination?.hashCode() ?: 0
        result = 31 * result + (fileAccessAuditLogLevel?.hashCode() ?: 0)
        result = 31 * result + (fileShareAccessAuditLogLevel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WindowsAuditLogConfiguration

        if (auditLogDestination != other.auditLogDestination) return false
        if (fileAccessAuditLogLevel != other.fileAccessAuditLogLevel) return false
        if (fileShareAccessAuditLogLevel != other.fileShareAccessAuditLogLevel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.WindowsAuditLogConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN.
         *
         * The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. The name of the Amazon Kinesis Data Firehose delivery stream must begin with the `aws-fsx` prefix.
         *
         * The destination ARN (either CloudWatch Logs log group or Kinesis Data Firehose delivery stream) must be in the same Amazon Web Services partition, Amazon Web Services Region, and Amazon Web Services account as your Amazon FSx file system.
         */
        public var auditLogDestination: kotlin.String? = null
        /**
         * Sets which attempt type is logged by Amazon FSx for file and folder accesses.
         * + `SUCCESS_ONLY` - only successful attempts to access files or folders are logged.
         * + `FAILURE_ONLY` - only failed attempts to access files or folders are logged.
         * + `SUCCESS_AND_FAILURE` - both successful attempts and failed attempts to access files or folders are logged.
         * + `DISABLED` - access auditing of files and folders is turned off.
         */
        public var fileAccessAuditLogLevel: aws.sdk.kotlin.services.fsx.model.WindowsAccessAuditLogLevel? = null
        /**
         * Sets which attempt type is logged by Amazon FSx for file share accesses.
         * + `SUCCESS_ONLY` - only successful attempts to access file shares are logged.
         * + `FAILURE_ONLY` - only failed attempts to access file shares are logged.
         * + `SUCCESS_AND_FAILURE` - both successful attempts and failed attempts to access file shares are logged.
         * + `DISABLED` - access auditing of file shares is turned off.
         */
        public var fileShareAccessAuditLogLevel: aws.sdk.kotlin.services.fsx.model.WindowsAccessAuditLogLevel? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.WindowsAuditLogConfiguration) : this() {
            this.auditLogDestination = x.auditLogDestination
            this.fileAccessAuditLogLevel = x.fileAccessAuditLogLevel
            this.fileShareAccessAuditLogLevel = x.fileShareAccessAuditLogLevel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.WindowsAuditLogConfiguration = WindowsAuditLogConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
