// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Updates the SnapLock configuration for an existing FSx for ONTAP volume.
 */
public class UpdateSnaplockConfiguration private constructor(builder: Builder) {
    /**
     * Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume. The default value is `false`. If you set `AuditLogVolume` to `true`, the SnapLock volume is created as an audit log volume. The minimum retention period for an audit log volume is six months.
     *
     * For more information, see [ SnapLock audit log volumes](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/how-snaplock-works.html#snaplock-audit-log-volume).
     */
    public val auditLogVolume: kotlin.Boolean? = builder.auditLogVolume
    /**
     * The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume.
     */
    public val autocommitPeriod: aws.sdk.kotlin.services.fsx.model.AutocommitPeriod? = builder.autocommitPeriod
    /**
     * Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise volume. Enabling privileged delete allows SnapLock administrators to delete write once, read many (WORM) files even if they have active retention periods. `PERMANENTLY_DISABLED` is a terminal state. If privileged delete is permanently disabled on a SnapLock volume, you can't re-enable it. The default value is `DISABLED`.
     *
     * For more information, see [Privileged delete](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html#privileged-delete).
     */
    public val privilegedDelete: aws.sdk.kotlin.services.fsx.model.PrivilegedDelete? = builder.privilegedDelete
    /**
     * Specifies the retention period of an FSx for ONTAP SnapLock volume.
     */
    public val retentionPeriod: aws.sdk.kotlin.services.fsx.model.SnaplockRetentionPeriod? = builder.retentionPeriod
    /**
     * Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume. Volume-append mode allows you to create WORM-appendable files and write data to them incrementally. The default value is `false`.
     *
     * For more information, see [Volume-append mode](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/worm-state.html#worm-state-append).
     */
    public val volumeAppendModeEnabled: kotlin.Boolean? = builder.volumeAppendModeEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.UpdateSnaplockConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateSnaplockConfiguration(")
        append("auditLogVolume=$auditLogVolume,")
        append("autocommitPeriod=$autocommitPeriod,")
        append("privilegedDelete=$privilegedDelete,")
        append("retentionPeriod=$retentionPeriod,")
        append("volumeAppendModeEnabled=$volumeAppendModeEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = auditLogVolume?.hashCode() ?: 0
        result = 31 * result + (autocommitPeriod?.hashCode() ?: 0)
        result = 31 * result + (privilegedDelete?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod?.hashCode() ?: 0)
        result = 31 * result + (volumeAppendModeEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateSnaplockConfiguration

        if (auditLogVolume != other.auditLogVolume) return false
        if (autocommitPeriod != other.autocommitPeriod) return false
        if (privilegedDelete != other.privilegedDelete) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (volumeAppendModeEnabled != other.volumeAppendModeEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.UpdateSnaplockConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume. The default value is `false`. If you set `AuditLogVolume` to `true`, the SnapLock volume is created as an audit log volume. The minimum retention period for an audit log volume is six months.
         *
         * For more information, see [ SnapLock audit log volumes](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/how-snaplock-works.html#snaplock-audit-log-volume).
         */
        public var auditLogVolume: kotlin.Boolean? = null
        /**
         * The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume.
         */
        public var autocommitPeriod: aws.sdk.kotlin.services.fsx.model.AutocommitPeriod? = null
        /**
         * Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise volume. Enabling privileged delete allows SnapLock administrators to delete write once, read many (WORM) files even if they have active retention periods. `PERMANENTLY_DISABLED` is a terminal state. If privileged delete is permanently disabled on a SnapLock volume, you can't re-enable it. The default value is `DISABLED`.
         *
         * For more information, see [Privileged delete](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-enterprise.html#privileged-delete).
         */
        public var privilegedDelete: aws.sdk.kotlin.services.fsx.model.PrivilegedDelete? = null
        /**
         * Specifies the retention period of an FSx for ONTAP SnapLock volume.
         */
        public var retentionPeriod: aws.sdk.kotlin.services.fsx.model.SnaplockRetentionPeriod? = null
        /**
         * Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume. Volume-append mode allows you to create WORM-appendable files and write data to them incrementally. The default value is `false`.
         *
         * For more information, see [Volume-append mode](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/worm-state.html#worm-state-append).
         */
        public var volumeAppendModeEnabled: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.UpdateSnaplockConfiguration) : this() {
            this.auditLogVolume = x.auditLogVolume
            this.autocommitPeriod = x.autocommitPeriod
            this.privilegedDelete = x.privilegedDelete
            this.retentionPeriod = x.retentionPeriod
            this.volumeAppendModeEnabled = x.volumeAppendModeEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.UpdateSnaplockConfiguration = UpdateSnaplockConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.AutocommitPeriod] inside the given [block]
         */
        public fun autocommitPeriod(block: aws.sdk.kotlin.services.fsx.model.AutocommitPeriod.Builder.() -> kotlin.Unit) {
            this.autocommitPeriod = aws.sdk.kotlin.services.fsx.model.AutocommitPeriod.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.SnaplockRetentionPeriod] inside the given [block]
         */
        public fun retentionPeriod(block: aws.sdk.kotlin.services.fsx.model.SnaplockRetentionPeriod.Builder.() -> kotlin.Unit) {
            this.retentionPeriod = aws.sdk.kotlin.services.fsx.model.SnaplockRetentionPeriod.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
