// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration updates for an Amazon FSx for NetApp ONTAP file system.
 */
public class UpdateFileSystemOntapConfiguration private constructor(builder: Builder) {
    /**
     * (Multi-AZ only) A list of IDs of new virtual private cloud (VPC) route tables to associate (add) with your Amazon FSx for NetApp ONTAP file system.
     */
    public val addRouteTableIds: List<String>? = builder.addRouteTableIds
    /**
     * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `30`.
     */
    public val automaticBackupRetentionDays: kotlin.Int? = builder.automaticBackupRetentionDays
    /**
     * A recurring daily time, in the format `HH:MM`. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, `05:00` specifies 5 AM daily.
     */
    public val dailyAutomaticBackupStartTime: kotlin.String? = builder.dailyAutomaticBackupStartTime
    /**
     * The SSD IOPS (input output operations per second) configuration for an Amazon FSx for NetApp ONTAP file system. The default is 3 IOPS per GB of storage capacity, but you can provision additional IOPS per GB of storage. The configuration consists of an IOPS mode (`AUTOMATIC` or `USER_PROVISIONED`), and in the case of `USER_PROVISIONED` IOPS, the total number of SSD IOPS provisioned. For more information, see [Updating SSD storage capacity and IOPS](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/increase-primary-storage.html).
     */
    public val diskIopsConfiguration: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration? = builder.diskIopsConfiguration
    /**
     * Update the password for the `fsxadmin` user by entering a new password. You use the `fsxadmin` user to access the NetApp ONTAP CLI and REST API to manage your file system resources. For more information, see [Managing resources using NetApp Applicaton](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-resources-ontap-apps.html).
     */
    public val fsxAdminPassword: kotlin.String? = builder.fsxAdminPassword
    /**
     * (Multi-AZ only) A list of IDs of existing virtual private cloud (VPC) route tables to disassociate (remove) from your Amazon FSx for NetApp ONTAP file system. You can use the API operation to retrieve the list of VPC route table IDs for a file system.
     */
    public val removeRouteTableIds: List<String>? = builder.removeRouteTableIds
    /**
     * Enter a new value to change the amount of throughput capacity for the file system in megabytes per second (MBps). For more information, see [Managing throughput capacity](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-throughput-capacity.html) in the FSx for ONTAP User Guide.
     *
     * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
     * + The value of `ThroughputCapacity` and `ThroughputCapacityPerHAPair` are not the same value.
     * + The value of `ThroughputCapacity` when divided by the value of `HAPairs` is outside of the valid range for `ThroughputCapacity`.
     */
    public val throughputCapacity: kotlin.Int? = builder.throughputCapacity
    /**
     * Use to choose the throughput capacity per HA pair, rather than the total throughput for the file system.
     *
     * This field and `ThroughputCapacity` cannot be defined in the same API call, but one is required.
     *
     * This field and `ThroughputCapacity` are the same for file systems with one HA pair.
     * + For `SINGLE_AZ_1` and `MULTI_AZ_1`, valid values are 128, 256, 512, 1024, 2048, or 4096 MBps.
     * + For `SINGLE_AZ_2`, valid values are 3072 or 6144 MBps.
     *
     * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
     * + The value of `ThroughputCapacity` and `ThroughputCapacityPerHAPair` are not the same value for file systems with one HA pair.
     * + The value of deployment type is `SINGLE_AZ_2` and `ThroughputCapacity` / `ThroughputCapacityPerHAPair` is a valid HA pair (a value between 2 and 12).
     * + The value of `ThroughputCapacityPerHAPair` is not a valid value.
     */
    public val throughputCapacityPerHaPair: kotlin.Int? = builder.throughputCapacityPerHaPair
    /**
     * A recurring weekly time, in the format `D:HH:MM`.
     *
     * `D` is the day of the week, for which 1 represents Monday and 7 represents Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia](https://en.wikipedia.org/wiki/ISO_week_date).
     *
     * `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour.
     *
     * For example, `1:05:00` specifies maintenance at 5 AM Monday.
     */
    public val weeklyMaintenanceStartTime: kotlin.String? = builder.weeklyMaintenanceStartTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.UpdateFileSystemOntapConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFileSystemOntapConfiguration(")
        append("addRouteTableIds=$addRouteTableIds,")
        append("automaticBackupRetentionDays=$automaticBackupRetentionDays,")
        append("dailyAutomaticBackupStartTime=$dailyAutomaticBackupStartTime,")
        append("diskIopsConfiguration=$diskIopsConfiguration,")
        append("fsxAdminPassword=*** Sensitive Data Redacted ***,")
        append("removeRouteTableIds=$removeRouteTableIds,")
        append("throughputCapacity=$throughputCapacity,")
        append("throughputCapacityPerHaPair=$throughputCapacityPerHaPair,")
        append("weeklyMaintenanceStartTime=$weeklyMaintenanceStartTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addRouteTableIds?.hashCode() ?: 0
        result = 31 * result + (automaticBackupRetentionDays ?: 0)
        result = 31 * result + (dailyAutomaticBackupStartTime?.hashCode() ?: 0)
        result = 31 * result + (diskIopsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (fsxAdminPassword?.hashCode() ?: 0)
        result = 31 * result + (removeRouteTableIds?.hashCode() ?: 0)
        result = 31 * result + (throughputCapacity ?: 0)
        result = 31 * result + (throughputCapacityPerHaPair ?: 0)
        result = 31 * result + (weeklyMaintenanceStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFileSystemOntapConfiguration

        if (addRouteTableIds != other.addRouteTableIds) return false
        if (automaticBackupRetentionDays != other.automaticBackupRetentionDays) return false
        if (dailyAutomaticBackupStartTime != other.dailyAutomaticBackupStartTime) return false
        if (diskIopsConfiguration != other.diskIopsConfiguration) return false
        if (fsxAdminPassword != other.fsxAdminPassword) return false
        if (removeRouteTableIds != other.removeRouteTableIds) return false
        if (throughputCapacity != other.throughputCapacity) return false
        if (throughputCapacityPerHaPair != other.throughputCapacityPerHaPair) return false
        if (weeklyMaintenanceStartTime != other.weeklyMaintenanceStartTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.UpdateFileSystemOntapConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * (Multi-AZ only) A list of IDs of new virtual private cloud (VPC) route tables to associate (add) with your Amazon FSx for NetApp ONTAP file system.
         */
        public var addRouteTableIds: List<String>? = null
        /**
         * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `30`.
         */
        public var automaticBackupRetentionDays: kotlin.Int? = null
        /**
         * A recurring daily time, in the format `HH:MM`. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, `05:00` specifies 5 AM daily.
         */
        public var dailyAutomaticBackupStartTime: kotlin.String? = null
        /**
         * The SSD IOPS (input output operations per second) configuration for an Amazon FSx for NetApp ONTAP file system. The default is 3 IOPS per GB of storage capacity, but you can provision additional IOPS per GB of storage. The configuration consists of an IOPS mode (`AUTOMATIC` or `USER_PROVISIONED`), and in the case of `USER_PROVISIONED` IOPS, the total number of SSD IOPS provisioned. For more information, see [Updating SSD storage capacity and IOPS](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/increase-primary-storage.html).
         */
        public var diskIopsConfiguration: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration? = null
        /**
         * Update the password for the `fsxadmin` user by entering a new password. You use the `fsxadmin` user to access the NetApp ONTAP CLI and REST API to manage your file system resources. For more information, see [Managing resources using NetApp Applicaton](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-resources-ontap-apps.html).
         */
        public var fsxAdminPassword: kotlin.String? = null
        /**
         * (Multi-AZ only) A list of IDs of existing virtual private cloud (VPC) route tables to disassociate (remove) from your Amazon FSx for NetApp ONTAP file system. You can use the API operation to retrieve the list of VPC route table IDs for a file system.
         */
        public var removeRouteTableIds: List<String>? = null
        /**
         * Enter a new value to change the amount of throughput capacity for the file system in megabytes per second (MBps). For more information, see [Managing throughput capacity](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-throughput-capacity.html) in the FSx for ONTAP User Guide.
         *
         * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         * + The value of `ThroughputCapacity` and `ThroughputCapacityPerHAPair` are not the same value.
         * + The value of `ThroughputCapacity` when divided by the value of `HAPairs` is outside of the valid range for `ThroughputCapacity`.
         */
        public var throughputCapacity: kotlin.Int? = null
        /**
         * Use to choose the throughput capacity per HA pair, rather than the total throughput for the file system.
         *
         * This field and `ThroughputCapacity` cannot be defined in the same API call, but one is required.
         *
         * This field and `ThroughputCapacity` are the same for file systems with one HA pair.
         * + For `SINGLE_AZ_1` and `MULTI_AZ_1`, valid values are 128, 256, 512, 1024, 2048, or 4096 MBps.
         * + For `SINGLE_AZ_2`, valid values are 3072 or 6144 MBps.
         *
         * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         * + The value of `ThroughputCapacity` and `ThroughputCapacityPerHAPair` are not the same value for file systems with one HA pair.
         * + The value of deployment type is `SINGLE_AZ_2` and `ThroughputCapacity` / `ThroughputCapacityPerHAPair` is a valid HA pair (a value between 2 and 12).
         * + The value of `ThroughputCapacityPerHAPair` is not a valid value.
         */
        public var throughputCapacityPerHaPair: kotlin.Int? = null
        /**
         * A recurring weekly time, in the format `D:HH:MM`.
         *
         * `D` is the day of the week, for which 1 represents Monday and 7 represents Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia](https://en.wikipedia.org/wiki/ISO_week_date).
         *
         * `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour.
         *
         * For example, `1:05:00` specifies maintenance at 5 AM Monday.
         */
        public var weeklyMaintenanceStartTime: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.UpdateFileSystemOntapConfiguration) : this() {
            this.addRouteTableIds = x.addRouteTableIds
            this.automaticBackupRetentionDays = x.automaticBackupRetentionDays
            this.dailyAutomaticBackupStartTime = x.dailyAutomaticBackupStartTime
            this.diskIopsConfiguration = x.diskIopsConfiguration
            this.fsxAdminPassword = x.fsxAdminPassword
            this.removeRouteTableIds = x.removeRouteTableIds
            this.throughputCapacity = x.throughputCapacity
            this.throughputCapacityPerHaPair = x.throughputCapacityPerHaPair
            this.weeklyMaintenanceStartTime = x.weeklyMaintenanceStartTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.UpdateFileSystemOntapConfiguration = UpdateFileSystemOntapConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration] inside the given [block]
         */
        public fun diskIopsConfiguration(block: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration.Builder.() -> kotlin.Unit) {
            this.diskIopsConfiguration = aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
