// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration to set the retention period of an FSx for ONTAP SnapLock volume. The retention period includes default, maximum, and minimum settings. For more information, see [Working with the retention period in SnapLock](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-retention.html).
 */
public class SnaplockRetentionPeriod private constructor(builder: Builder) {
    /**
     * The retention period assigned to a write once, read many (WORM) file by default if an explicit retention period is not set for an FSx for ONTAP SnapLock volume. The default retention period must be greater than or equal to the minimum retention period and less than or equal to the maximum retention period.
     */
    public val defaultRetention: aws.sdk.kotlin.services.fsx.model.RetentionPeriod? = builder.defaultRetention
    /**
     * The longest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume.
     */
    public val maximumRetention: aws.sdk.kotlin.services.fsx.model.RetentionPeriod? = builder.maximumRetention
    /**
     * The shortest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume.
     */
    public val minimumRetention: aws.sdk.kotlin.services.fsx.model.RetentionPeriod? = builder.minimumRetention

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.SnaplockRetentionPeriod = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SnaplockRetentionPeriod(")
        append("defaultRetention=$defaultRetention,")
        append("maximumRetention=$maximumRetention,")
        append("minimumRetention=$minimumRetention")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultRetention?.hashCode() ?: 0
        result = 31 * result + (maximumRetention?.hashCode() ?: 0)
        result = 31 * result + (minimumRetention?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SnaplockRetentionPeriod

        if (defaultRetention != other.defaultRetention) return false
        if (maximumRetention != other.maximumRetention) return false
        if (minimumRetention != other.minimumRetention) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.SnaplockRetentionPeriod = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The retention period assigned to a write once, read many (WORM) file by default if an explicit retention period is not set for an FSx for ONTAP SnapLock volume. The default retention period must be greater than or equal to the minimum retention period and less than or equal to the maximum retention period.
         */
        public var defaultRetention: aws.sdk.kotlin.services.fsx.model.RetentionPeriod? = null
        /**
         * The longest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume.
         */
        public var maximumRetention: aws.sdk.kotlin.services.fsx.model.RetentionPeriod? = null
        /**
         * The shortest retention period that can be assigned to a WORM file on an FSx for ONTAP SnapLock volume.
         */
        public var minimumRetention: aws.sdk.kotlin.services.fsx.model.RetentionPeriod? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.SnaplockRetentionPeriod) : this() {
            this.defaultRetention = x.defaultRetention
            this.maximumRetention = x.maximumRetention
            this.minimumRetention = x.minimumRetention
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.SnaplockRetentionPeriod = SnaplockRetentionPeriod(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.RetentionPeriod] inside the given [block]
         */
        public fun defaultRetention(block: aws.sdk.kotlin.services.fsx.model.RetentionPeriod.Builder.() -> kotlin.Unit) {
            this.defaultRetention = aws.sdk.kotlin.services.fsx.model.RetentionPeriod.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.RetentionPeriod] inside the given [block]
         */
        public fun maximumRetention(block: aws.sdk.kotlin.services.fsx.model.RetentionPeriod.Builder.() -> kotlin.Unit) {
            this.maximumRetention = aws.sdk.kotlin.services.fsx.model.RetentionPeriod.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.RetentionPeriod] inside the given [block]
         */
        public fun minimumRetention(block: aws.sdk.kotlin.services.fsx.model.RetentionPeriod.Builder.() -> kotlin.Unit) {
            this.minimumRetention = aws.sdk.kotlin.services.fsx.model.RetentionPeriod.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
