// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies changes you are making to the self-managed Microsoft Active Directory (AD) configuration to which an FSx for Windows File Server file system or an FSx for ONTAP SVM is joined.
 */
public class SelfManagedActiveDirectoryConfigurationUpdates private constructor(builder: Builder) {
    /**
     * A list of up to three DNS server or domain controller IP addresses in your self-managed AD domain.
     */
    public val dnsIps: List<String>? = builder.dnsIps
    /**
     * Specifies an updated fully qualified domain name of your self-managed AD configuration.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * Specifies the updated name of the self-managed AD domain group whose members are granted administrative privileges for the Amazon FSx resource.
     */
    public val fileSystemAdministratorsGroup: kotlin.String? = builder.fileSystemAdministratorsGroup
    /**
     * Specifies an updated fully qualified distinguished name of the organization unit within your self-managed AD.
     */
    public val organizationalUnitDistinguishedName: kotlin.String? = builder.organizationalUnitDistinguishedName
    /**
     * Specifies the updated password for the service account on your self-managed AD domain. Amazon FSx uses this account to join to your self-managed AD domain.
     */
    public val password: kotlin.String? = builder.password
    /**
     * Specifies the updated user name for the service account on your self-managed AD domain. Amazon FSx uses this account to join to your self-managed AD domain.
     *
     * This account must have the permissions required to join computers to the domain in the organizational unit provided in `OrganizationalUnitDistinguishedName`.
     */
    public val userName: kotlin.String? = builder.userName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SelfManagedActiveDirectoryConfigurationUpdates(")
        append("dnsIps=$dnsIps,")
        append("domainName=$domainName,")
        append("fileSystemAdministratorsGroup=$fileSystemAdministratorsGroup,")
        append("organizationalUnitDistinguishedName=$organizationalUnitDistinguishedName,")
        append("password=*** Sensitive Data Redacted ***,")
        append("userName=$userName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dnsIps?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (fileSystemAdministratorsGroup?.hashCode() ?: 0)
        result = 31 * result + (organizationalUnitDistinguishedName?.hashCode() ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SelfManagedActiveDirectoryConfigurationUpdates

        if (dnsIps != other.dnsIps) return false
        if (domainName != other.domainName) return false
        if (fileSystemAdministratorsGroup != other.fileSystemAdministratorsGroup) return false
        if (organizationalUnitDistinguishedName != other.organizationalUnitDistinguishedName) return false
        if (password != other.password) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of up to three DNS server or domain controller IP addresses in your self-managed AD domain.
         */
        public var dnsIps: List<String>? = null
        /**
         * Specifies an updated fully qualified domain name of your self-managed AD configuration.
         */
        public var domainName: kotlin.String? = null
        /**
         * Specifies the updated name of the self-managed AD domain group whose members are granted administrative privileges for the Amazon FSx resource.
         */
        public var fileSystemAdministratorsGroup: kotlin.String? = null
        /**
         * Specifies an updated fully qualified distinguished name of the organization unit within your self-managed AD.
         */
        public var organizationalUnitDistinguishedName: kotlin.String? = null
        /**
         * Specifies the updated password for the service account on your self-managed AD domain. Amazon FSx uses this account to join to your self-managed AD domain.
         */
        public var password: kotlin.String? = null
        /**
         * Specifies the updated user name for the service account on your self-managed AD domain. Amazon FSx uses this account to join to your self-managed AD domain.
         *
         * This account must have the permissions required to join computers to the domain in the organizational unit provided in `OrganizationalUnitDistinguishedName`.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates) : this() {
            this.dnsIps = x.dnsIps
            this.domainName = x.domainName
            this.fileSystemAdministratorsGroup = x.fileSystemAdministratorsGroup
            this.organizationalUnitDistinguishedName = x.organizationalUnitDistinguishedName
            this.password = x.password
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfigurationUpdates = SelfManagedActiveDirectoryConfigurationUpdates(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
