// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration that specifies a minimum amount of time since last access for an exported file to be eligible for release from an Amazon FSx for Lustre file system. Only files that were last accessed before this point-in-time can be released. For example, if you specify a last accessed time criteria of 9 days, only files that were last accessed 9.00001 or more days ago can be released.
 *
 * Only file data that has been exported to S3 can be released. Files that have not yet been exported to S3, such as new or changed files that have not been exported, are not eligible for release. When files are released, their metadata stays on the file system, so they can still be accessed later. Users and applications can access a released file by reading the file again, which restores data from Amazon S3 to the FSx for Lustre file system.
 *
 * If a file meets the last accessed time criteria, its file or directory path must also be specified with the `Paths` parameter of the operation in order for the file to be released.
 */
public class ReleaseConfiguration private constructor(builder: Builder) {
    /**
     * Defines the point-in-time since an exported file was last accessed, in order for that file to be eligible for release. Only files that were last accessed before this point-in-time are eligible to be released from the file system.
     */
    public val durationSinceLastAccess: aws.sdk.kotlin.services.fsx.model.DurationSinceLastAccess? = builder.durationSinceLastAccess

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.ReleaseConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReleaseConfiguration(")
        append("durationSinceLastAccess=$durationSinceLastAccess")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = durationSinceLastAccess?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReleaseConfiguration

        if (durationSinceLastAccess != other.durationSinceLastAccess) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.ReleaseConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Defines the point-in-time since an exported file was last accessed, in order for that file to be eligible for release. Only files that were last accessed before this point-in-time are eligible to be released from the file system.
         */
        public var durationSinceLastAccess: aws.sdk.kotlin.services.fsx.model.DurationSinceLastAccess? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.ReleaseConfiguration) : this() {
            this.durationSinceLastAccess = x.durationSinceLastAccess
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.ReleaseConfiguration = ReleaseConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DurationSinceLastAccess] inside the given [block]
         */
        public fun durationSinceLastAccess(block: aws.sdk.kotlin.services.fsx.model.DurationSinceLastAccess.Builder.() -> kotlin.Unit) {
            this.durationSinceLastAccess = aws.sdk.kotlin.services.fsx.model.DurationSinceLastAccess.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
