// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration of an Amazon FSx for OpenZFS volume.
 */
public class OpenZfsVolumeConfiguration private constructor(builder: Builder) {
    /**
     * Specifies the strategy used when copying data from the snapshot to the new volume.
     * + `CLONE` - The new volume references the data in the origin snapshot. Cloning a snapshot is faster than copying data from the snapshot to a new volume and doesn't consume disk throughput. However, the origin snapshot can't be deleted if there is a volume using its copied data.
     * + `FULL_COPY` - Copies all data from the snapshot to the new volume.Specify this option to create the volume from a snapshot on another FSx for OpenZFS file system.
     *
     * The `INCREMENTAL_COPY` option is only for updating an existing volume by using a snapshot from another FSx for OpenZFS file system. For more information, see [CopySnapshotAndUpdateVolume](https://docs.aws.amazon.com/fsx/latest/APIReference/API_CopySnapshotAndUpdateVolume.html).
     */
    public val copyStrategy: aws.sdk.kotlin.services.fsx.model.OpenZfsCopyStrategy? = builder.copyStrategy
    /**
     * A Boolean value indicating whether tags for the volume should be copied to snapshots. This value defaults to `false`. If it's set to `true`, all tags for the volume are copied to snapshots where the user doesn't specify tags. If this value is `true` and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.
     */
    public val copyTagsToSnapshots: kotlin.Boolean? = builder.copyTagsToSnapshots
    /**
     * Specifies the method used to compress the data on the volume. The compression type is `NONE` by default.
     * + `NONE` - Doesn't compress the data on the volume. `NONE` is the default.
     * + `ZSTD` - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.
     * + `LZ4` - Compresses the data in the volume using the LZ4 compression algorithm. Compared to Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.
     */
    public val dataCompressionType: aws.sdk.kotlin.services.fsx.model.OpenZfsDataCompressionType? = builder.dataCompressionType
    /**
     * A Boolean value indicating whether dependent clone volumes created from intermediate snapshots should be deleted when a volume is restored from snapshot.
     */
    public val deleteClonedVolumes: kotlin.Boolean? = builder.deleteClonedVolumes
    /**
     * A Boolean value indicating whether snapshot data that differs between the current state and the specified snapshot should be overwritten when a volume is restored from a snapshot.
     */
    public val deleteIntermediateData: kotlin.Boolean? = builder.deleteIntermediateData
    /**
     * A Boolean value indicating whether snapshots between the current state and the specified snapshot should be deleted when a volume is restored from snapshot.
     */
    public val deleteIntermediateSnaphots: kotlin.Boolean? = builder.deleteIntermediateSnaphots
    /**
     * The ID of the snapshot that's being copied or was most recently copied to the destination volume.
     */
    public val destinationSnapshot: kotlin.String? = builder.destinationSnapshot
    /**
     * The configuration object for mounting a Network File System (NFS) file system.
     */
    public val nfsExports: List<OpenZfsNfsExport>? = builder.nfsExports
    /**
     * The configuration object that specifies the snapshot to use as the origin of the data for the volume.
     */
    public val originSnapshot: aws.sdk.kotlin.services.fsx.model.OpenZfsOriginSnapshotConfiguration? = builder.originSnapshot
    /**
     * The ID of the parent volume.
     */
    public val parentVolumeId: kotlin.String? = builder.parentVolumeId
    /**
     * A Boolean value indicating whether the volume is read-only.
     */
    public val readOnly: kotlin.Boolean? = builder.readOnly
    /**
     * The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB. Most workloads should use the default record size. For guidance on when to set a custom record size, see the *Amazon FSx for OpenZFS User Guide*.
     */
    public val recordSizeKib: kotlin.Int? = builder.recordSizeKib
    /**
     * Specifies the ID of the snapshot to which the volume was restored.
     */
    public val restoreToSnapshot: kotlin.String? = builder.restoreToSnapshot
    /**
     * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val sourceSnapshotArn: kotlin.String? = builder.sourceSnapshotArn
    /**
     * The maximum amount of storage in gibibtyes (GiB) that the volume can use from its parent. You can specify a quota larger than the storage on the parent volume.
     */
    public val storageCapacityQuotaGib: kotlin.Int? = builder.storageCapacityQuotaGib
    /**
     * The amount of storage in gibibytes (GiB) to reserve from the parent volume. You can't reserve more storage than the parent volume has reserved.
     */
    public val storageCapacityReservationGib: kotlin.Int? = builder.storageCapacityReservationGib
    /**
     * An object specifying how much storage users or groups can use on the volume.
     */
    public val userAndGroupQuotas: List<OpenZfsUserOrGroupQuota>? = builder.userAndGroupQuotas
    /**
     * The path to the volume from the root volume. For example, `fsx/parentVolume/volume1`.
     */
    public val volumePath: kotlin.String? = builder.volumePath

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.OpenZfsVolumeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpenZfsVolumeConfiguration(")
        append("copyStrategy=$copyStrategy,")
        append("copyTagsToSnapshots=$copyTagsToSnapshots,")
        append("dataCompressionType=$dataCompressionType,")
        append("deleteClonedVolumes=$deleteClonedVolumes,")
        append("deleteIntermediateData=$deleteIntermediateData,")
        append("deleteIntermediateSnaphots=$deleteIntermediateSnaphots,")
        append("destinationSnapshot=$destinationSnapshot,")
        append("nfsExports=$nfsExports,")
        append("originSnapshot=$originSnapshot,")
        append("parentVolumeId=$parentVolumeId,")
        append("readOnly=$readOnly,")
        append("recordSizeKib=$recordSizeKib,")
        append("restoreToSnapshot=$restoreToSnapshot,")
        append("sourceSnapshotArn=$sourceSnapshotArn,")
        append("storageCapacityQuotaGib=$storageCapacityQuotaGib,")
        append("storageCapacityReservationGib=$storageCapacityReservationGib,")
        append("userAndGroupQuotas=$userAndGroupQuotas,")
        append("volumePath=$volumePath")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = copyStrategy?.hashCode() ?: 0
        result = 31 * result + (copyTagsToSnapshots?.hashCode() ?: 0)
        result = 31 * result + (dataCompressionType?.hashCode() ?: 0)
        result = 31 * result + (deleteClonedVolumes?.hashCode() ?: 0)
        result = 31 * result + (deleteIntermediateData?.hashCode() ?: 0)
        result = 31 * result + (deleteIntermediateSnaphots?.hashCode() ?: 0)
        result = 31 * result + (destinationSnapshot?.hashCode() ?: 0)
        result = 31 * result + (nfsExports?.hashCode() ?: 0)
        result = 31 * result + (originSnapshot?.hashCode() ?: 0)
        result = 31 * result + (parentVolumeId?.hashCode() ?: 0)
        result = 31 * result + (readOnly?.hashCode() ?: 0)
        result = 31 * result + (recordSizeKib ?: 0)
        result = 31 * result + (restoreToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (sourceSnapshotArn?.hashCode() ?: 0)
        result = 31 * result + (storageCapacityQuotaGib ?: 0)
        result = 31 * result + (storageCapacityReservationGib ?: 0)
        result = 31 * result + (userAndGroupQuotas?.hashCode() ?: 0)
        result = 31 * result + (volumePath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpenZfsVolumeConfiguration

        if (copyStrategy != other.copyStrategy) return false
        if (copyTagsToSnapshots != other.copyTagsToSnapshots) return false
        if (dataCompressionType != other.dataCompressionType) return false
        if (deleteClonedVolumes != other.deleteClonedVolumes) return false
        if (deleteIntermediateData != other.deleteIntermediateData) return false
        if (deleteIntermediateSnaphots != other.deleteIntermediateSnaphots) return false
        if (destinationSnapshot != other.destinationSnapshot) return false
        if (nfsExports != other.nfsExports) return false
        if (originSnapshot != other.originSnapshot) return false
        if (parentVolumeId != other.parentVolumeId) return false
        if (readOnly != other.readOnly) return false
        if (recordSizeKib != other.recordSizeKib) return false
        if (restoreToSnapshot != other.restoreToSnapshot) return false
        if (sourceSnapshotArn != other.sourceSnapshotArn) return false
        if (storageCapacityQuotaGib != other.storageCapacityQuotaGib) return false
        if (storageCapacityReservationGib != other.storageCapacityReservationGib) return false
        if (userAndGroupQuotas != other.userAndGroupQuotas) return false
        if (volumePath != other.volumePath) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.OpenZfsVolumeConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the strategy used when copying data from the snapshot to the new volume.
         * + `CLONE` - The new volume references the data in the origin snapshot. Cloning a snapshot is faster than copying data from the snapshot to a new volume and doesn't consume disk throughput. However, the origin snapshot can't be deleted if there is a volume using its copied data.
         * + `FULL_COPY` - Copies all data from the snapshot to the new volume.Specify this option to create the volume from a snapshot on another FSx for OpenZFS file system.
         *
         * The `INCREMENTAL_COPY` option is only for updating an existing volume by using a snapshot from another FSx for OpenZFS file system. For more information, see [CopySnapshotAndUpdateVolume](https://docs.aws.amazon.com/fsx/latest/APIReference/API_CopySnapshotAndUpdateVolume.html).
         */
        public var copyStrategy: aws.sdk.kotlin.services.fsx.model.OpenZfsCopyStrategy? = null
        /**
         * A Boolean value indicating whether tags for the volume should be copied to snapshots. This value defaults to `false`. If it's set to `true`, all tags for the volume are copied to snapshots where the user doesn't specify tags. If this value is `true` and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.
         */
        public var copyTagsToSnapshots: kotlin.Boolean? = null
        /**
         * Specifies the method used to compress the data on the volume. The compression type is `NONE` by default.
         * + `NONE` - Doesn't compress the data on the volume. `NONE` is the default.
         * + `ZSTD` - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.
         * + `LZ4` - Compresses the data in the volume using the LZ4 compression algorithm. Compared to Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.
         */
        public var dataCompressionType: aws.sdk.kotlin.services.fsx.model.OpenZfsDataCompressionType? = null
        /**
         * A Boolean value indicating whether dependent clone volumes created from intermediate snapshots should be deleted when a volume is restored from snapshot.
         */
        public var deleteClonedVolumes: kotlin.Boolean? = null
        /**
         * A Boolean value indicating whether snapshot data that differs between the current state and the specified snapshot should be overwritten when a volume is restored from a snapshot.
         */
        public var deleteIntermediateData: kotlin.Boolean? = null
        /**
         * A Boolean value indicating whether snapshots between the current state and the specified snapshot should be deleted when a volume is restored from snapshot.
         */
        public var deleteIntermediateSnaphots: kotlin.Boolean? = null
        /**
         * The ID of the snapshot that's being copied or was most recently copied to the destination volume.
         */
        public var destinationSnapshot: kotlin.String? = null
        /**
         * The configuration object for mounting a Network File System (NFS) file system.
         */
        public var nfsExports: List<OpenZfsNfsExport>? = null
        /**
         * The configuration object that specifies the snapshot to use as the origin of the data for the volume.
         */
        public var originSnapshot: aws.sdk.kotlin.services.fsx.model.OpenZfsOriginSnapshotConfiguration? = null
        /**
         * The ID of the parent volume.
         */
        public var parentVolumeId: kotlin.String? = null
        /**
         * A Boolean value indicating whether the volume is read-only.
         */
        public var readOnly: kotlin.Boolean? = null
        /**
         * The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB. Most workloads should use the default record size. For guidance on when to set a custom record size, see the *Amazon FSx for OpenZFS User Guide*.
         */
        public var recordSizeKib: kotlin.Int? = null
        /**
         * Specifies the ID of the snapshot to which the volume was restored.
         */
        public var restoreToSnapshot: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var sourceSnapshotArn: kotlin.String? = null
        /**
         * The maximum amount of storage in gibibtyes (GiB) that the volume can use from its parent. You can specify a quota larger than the storage on the parent volume.
         */
        public var storageCapacityQuotaGib: kotlin.Int? = null
        /**
         * The amount of storage in gibibytes (GiB) to reserve from the parent volume. You can't reserve more storage than the parent volume has reserved.
         */
        public var storageCapacityReservationGib: kotlin.Int? = null
        /**
         * An object specifying how much storage users or groups can use on the volume.
         */
        public var userAndGroupQuotas: List<OpenZfsUserOrGroupQuota>? = null
        /**
         * The path to the volume from the root volume. For example, `fsx/parentVolume/volume1`.
         */
        public var volumePath: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.OpenZfsVolumeConfiguration) : this() {
            this.copyStrategy = x.copyStrategy
            this.copyTagsToSnapshots = x.copyTagsToSnapshots
            this.dataCompressionType = x.dataCompressionType
            this.deleteClonedVolumes = x.deleteClonedVolumes
            this.deleteIntermediateData = x.deleteIntermediateData
            this.deleteIntermediateSnaphots = x.deleteIntermediateSnaphots
            this.destinationSnapshot = x.destinationSnapshot
            this.nfsExports = x.nfsExports
            this.originSnapshot = x.originSnapshot
            this.parentVolumeId = x.parentVolumeId
            this.readOnly = x.readOnly
            this.recordSizeKib = x.recordSizeKib
            this.restoreToSnapshot = x.restoreToSnapshot
            this.sourceSnapshotArn = x.sourceSnapshotArn
            this.storageCapacityQuotaGib = x.storageCapacityQuotaGib
            this.storageCapacityReservationGib = x.storageCapacityReservationGib
            this.userAndGroupQuotas = x.userAndGroupQuotas
            this.volumePath = x.volumePath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.OpenZfsVolumeConfiguration = OpenZfsVolumeConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.OpenZfsOriginSnapshotConfiguration] inside the given [block]
         */
        public fun originSnapshot(block: aws.sdk.kotlin.services.fsx.model.OpenZfsOriginSnapshotConfiguration.Builder.() -> kotlin.Unit) {
            this.originSnapshot = aws.sdk.kotlin.services.fsx.model.OpenZfsOriginSnapshotConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
