// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration for the Amazon FSx for OpenZFS file system.
 */
public class OpenZfsFileSystemConfiguration private constructor(builder: Builder) {
    /**
     * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `30`.
     */
    public val automaticBackupRetentionDays: kotlin.Int? = builder.automaticBackupRetentionDays
    /**
     * A Boolean value indicating whether tags on the file system should be copied to backups. If it's set to `true`, all tags on the file system are copied to all automatic backups and any user-initiated backups where the user doesn't specify any tags. If this value is `true` and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
     */
    public val copyTagsToBackups: kotlin.Boolean? = builder.copyTagsToBackups
    /**
     * A Boolean value indicating whether tags for the volume should be copied to snapshots. This value defaults to `false`. If it's set to `true`, all tags for the volume are copied to snapshots where the user doesn't specify tags. If this value is `true` and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.
     */
    public val copyTagsToVolumes: kotlin.Boolean? = builder.copyTagsToVolumes
    /**
     * A recurring daily time, in the format `HH:MM`. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, `05:00` specifies 5 AM daily.
     */
    public val dailyAutomaticBackupStartTime: kotlin.String? = builder.dailyAutomaticBackupStartTime
    /**
     * Specifies the file-system deployment type. Amazon FSx for OpenZFS supports  `MULTI_AZ_1`, `SINGLE_AZ_1`, and `SINGLE_AZ_2`.
     */
    public val deploymentType: aws.sdk.kotlin.services.fsx.model.OpenZfsDeploymentType? = builder.deploymentType
    /**
     * The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for NetApp ONTAP, Amazon FSx for Windows File Server, or FSx for OpenZFS file system. By default, Amazon FSx automatically provisions 3 IOPS per GB of storage capacity. You can provision additional IOPS per GB of storage. The configuration consists of the total number of provisioned SSD IOPS and how it is was provisioned, or the mode (by the customer or by Amazon FSx).
     */
    public val diskIopsConfiguration: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration? = builder.diskIopsConfiguration
    /**
     * The IP address of the endpoint that is used to access data or to manage the file system.
     */
    public val endpointIpAddress: kotlin.String? = builder.endpointIpAddress
    /**
     * (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created. By default in the Amazon FSx API and Amazon FSx console, Amazon FSx selects an available /28 IP address range for you from one of the VPC's CIDR ranges. You can have overlapping endpoint IP addresses for file systems deployed in the same VPC/route tables.
     */
    public val endpointIpAddressRange: kotlin.String? = builder.endpointIpAddressRange
    /**
     * Required when `DeploymentType` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located.
     */
    public val preferredSubnetId: kotlin.String? = builder.preferredSubnetId
    /**
     * The ID of the root volume of the OpenZFS file system.
     */
    public val rootVolumeId: kotlin.String? = builder.rootVolumeId
    /**
     * (Multi-AZ only) The VPC route tables in which your file system's endpoints are created.
     */
    public val routeTableIds: List<String>? = builder.routeTableIds
    /**
     * The throughput of an Amazon FSx file system, measured in megabytes per second (MBps).
     */
    public val throughputCapacity: kotlin.Int? = builder.throughputCapacity
    /**
     * A recurring weekly time, in the format `D:HH:MM`.
     *
     * `D` is the day of the week, for which 1 represents Monday and 7 represents Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia](https://en.wikipedia.org/wiki/ISO_week_date).
     *
     * `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour.
     *
     * For example, `1:05:00` specifies maintenance at 5 AM Monday.
     */
    public val weeklyMaintenanceStartTime: kotlin.String? = builder.weeklyMaintenanceStartTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.OpenZfsFileSystemConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpenZfsFileSystemConfiguration(")
        append("automaticBackupRetentionDays=$automaticBackupRetentionDays,")
        append("copyTagsToBackups=$copyTagsToBackups,")
        append("copyTagsToVolumes=$copyTagsToVolumes,")
        append("dailyAutomaticBackupStartTime=$dailyAutomaticBackupStartTime,")
        append("deploymentType=$deploymentType,")
        append("diskIopsConfiguration=$diskIopsConfiguration,")
        append("endpointIpAddress=$endpointIpAddress,")
        append("endpointIpAddressRange=$endpointIpAddressRange,")
        append("preferredSubnetId=$preferredSubnetId,")
        append("rootVolumeId=$rootVolumeId,")
        append("routeTableIds=$routeTableIds,")
        append("throughputCapacity=$throughputCapacity,")
        append("weeklyMaintenanceStartTime=$weeklyMaintenanceStartTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = automaticBackupRetentionDays ?: 0
        result = 31 * result + (copyTagsToBackups?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToVolumes?.hashCode() ?: 0)
        result = 31 * result + (dailyAutomaticBackupStartTime?.hashCode() ?: 0)
        result = 31 * result + (deploymentType?.hashCode() ?: 0)
        result = 31 * result + (diskIopsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (endpointIpAddress?.hashCode() ?: 0)
        result = 31 * result + (endpointIpAddressRange?.hashCode() ?: 0)
        result = 31 * result + (preferredSubnetId?.hashCode() ?: 0)
        result = 31 * result + (rootVolumeId?.hashCode() ?: 0)
        result = 31 * result + (routeTableIds?.hashCode() ?: 0)
        result = 31 * result + (throughputCapacity ?: 0)
        result = 31 * result + (weeklyMaintenanceStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpenZfsFileSystemConfiguration

        if (automaticBackupRetentionDays != other.automaticBackupRetentionDays) return false
        if (copyTagsToBackups != other.copyTagsToBackups) return false
        if (copyTagsToVolumes != other.copyTagsToVolumes) return false
        if (dailyAutomaticBackupStartTime != other.dailyAutomaticBackupStartTime) return false
        if (deploymentType != other.deploymentType) return false
        if (diskIopsConfiguration != other.diskIopsConfiguration) return false
        if (endpointIpAddress != other.endpointIpAddress) return false
        if (endpointIpAddressRange != other.endpointIpAddressRange) return false
        if (preferredSubnetId != other.preferredSubnetId) return false
        if (rootVolumeId != other.rootVolumeId) return false
        if (routeTableIds != other.routeTableIds) return false
        if (throughputCapacity != other.throughputCapacity) return false
        if (weeklyMaintenanceStartTime != other.weeklyMaintenanceStartTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.OpenZfsFileSystemConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `30`.
         */
        public var automaticBackupRetentionDays: kotlin.Int? = null
        /**
         * A Boolean value indicating whether tags on the file system should be copied to backups. If it's set to `true`, all tags on the file system are copied to all automatic backups and any user-initiated backups where the user doesn't specify any tags. If this value is `true` and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
         */
        public var copyTagsToBackups: kotlin.Boolean? = null
        /**
         * A Boolean value indicating whether tags for the volume should be copied to snapshots. This value defaults to `false`. If it's set to `true`, all tags for the volume are copied to snapshots where the user doesn't specify tags. If this value is `true` and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.
         */
        public var copyTagsToVolumes: kotlin.Boolean? = null
        /**
         * A recurring daily time, in the format `HH:MM`. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, `05:00` specifies 5 AM daily.
         */
        public var dailyAutomaticBackupStartTime: kotlin.String? = null
        /**
         * Specifies the file-system deployment type. Amazon FSx for OpenZFS supports  `MULTI_AZ_1`, `SINGLE_AZ_1`, and `SINGLE_AZ_2`.
         */
        public var deploymentType: aws.sdk.kotlin.services.fsx.model.OpenZfsDeploymentType? = null
        /**
         * The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for NetApp ONTAP, Amazon FSx for Windows File Server, or FSx for OpenZFS file system. By default, Amazon FSx automatically provisions 3 IOPS per GB of storage capacity. You can provision additional IOPS per GB of storage. The configuration consists of the total number of provisioned SSD IOPS and how it is was provisioned, or the mode (by the customer or by Amazon FSx).
         */
        public var diskIopsConfiguration: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration? = null
        /**
         * The IP address of the endpoint that is used to access data or to manage the file system.
         */
        public var endpointIpAddress: kotlin.String? = null
        /**
         * (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created. By default in the Amazon FSx API and Amazon FSx console, Amazon FSx selects an available /28 IP address range for you from one of the VPC's CIDR ranges. You can have overlapping endpoint IP addresses for file systems deployed in the same VPC/route tables.
         */
        public var endpointIpAddressRange: kotlin.String? = null
        /**
         * Required when `DeploymentType` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located.
         */
        public var preferredSubnetId: kotlin.String? = null
        /**
         * The ID of the root volume of the OpenZFS file system.
         */
        public var rootVolumeId: kotlin.String? = null
        /**
         * (Multi-AZ only) The VPC route tables in which your file system's endpoints are created.
         */
        public var routeTableIds: List<String>? = null
        /**
         * The throughput of an Amazon FSx file system, measured in megabytes per second (MBps).
         */
        public var throughputCapacity: kotlin.Int? = null
        /**
         * A recurring weekly time, in the format `D:HH:MM`.
         *
         * `D` is the day of the week, for which 1 represents Monday and 7 represents Sunday. For further details, see [the ISO-8601 spec as described on Wikipedia](https://en.wikipedia.org/wiki/ISO_week_date).
         *
         * `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour.
         *
         * For example, `1:05:00` specifies maintenance at 5 AM Monday.
         */
        public var weeklyMaintenanceStartTime: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.OpenZfsFileSystemConfiguration) : this() {
            this.automaticBackupRetentionDays = x.automaticBackupRetentionDays
            this.copyTagsToBackups = x.copyTagsToBackups
            this.copyTagsToVolumes = x.copyTagsToVolumes
            this.dailyAutomaticBackupStartTime = x.dailyAutomaticBackupStartTime
            this.deploymentType = x.deploymentType
            this.diskIopsConfiguration = x.diskIopsConfiguration
            this.endpointIpAddress = x.endpointIpAddress
            this.endpointIpAddressRange = x.endpointIpAddressRange
            this.preferredSubnetId = x.preferredSubnetId
            this.rootVolumeId = x.rootVolumeId
            this.routeTableIds = x.routeTableIds
            this.throughputCapacity = x.throughputCapacity
            this.weeklyMaintenanceStartTime = x.weeklyMaintenanceStartTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.OpenZfsFileSystemConfiguration = OpenZfsFileSystemConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration] inside the given [block]
         */
        public fun diskIopsConfiguration(block: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration.Builder.() -> kotlin.Unit) {
            this.diskIopsConfiguration = aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
