// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration of an Amazon FSx for NetApp ONTAP volume.
 */
public class OntapVolumeConfiguration private constructor(builder: Builder) {
    /**
     * This structure specifies configuration options for a volume’s storage aggregate or aggregates.
     */
    public val aggregateConfiguration: aws.sdk.kotlin.services.fsx.model.AggregateConfiguration? = builder.aggregateConfiguration
    /**
     * A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to false. If it's set to true, all tags for the volume are copied to all automatic and user-initiated backups where the user doesn't specify tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the volume, regardless of this value.
     */
    public val copyTagsToBackups: kotlin.Boolean? = builder.copyTagsToBackups
    /**
     * Specifies the FlexCache endpoint type of the volume. Valid values are the following:
     * + `NONE` specifies that the volume doesn't have a FlexCache configuration. `NONE` is the default.
     * + `ORIGIN` specifies that the volume is the origin volume for a FlexCache volume.
     * + `CACHE` specifies that the volume is a FlexCache volume.
     */
    public val flexCacheEndpointType: aws.sdk.kotlin.services.fsx.model.FlexCacheEndpointType? = builder.flexCacheEndpointType
    /**
     * Specifies the directory that network-attached storage (NAS) clients use to mount the volume, along with the storage virtual machine (SVM) Domain Name System (DNS) name or IP address. You can create a `JunctionPath` directly below a parent volume junction or on a directory within a volume. A `JunctionPath` for a volume named `vol3` might be `/vol1/vol2/vol3`, or `/vol1/dir2/vol3`, or even `/dir1/dir2/vol3`.
     */
    public val junctionPath: kotlin.String? = builder.junctionPath
    /**
     * Specifies the type of volume. Valid values are the following:
     * + `RW` specifies a read/write volume. `RW` is the default.
     * + `DP` specifies a data-protection volume. You can protect data by replicating it to data-protection mirror copies. If a disaster occurs, you can use these data-protection mirror copies to recover data.
     * + `LS` specifies a load-sharing mirror volume. A load-sharing mirror reduces the network traffic to a FlexVol volume by providing additional read-only access to clients.
     */
    public val ontapVolumeType: aws.sdk.kotlin.services.fsx.model.OntapVolumeType? = builder.ontapVolumeType
    /**
     * The security style for the volume, which can be `UNIX`, `NTFS`, or `MIXED`.
     */
    public val securityStyle: aws.sdk.kotlin.services.fsx.model.SecurityStyle? = builder.securityStyle
    /**
     * The configured size of the volume, in bytes.
     */
    public val sizeInBytes: kotlin.Long? = builder.sizeInBytes
    /**
     * The configured size of the volume, in megabytes (MBs).
     */
    public val sizeInMegabytes: kotlin.Int? = builder.sizeInMegabytes
    /**
     * The SnapLock configuration object for an FSx for ONTAP SnapLock volume.
     */
    public val snaplockConfiguration: aws.sdk.kotlin.services.fsx.model.SnaplockConfiguration? = builder.snaplockConfiguration
    /**
     * Specifies the snapshot policy for the volume. There are three built-in snapshot policies:
     * + `default`: This is the default policy. A maximum of six hourly snapshots taken five minutes past the hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after midnight. A maximum of two weekly snapshots taken every Sunday at 15 minutes after midnight.
     * + `default-1weekly`: This policy is the same as the `default` policy except that it only retains one snapshot from the weekly schedule.
     * + `none`: This policy does not take any snapshots. This policy can be assigned to volumes to prevent automatic snapshots from being taken.
     *
     * You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
     *
     * For more information, see [Snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the Amazon FSx for NetApp ONTAP User Guide.
     */
    public val snapshotPolicy: kotlin.String? = builder.snapshotPolicy
    /**
     * The volume's storage efficiency setting.
     */
    public val storageEfficiencyEnabled: kotlin.Boolean? = builder.storageEfficiencyEnabled
    /**
     * The ID of the volume's storage virtual machine.
     */
    public val storageVirtualMachineId: kotlin.String? = builder.storageVirtualMachineId
    /**
     * A Boolean flag indicating whether this volume is the root volume for its storage virtual machine (SVM). Only one volume on an SVM can be the root volume. This value defaults to `false`. If this value is `true`, then this is the SVM root volume.
     *
     * This flag is useful when you're deleting an SVM, because you must first delete all non-root volumes. This flag, when set to `false`, helps you identify which volumes to delete before you can delete the SVM.
     */
    public val storageVirtualMachineRoot: kotlin.Boolean? = builder.storageVirtualMachineRoot
    /**
     * The volume's `TieringPolicy` setting.
     */
    public val tieringPolicy: aws.sdk.kotlin.services.fsx.model.TieringPolicy? = builder.tieringPolicy
    /**
     * The volume's universally unique identifier (UUID).
     */
    public val uuid: kotlin.String? = builder.uuid
    /**
     * Use to specify the style of an ONTAP volume. For more information about FlexVols and FlexGroups, see [Volume types](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types.html) in Amazon FSx for NetApp ONTAP User Guide.
     */
    public val volumeStyle: aws.sdk.kotlin.services.fsx.model.VolumeStyle? = builder.volumeStyle

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.OntapVolumeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OntapVolumeConfiguration(")
        append("aggregateConfiguration=$aggregateConfiguration,")
        append("copyTagsToBackups=$copyTagsToBackups,")
        append("flexCacheEndpointType=$flexCacheEndpointType,")
        append("junctionPath=$junctionPath,")
        append("ontapVolumeType=$ontapVolumeType,")
        append("securityStyle=$securityStyle,")
        append("sizeInBytes=$sizeInBytes,")
        append("sizeInMegabytes=$sizeInMegabytes,")
        append("snaplockConfiguration=$snaplockConfiguration,")
        append("snapshotPolicy=$snapshotPolicy,")
        append("storageEfficiencyEnabled=$storageEfficiencyEnabled,")
        append("storageVirtualMachineId=$storageVirtualMachineId,")
        append("storageVirtualMachineRoot=$storageVirtualMachineRoot,")
        append("tieringPolicy=$tieringPolicy,")
        append("uuid=$uuid,")
        append("volumeStyle=$volumeStyle")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregateConfiguration?.hashCode() ?: 0
        result = 31 * result + (copyTagsToBackups?.hashCode() ?: 0)
        result = 31 * result + (flexCacheEndpointType?.hashCode() ?: 0)
        result = 31 * result + (junctionPath?.hashCode() ?: 0)
        result = 31 * result + (ontapVolumeType?.hashCode() ?: 0)
        result = 31 * result + (securityStyle?.hashCode() ?: 0)
        result = 31 * result + (sizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (sizeInMegabytes ?: 0)
        result = 31 * result + (snaplockConfiguration?.hashCode() ?: 0)
        result = 31 * result + (snapshotPolicy?.hashCode() ?: 0)
        result = 31 * result + (storageEfficiencyEnabled?.hashCode() ?: 0)
        result = 31 * result + (storageVirtualMachineId?.hashCode() ?: 0)
        result = 31 * result + (storageVirtualMachineRoot?.hashCode() ?: 0)
        result = 31 * result + (tieringPolicy?.hashCode() ?: 0)
        result = 31 * result + (uuid?.hashCode() ?: 0)
        result = 31 * result + (volumeStyle?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OntapVolumeConfiguration

        if (aggregateConfiguration != other.aggregateConfiguration) return false
        if (copyTagsToBackups != other.copyTagsToBackups) return false
        if (flexCacheEndpointType != other.flexCacheEndpointType) return false
        if (junctionPath != other.junctionPath) return false
        if (ontapVolumeType != other.ontapVolumeType) return false
        if (securityStyle != other.securityStyle) return false
        if (sizeInBytes != other.sizeInBytes) return false
        if (sizeInMegabytes != other.sizeInMegabytes) return false
        if (snaplockConfiguration != other.snaplockConfiguration) return false
        if (snapshotPolicy != other.snapshotPolicy) return false
        if (storageEfficiencyEnabled != other.storageEfficiencyEnabled) return false
        if (storageVirtualMachineId != other.storageVirtualMachineId) return false
        if (storageVirtualMachineRoot != other.storageVirtualMachineRoot) return false
        if (tieringPolicy != other.tieringPolicy) return false
        if (uuid != other.uuid) return false
        if (volumeStyle != other.volumeStyle) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.OntapVolumeConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This structure specifies configuration options for a volume’s storage aggregate or aggregates.
         */
        public var aggregateConfiguration: aws.sdk.kotlin.services.fsx.model.AggregateConfiguration? = null
        /**
         * A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to false. If it's set to true, all tags for the volume are copied to all automatic and user-initiated backups where the user doesn't specify tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the volume, regardless of this value.
         */
        public var copyTagsToBackups: kotlin.Boolean? = null
        /**
         * Specifies the FlexCache endpoint type of the volume. Valid values are the following:
         * + `NONE` specifies that the volume doesn't have a FlexCache configuration. `NONE` is the default.
         * + `ORIGIN` specifies that the volume is the origin volume for a FlexCache volume.
         * + `CACHE` specifies that the volume is a FlexCache volume.
         */
        public var flexCacheEndpointType: aws.sdk.kotlin.services.fsx.model.FlexCacheEndpointType? = null
        /**
         * Specifies the directory that network-attached storage (NAS) clients use to mount the volume, along with the storage virtual machine (SVM) Domain Name System (DNS) name or IP address. You can create a `JunctionPath` directly below a parent volume junction or on a directory within a volume. A `JunctionPath` for a volume named `vol3` might be `/vol1/vol2/vol3`, or `/vol1/dir2/vol3`, or even `/dir1/dir2/vol3`.
         */
        public var junctionPath: kotlin.String? = null
        /**
         * Specifies the type of volume. Valid values are the following:
         * + `RW` specifies a read/write volume. `RW` is the default.
         * + `DP` specifies a data-protection volume. You can protect data by replicating it to data-protection mirror copies. If a disaster occurs, you can use these data-protection mirror copies to recover data.
         * + `LS` specifies a load-sharing mirror volume. A load-sharing mirror reduces the network traffic to a FlexVol volume by providing additional read-only access to clients.
         */
        public var ontapVolumeType: aws.sdk.kotlin.services.fsx.model.OntapVolumeType? = null
        /**
         * The security style for the volume, which can be `UNIX`, `NTFS`, or `MIXED`.
         */
        public var securityStyle: aws.sdk.kotlin.services.fsx.model.SecurityStyle? = null
        /**
         * The configured size of the volume, in bytes.
         */
        public var sizeInBytes: kotlin.Long? = null
        /**
         * The configured size of the volume, in megabytes (MBs).
         */
        public var sizeInMegabytes: kotlin.Int? = null
        /**
         * The SnapLock configuration object for an FSx for ONTAP SnapLock volume.
         */
        public var snaplockConfiguration: aws.sdk.kotlin.services.fsx.model.SnaplockConfiguration? = null
        /**
         * Specifies the snapshot policy for the volume. There are three built-in snapshot policies:
         * + `default`: This is the default policy. A maximum of six hourly snapshots taken five minutes past the hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after midnight. A maximum of two weekly snapshots taken every Sunday at 15 minutes after midnight.
         * + `default-1weekly`: This policy is the same as the `default` policy except that it only retains one snapshot from the weekly schedule.
         * + `none`: This policy does not take any snapshots. This policy can be assigned to volumes to prevent automatic snapshots from being taken.
         *
         * You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
         *
         * For more information, see [Snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the Amazon FSx for NetApp ONTAP User Guide.
         */
        public var snapshotPolicy: kotlin.String? = null
        /**
         * The volume's storage efficiency setting.
         */
        public var storageEfficiencyEnabled: kotlin.Boolean? = null
        /**
         * The ID of the volume's storage virtual machine.
         */
        public var storageVirtualMachineId: kotlin.String? = null
        /**
         * A Boolean flag indicating whether this volume is the root volume for its storage virtual machine (SVM). Only one volume on an SVM can be the root volume. This value defaults to `false`. If this value is `true`, then this is the SVM root volume.
         *
         * This flag is useful when you're deleting an SVM, because you must first delete all non-root volumes. This flag, when set to `false`, helps you identify which volumes to delete before you can delete the SVM.
         */
        public var storageVirtualMachineRoot: kotlin.Boolean? = null
        /**
         * The volume's `TieringPolicy` setting.
         */
        public var tieringPolicy: aws.sdk.kotlin.services.fsx.model.TieringPolicy? = null
        /**
         * The volume's universally unique identifier (UUID).
         */
        public var uuid: kotlin.String? = null
        /**
         * Use to specify the style of an ONTAP volume. For more information about FlexVols and FlexGroups, see [Volume types](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types.html) in Amazon FSx for NetApp ONTAP User Guide.
         */
        public var volumeStyle: aws.sdk.kotlin.services.fsx.model.VolumeStyle? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.OntapVolumeConfiguration) : this() {
            this.aggregateConfiguration = x.aggregateConfiguration
            this.copyTagsToBackups = x.copyTagsToBackups
            this.flexCacheEndpointType = x.flexCacheEndpointType
            this.junctionPath = x.junctionPath
            this.ontapVolumeType = x.ontapVolumeType
            this.securityStyle = x.securityStyle
            this.sizeInBytes = x.sizeInBytes
            this.sizeInMegabytes = x.sizeInMegabytes
            this.snaplockConfiguration = x.snaplockConfiguration
            this.snapshotPolicy = x.snapshotPolicy
            this.storageEfficiencyEnabled = x.storageEfficiencyEnabled
            this.storageVirtualMachineId = x.storageVirtualMachineId
            this.storageVirtualMachineRoot = x.storageVirtualMachineRoot
            this.tieringPolicy = x.tieringPolicy
            this.uuid = x.uuid
            this.volumeStyle = x.volumeStyle
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.OntapVolumeConfiguration = OntapVolumeConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.AggregateConfiguration] inside the given [block]
         */
        public fun aggregateConfiguration(block: aws.sdk.kotlin.services.fsx.model.AggregateConfiguration.Builder.() -> kotlin.Unit) {
            this.aggregateConfiguration = aws.sdk.kotlin.services.fsx.model.AggregateConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.SnaplockConfiguration] inside the given [block]
         */
        public fun snaplockConfiguration(block: aws.sdk.kotlin.services.fsx.model.SnaplockConfiguration.Builder.() -> kotlin.Unit) {
            this.snaplockConfiguration = aws.sdk.kotlin.services.fsx.model.SnaplockConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.TieringPolicy] inside the given [block]
         */
        public fun tieringPolicy(block: aws.sdk.kotlin.services.fsx.model.TieringPolicy.Builder.() -> kotlin.Unit) {
            this.tieringPolicy = aws.sdk.kotlin.services.fsx.model.TieringPolicy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
