// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration for a data repository association (DRA) to be created during the Amazon File Cache resource creation. The DRA links the cache to either an Amazon S3 bucket or prefix, or a Network File System (NFS) data repository that supports the NFSv3 protocol.
 *
 * The DRA does not support automatic import or automatic export.
 */
public class FileCacheDataRepositoryAssociation private constructor(builder: Builder) {
    /**
     * The path to the S3 or NFS data repository that links to the cache. You must provide one of the following paths:
     * + The path can be an NFS data repository that links to the cache. The path can be in one of two formats:
     *    + If you are not using the `DataRepositorySubdirectories` parameter, the path is to an NFS Export directory (or one of its subdirectories) in the format `nsf://nfs-domain-name/exportpath`. You can therefore link a single NFS Export to a single data repository association.
     *    + If you are using the `DataRepositorySubdirectories` parameter, the path is the domain name of the NFS file system in the format `nfs://filer-domain-name`, which indicates the root of the subdirectories specified with the `DataRepositorySubdirectories` parameter.
     * + The path can be an S3 bucket or prefix in the format `s3://myBucket/myPrefix/`.
     */
    public val dataRepositoryPath: kotlin.String? = builder.dataRepositoryPath
    /**
     * A list of NFS Exports that will be linked with this data repository association. The Export paths are in the format `/exportpath1`. To use this parameter, you must configure `DataRepositoryPath` as the domain name of the NFS file system. The NFS file system domain name in effect is the root of the subdirectories. Note that `DataRepositorySubdirectories` is not supported for S3 data repositories.
     */
    public val dataRepositorySubdirectories: List<String>? = builder.dataRepositorySubdirectories
    /**
     * A path on the cache that points to a high-level directory (such as `/ns1/`) or subdirectory (such as `/ns1/subdir/`) that will be mapped 1-1 with `DataRepositoryPath`. The leading forward slash in the name is required. Two data repository associations cannot have overlapping cache paths. For example, if a data repository is associated with cache path `/ns1/`, then you cannot link another data repository with cache path `/ns1/ns2`.
     *
     * This path specifies where in your cache files will be exported from. This cache directory can be linked to only one data repository, and no data repository other can be linked to the directory.
     *
     * The cache path can only be set to root (/) on an NFS DRA when `DataRepositorySubdirectories` is specified. If you specify root (/) as the cache path, you can create only one DRA on the cache.
     *
     * The cache path cannot be set to root (/) for an S3 DRA.
     */
    public val fileCachePath: kotlin.String? = builder.fileCachePath
    /**
     * The configuration for a data repository association that links an Amazon File Cache resource to an NFS data repository.
     */
    public val nfs: aws.sdk.kotlin.services.fsx.model.FileCacheNfsConfiguration? = builder.nfs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.FileCacheDataRepositoryAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FileCacheDataRepositoryAssociation(")
        append("dataRepositoryPath=$dataRepositoryPath,")
        append("dataRepositorySubdirectories=$dataRepositorySubdirectories,")
        append("fileCachePath=$fileCachePath,")
        append("nfs=$nfs")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataRepositoryPath?.hashCode() ?: 0
        result = 31 * result + (dataRepositorySubdirectories?.hashCode() ?: 0)
        result = 31 * result + (fileCachePath?.hashCode() ?: 0)
        result = 31 * result + (nfs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FileCacheDataRepositoryAssociation

        if (dataRepositoryPath != other.dataRepositoryPath) return false
        if (dataRepositorySubdirectories != other.dataRepositorySubdirectories) return false
        if (fileCachePath != other.fileCachePath) return false
        if (nfs != other.nfs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.FileCacheDataRepositoryAssociation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The path to the S3 or NFS data repository that links to the cache. You must provide one of the following paths:
         * + The path can be an NFS data repository that links to the cache. The path can be in one of two formats:
         *    + If you are not using the `DataRepositorySubdirectories` parameter, the path is to an NFS Export directory (or one of its subdirectories) in the format `nsf://nfs-domain-name/exportpath`. You can therefore link a single NFS Export to a single data repository association.
         *    + If you are using the `DataRepositorySubdirectories` parameter, the path is the domain name of the NFS file system in the format `nfs://filer-domain-name`, which indicates the root of the subdirectories specified with the `DataRepositorySubdirectories` parameter.
         * + The path can be an S3 bucket or prefix in the format `s3://myBucket/myPrefix/`.
         */
        public var dataRepositoryPath: kotlin.String? = null
        /**
         * A list of NFS Exports that will be linked with this data repository association. The Export paths are in the format `/exportpath1`. To use this parameter, you must configure `DataRepositoryPath` as the domain name of the NFS file system. The NFS file system domain name in effect is the root of the subdirectories. Note that `DataRepositorySubdirectories` is not supported for S3 data repositories.
         */
        public var dataRepositorySubdirectories: List<String>? = null
        /**
         * A path on the cache that points to a high-level directory (such as `/ns1/`) or subdirectory (such as `/ns1/subdir/`) that will be mapped 1-1 with `DataRepositoryPath`. The leading forward slash in the name is required. Two data repository associations cannot have overlapping cache paths. For example, if a data repository is associated with cache path `/ns1/`, then you cannot link another data repository with cache path `/ns1/ns2`.
         *
         * This path specifies where in your cache files will be exported from. This cache directory can be linked to only one data repository, and no data repository other can be linked to the directory.
         *
         * The cache path can only be set to root (/) on an NFS DRA when `DataRepositorySubdirectories` is specified. If you specify root (/) as the cache path, you can create only one DRA on the cache.
         *
         * The cache path cannot be set to root (/) for an S3 DRA.
         */
        public var fileCachePath: kotlin.String? = null
        /**
         * The configuration for a data repository association that links an Amazon File Cache resource to an NFS data repository.
         */
        public var nfs: aws.sdk.kotlin.services.fsx.model.FileCacheNfsConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.FileCacheDataRepositoryAssociation) : this() {
            this.dataRepositoryPath = x.dataRepositoryPath
            this.dataRepositorySubdirectories = x.dataRepositorySubdirectories
            this.fileCachePath = x.fileCachePath
            this.nfs = x.nfs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.FileCacheDataRepositoryAssociation = FileCacheDataRepositoryAssociation(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.FileCacheNfsConfiguration] inside the given [block]
         */
        public fun nfs(block: aws.sdk.kotlin.services.fsx.model.FileCacheNfsConfiguration.Builder.() -> kotlin.Unit) {
            this.nfs = aws.sdk.kotlin.services.fsx.model.FileCacheNfsConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
