// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The response object for the Amazon File Cache resource being created in the `CreateFileCache` operation.
 */
public class FileCacheCreating private constructor(builder: Builder) {
    /**
     * A boolean flag indicating whether tags for the cache should be copied to data repository associations.
     */
    public val copyTagsToDataRepositoryAssociations: kotlin.Boolean? = builder.copyTagsToDataRepositoryAssociations
    /**
     * The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * A list of IDs of data repository associations that are associated with this cache.
     */
    public val dataRepositoryAssociationIds: List<String>? = builder.dataRepositoryAssociationIds
    /**
     * The Domain Name System (DNS) name for the cache.
     */
    public val dnsName: kotlin.String? = builder.dnsName
    /**
     * A structure providing details of any failures that occurred.
     */
    public val failureDetails: aws.sdk.kotlin.services.fsx.model.FileCacheFailureDetails? = builder.failureDetails
    /**
     * The system-generated, unique ID of the cache.
     */
    public val fileCacheId: kotlin.String? = builder.fileCacheId
    /**
     * The type of cache, which must be `LUSTRE`.
     */
    public val fileCacheType: aws.sdk.kotlin.services.fsx.model.FileCacheType? = builder.fileCacheType
    /**
     * The Lustre version of the cache, which must be `2.12`.
     */
    public val fileCacheTypeVersion: kotlin.String? = builder.fileCacheTypeVersion
    /**
     * Specifies the ID of the Key Management Service (KMS) key to use for encrypting data on an Amazon File Cache. If a `KmsKeyId` isn't specified, the Amazon FSx-managed KMS key for your account is used. For more information, see [Encrypt](https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html) in the *Key Management Service API Reference*.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The lifecycle status of the cache. The following are the possible values and what they mean:
     * + `AVAILABLE` - The cache is in a healthy state, and is reachable and available for use.
     * + `CREATING` - The new cache is being created.
     * + `DELETING` - An existing cache is being deleted.
     * + `UPDATING` - The cache is undergoing a customer-initiated update.
     * + `FAILED` - An existing cache has experienced an unrecoverable failure. When creating a new cache, the cache was unable to be created.
     */
    public val lifecycle: aws.sdk.kotlin.services.fsx.model.FileCacheLifecycle? = builder.lifecycle
    /**
     * The configuration for the Amazon File Cache resource.
     */
    public val lustreConfiguration: aws.sdk.kotlin.services.fsx.model.FileCacheLustreConfiguration? = builder.lustreConfiguration
    /**
     * A list of network interface IDs.
     */
    public val networkInterfaceIds: List<String>? = builder.networkInterfaceIds
    /**
     * An Amazon Web Services account ID. This ID is a 12-digit number that you use to construct Amazon Resource Names (ARNs) for resources.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The storage capacity of the cache in gibibytes (GiB).
     */
    public val storageCapacity: kotlin.Int? = builder.storageCapacity
    /**
     * A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID in a call to the `CreateFileCache` operation.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * A list of `Tag` values, with a maximum of 50 elements.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The ID of your virtual private cloud (VPC). For more information, see [VPC and subnets](https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html) in the *Amazon VPC User Guide*.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.FileCacheCreating = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FileCacheCreating(")
        append("copyTagsToDataRepositoryAssociations=$copyTagsToDataRepositoryAssociations,")
        append("creationTime=$creationTime,")
        append("dataRepositoryAssociationIds=$dataRepositoryAssociationIds,")
        append("dnsName=$dnsName,")
        append("failureDetails=$failureDetails,")
        append("fileCacheId=$fileCacheId,")
        append("fileCacheType=$fileCacheType,")
        append("fileCacheTypeVersion=$fileCacheTypeVersion,")
        append("kmsKeyId=$kmsKeyId,")
        append("lifecycle=$lifecycle,")
        append("lustreConfiguration=$lustreConfiguration,")
        append("networkInterfaceIds=$networkInterfaceIds,")
        append("ownerId=$ownerId,")
        append("resourceArn=$resourceArn,")
        append("storageCapacity=$storageCapacity,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = copyTagsToDataRepositoryAssociations?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (dataRepositoryAssociationIds?.hashCode() ?: 0)
        result = 31 * result + (dnsName?.hashCode() ?: 0)
        result = 31 * result + (failureDetails?.hashCode() ?: 0)
        result = 31 * result + (fileCacheId?.hashCode() ?: 0)
        result = 31 * result + (fileCacheType?.hashCode() ?: 0)
        result = 31 * result + (fileCacheTypeVersion?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (lustreConfiguration?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceIds?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (storageCapacity ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FileCacheCreating

        if (copyTagsToDataRepositoryAssociations != other.copyTagsToDataRepositoryAssociations) return false
        if (creationTime != other.creationTime) return false
        if (dataRepositoryAssociationIds != other.dataRepositoryAssociationIds) return false
        if (dnsName != other.dnsName) return false
        if (failureDetails != other.failureDetails) return false
        if (fileCacheId != other.fileCacheId) return false
        if (fileCacheType != other.fileCacheType) return false
        if (fileCacheTypeVersion != other.fileCacheTypeVersion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (lifecycle != other.lifecycle) return false
        if (lustreConfiguration != other.lustreConfiguration) return false
        if (networkInterfaceIds != other.networkInterfaceIds) return false
        if (ownerId != other.ownerId) return false
        if (resourceArn != other.resourceArn) return false
        if (storageCapacity != other.storageCapacity) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.FileCacheCreating = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A boolean flag indicating whether tags for the cache should be copied to data repository associations.
         */
        public var copyTagsToDataRepositoryAssociations: kotlin.Boolean? = null
        /**
         * The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of IDs of data repository associations that are associated with this cache.
         */
        public var dataRepositoryAssociationIds: List<String>? = null
        /**
         * The Domain Name System (DNS) name for the cache.
         */
        public var dnsName: kotlin.String? = null
        /**
         * A structure providing details of any failures that occurred.
         */
        public var failureDetails: aws.sdk.kotlin.services.fsx.model.FileCacheFailureDetails? = null
        /**
         * The system-generated, unique ID of the cache.
         */
        public var fileCacheId: kotlin.String? = null
        /**
         * The type of cache, which must be `LUSTRE`.
         */
        public var fileCacheType: aws.sdk.kotlin.services.fsx.model.FileCacheType? = null
        /**
         * The Lustre version of the cache, which must be `2.12`.
         */
        public var fileCacheTypeVersion: kotlin.String? = null
        /**
         * Specifies the ID of the Key Management Service (KMS) key to use for encrypting data on an Amazon File Cache. If a `KmsKeyId` isn't specified, the Amazon FSx-managed KMS key for your account is used. For more information, see [Encrypt](https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html) in the *Key Management Service API Reference*.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The lifecycle status of the cache. The following are the possible values and what they mean:
         * + `AVAILABLE` - The cache is in a healthy state, and is reachable and available for use.
         * + `CREATING` - The new cache is being created.
         * + `DELETING` - An existing cache is being deleted.
         * + `UPDATING` - The cache is undergoing a customer-initiated update.
         * + `FAILED` - An existing cache has experienced an unrecoverable failure. When creating a new cache, the cache was unable to be created.
         */
        public var lifecycle: aws.sdk.kotlin.services.fsx.model.FileCacheLifecycle? = null
        /**
         * The configuration for the Amazon File Cache resource.
         */
        public var lustreConfiguration: aws.sdk.kotlin.services.fsx.model.FileCacheLustreConfiguration? = null
        /**
         * A list of network interface IDs.
         */
        public var networkInterfaceIds: List<String>? = null
        /**
         * An Amazon Web Services account ID. This ID is a 12-digit number that you use to construct Amazon Resource Names (ARNs) for resources.
         */
        public var ownerId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The storage capacity of the cache in gibibytes (GiB).
         */
        public var storageCapacity: kotlin.Int? = null
        /**
         * A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID in a call to the `CreateFileCache` operation.
         */
        public var subnetIds: List<String>? = null
        /**
         * A list of `Tag` values, with a maximum of 50 elements.
         */
        public var tags: List<Tag>? = null
        /**
         * The ID of your virtual private cloud (VPC). For more information, see [VPC and subnets](https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html) in the *Amazon VPC User Guide*.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.FileCacheCreating) : this() {
            this.copyTagsToDataRepositoryAssociations = x.copyTagsToDataRepositoryAssociations
            this.creationTime = x.creationTime
            this.dataRepositoryAssociationIds = x.dataRepositoryAssociationIds
            this.dnsName = x.dnsName
            this.failureDetails = x.failureDetails
            this.fileCacheId = x.fileCacheId
            this.fileCacheType = x.fileCacheType
            this.fileCacheTypeVersion = x.fileCacheTypeVersion
            this.kmsKeyId = x.kmsKeyId
            this.lifecycle = x.lifecycle
            this.lustreConfiguration = x.lustreConfiguration
            this.networkInterfaceIds = x.networkInterfaceIds
            this.ownerId = x.ownerId
            this.resourceArn = x.resourceArn
            this.storageCapacity = x.storageCapacity
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.FileCacheCreating = FileCacheCreating(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.FileCacheFailureDetails] inside the given [block]
         */
        public fun failureDetails(block: aws.sdk.kotlin.services.fsx.model.FileCacheFailureDetails.Builder.() -> kotlin.Unit) {
            this.failureDetails = aws.sdk.kotlin.services.fsx.model.FileCacheFailureDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.FileCacheLustreConfiguration] inside the given [block]
         */
        public fun lustreConfiguration(block: aws.sdk.kotlin.services.fsx.model.FileCacheLustreConfiguration.Builder.() -> kotlin.Unit) {
            this.lustreConfiguration = aws.sdk.kotlin.services.fsx.model.FileCacheLustreConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
