// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines the minimum amount of time since last access for a file to be eligible for release. Only files that have been exported to S3 and that were last accessed or modified before this point-in-time are eligible to be released from the Amazon FSx for Lustre file system.
 */
public class DurationSinceLastAccess private constructor(builder: Builder) {
    /**
     * The unit of time used by the `Value` parameter to determine if a file can be released, based on when it was last accessed. `DAYS` is the only supported value. This is a required parameter.
     */
    public val unit: aws.sdk.kotlin.services.fsx.model.FSxUnit? = builder.unit
    /**
     * An integer that represents the minimum amount of time (in days) since a file was last accessed in the file system. Only exported files with a `MAX(atime, ctime, mtime)` timestamp that is more than this amount of time in the past (relative to the task create time) will be released. The default of `Value` is `0`. This is a required parameter.
     *
     * If an exported file meets the last accessed time criteria, its file or directory path must also be specified in the `Paths` parameter of the operation in order for the file to be released.
     */
    public val value: kotlin.Long? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.DurationSinceLastAccess = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DurationSinceLastAccess(")
        append("unit=$unit,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = unit?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DurationSinceLastAccess

        if (unit != other.unit) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.DurationSinceLastAccess = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unit of time used by the `Value` parameter to determine if a file can be released, based on when it was last accessed. `DAYS` is the only supported value. This is a required parameter.
         */
        public var unit: aws.sdk.kotlin.services.fsx.model.FSxUnit? = null
        /**
         * An integer that represents the minimum amount of time (in days) since a file was last accessed in the file system. Only exported files with a `MAX(atime, ctime, mtime)` timestamp that is more than this amount of time in the past (relative to the task create time) will be released. The default of `Value` is `0`. This is a required parameter.
         *
         * If an exported file meets the last accessed time criteria, its file or directory path must also be specified in the `Paths` parameter of the operation in order for the file to be released.
         */
        public var value: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.DurationSinceLastAccess) : this() {
            this.unit = x.unit
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.DurationSinceLastAccess = DurationSinceLastAccess(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
