// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The request object for `DescribeFileSystems` operation.
 */
public class DescribeFileSystemsRequest private constructor(builder: Builder) {
    /**
     * IDs of the file systems whose descriptions you want to retrieve (String).
     */
    public val fileSystemIds: List<String>? = builder.fileSystemIds
    /**
     * Maximum number of file systems to return in the response (integer). This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the `MaxResults` parameter specified in the request and the service's internal maximum number of items per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * Opaque pagination token returned from a previous `DescribeFileSystems` operation (String). If a token present, the operation continues the list from where the returning call left off.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.DescribeFileSystemsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeFileSystemsRequest(")
        append("fileSystemIds=$fileSystemIds,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileSystemIds?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeFileSystemsRequest

        if (fileSystemIds != other.fileSystemIds) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.DescribeFileSystemsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * IDs of the file systems whose descriptions you want to retrieve (String).
         */
        public var fileSystemIds: List<String>? = null
        /**
         * Maximum number of file systems to return in the response (integer). This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the `MaxResults` parameter specified in the request and the service's internal maximum number of items per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * Opaque pagination token returned from a previous `DescribeFileSystems` operation (String). If a token present, the operation continues the list from where the returning call left off.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.DescribeFileSystemsRequest) : this() {
            this.fileSystemIds = x.fileSystemIds
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.DescribeFileSystemsRequest = DescribeFileSystemsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
