// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The request object for the `DescribeBackups` operation.
 */
public class DescribeBackupsRequest private constructor(builder: Builder) {
    /**
     * The IDs of the backups that you want to retrieve. This parameter value overrides any filters. If any IDs aren't found, a `BackupNotFound` error occurs.
     */
    public val backupIds: List<String>? = builder.backupIds
    /**
     * The filters structure. The supported names are `file-system-id`, `backup-type`, `file-system-type`, and `volume-id`.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * Maximum number of backups to return in the response. This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the `MaxResults` parameter specified in the request and the service's internal maximum number of items per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * An opaque pagination token returned from a previous `DescribeBackups` operation. If a token is present, the operation continues the list from where the returning call left off.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.DescribeBackupsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeBackupsRequest(")
        append("backupIds=$backupIds,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupIds?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeBackupsRequest

        if (backupIds != other.backupIds) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.DescribeBackupsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The IDs of the backups that you want to retrieve. This parameter value overrides any filters. If any IDs aren't found, a `BackupNotFound` error occurs.
         */
        public var backupIds: List<String>? = null
        /**
         * The filters structure. The supported names are `file-system-id`, `backup-type`, `file-system-type`, and `volume-id`.
         */
        public var filters: List<Filter>? = null
        /**
         * Maximum number of backups to return in the response. This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the `MaxResults` parameter specified in the request and the service's internal maximum number of items per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * An opaque pagination token returned from a previous `DescribeBackups` operation. If a token is present, the operation continues the list from where the returning call left off.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.DescribeBackupsRequest) : this() {
            this.backupIds = x.backupIds
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.DescribeBackupsRequest = DescribeBackupsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
