// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Use to specify skipping a final backup, adding tags to a final backup, or bypassing the retention period of an FSx for ONTAP SnapLock Enterprise volume when deleting an FSx for ONTAP volume.
 */
public class DeleteVolumeOntapConfiguration private constructor(builder: Builder) {
    /**
     * Setting this to `true` allows a SnapLock administrator to delete an FSx for ONTAP SnapLock Enterprise volume with unexpired write once, read many (WORM) files. The IAM permission `fsx:BypassSnaplockEnterpriseRetention` is also required to delete SnapLock Enterprise volumes with unexpired WORM files. The default value is `false`.
     *
     * For more information, see [ Deleting a SnapLock volume](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-delete-volume.html).
     */
    public val bypassSnaplockEnterpriseRetention: kotlin.Boolean? = builder.bypassSnaplockEnterpriseRetention
    /**
     * A list of `Tag` values, with a maximum of 50 elements.
     */
    public val finalBackupTags: List<Tag>? = builder.finalBackupTags
    /**
     * Set to true if you want to skip taking a final backup of the volume you are deleting.
     */
    public val skipFinalBackup: kotlin.Boolean? = builder.skipFinalBackup

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.DeleteVolumeOntapConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteVolumeOntapConfiguration(")
        append("bypassSnaplockEnterpriseRetention=$bypassSnaplockEnterpriseRetention,")
        append("finalBackupTags=$finalBackupTags,")
        append("skipFinalBackup=$skipFinalBackup")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bypassSnaplockEnterpriseRetention?.hashCode() ?: 0
        result = 31 * result + (finalBackupTags?.hashCode() ?: 0)
        result = 31 * result + (skipFinalBackup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteVolumeOntapConfiguration

        if (bypassSnaplockEnterpriseRetention != other.bypassSnaplockEnterpriseRetention) return false
        if (finalBackupTags != other.finalBackupTags) return false
        if (skipFinalBackup != other.skipFinalBackup) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.DeleteVolumeOntapConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Setting this to `true` allows a SnapLock administrator to delete an FSx for ONTAP SnapLock Enterprise volume with unexpired write once, read many (WORM) files. The IAM permission `fsx:BypassSnaplockEnterpriseRetention` is also required to delete SnapLock Enterprise volumes with unexpired WORM files. The default value is `false`.
         *
         * For more information, see [ Deleting a SnapLock volume](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snaplock-delete-volume.html).
         */
        public var bypassSnaplockEnterpriseRetention: kotlin.Boolean? = null
        /**
         * A list of `Tag` values, with a maximum of 50 elements.
         */
        public var finalBackupTags: List<Tag>? = null
        /**
         * Set to true if you want to skip taking a final backup of the volume you are deleting.
         */
        public var skipFinalBackup: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.DeleteVolumeOntapConfiguration) : this() {
            this.bypassSnaplockEnterpriseRetention = x.bypassSnaplockEnterpriseRetention
            this.finalBackupTags = x.finalBackupTags
            this.skipFinalBackup = x.skipFinalBackup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.DeleteVolumeOntapConfiguration = DeleteVolumeOntapConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
