// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration object for the Amazon FSx for OpenZFS file system used in the `DeleteFileSystem` operation.
 */
public class DeleteFileSystemOpenZfsConfiguration private constructor(builder: Builder) {
    /**
     * A list of tags to apply to the file system's final backup.
     */
    public val finalBackupTags: List<Tag>? = builder.finalBackupTags
    /**
     * To delete a file system if there are child volumes present below the root volume, use the string `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`. If your file system has child volumes and you don't use this option, the delete request will fail.
     */
    public val options: List<DeleteFileSystemOpenZfsOption>? = builder.options
    /**
     * By default, Amazon FSx for OpenZFS takes a final backup on your behalf when the `DeleteFileSystem` operation is invoked. Doing this helps protect you from data loss, and we highly recommend taking the final backup. If you want to skip taking a final backup, set this value to `true`.
     */
    public val skipFinalBackup: kotlin.Boolean? = builder.skipFinalBackup

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.DeleteFileSystemOpenZfsConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteFileSystemOpenZfsConfiguration(")
        append("finalBackupTags=$finalBackupTags,")
        append("options=$options,")
        append("skipFinalBackup=$skipFinalBackup")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = finalBackupTags?.hashCode() ?: 0
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (skipFinalBackup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteFileSystemOpenZfsConfiguration

        if (finalBackupTags != other.finalBackupTags) return false
        if (options != other.options) return false
        if (skipFinalBackup != other.skipFinalBackup) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.DeleteFileSystemOpenZfsConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of tags to apply to the file system's final backup.
         */
        public var finalBackupTags: List<Tag>? = null
        /**
         * To delete a file system if there are child volumes present below the root volume, use the string `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`. If your file system has child volumes and you don't use this option, the delete request will fail.
         */
        public var options: List<DeleteFileSystemOpenZfsOption>? = null
        /**
         * By default, Amazon FSx for OpenZFS takes a final backup on your behalf when the `DeleteFileSystem` operation is invoked. Doing this helps protect you from data loss, and we highly recommend taking the final backup. If you want to skip taking a final backup, set this value to `true`.
         */
        public var skipFinalBackup: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.DeleteFileSystemOpenZfsConfiguration) : this() {
            this.finalBackupTags = x.finalBackupTags
            this.options = x.options
            this.skipFinalBackup = x.skipFinalBackup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.DeleteFileSystemOpenZfsConfiguration = DeleteFileSystemOpenZfsConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
