// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the configuration of the Amazon FSx for OpenZFS volume that you are creating.
 */
public class CreateOpenZfsVolumeConfiguration private constructor(builder: Builder) {
    /**
     * A Boolean value indicating whether tags for the volume should be copied to snapshots. This value defaults to `false`. If it's set to `true`, all tags for the volume are copied to snapshots where the user doesn't specify tags. If this value is `true`, and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.
     */
    public val copyTagsToSnapshots: kotlin.Boolean? = builder.copyTagsToSnapshots
    /**
     * Specifies the method used to compress the data on the volume. The compression type is `NONE` by default.
     * + `NONE` - Doesn't compress the data on the volume. `NONE` is the default.
     * + `ZSTD` - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. ZSTD compression provides a higher level of data compression and higher read throughput performance than LZ4 compression.
     * + `LZ4` - Compresses the data in the volume using the LZ4 compression algorithm. LZ4 compression provides a lower level of compression and higher write throughput performance than ZSTD compression.
     *
     * For more information about volume compression types and the performance of your Amazon FSx for OpenZFS file system, see [ Tips for maximizing performance](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs) File system and volume settings in the *Amazon FSx for OpenZFS User Guide*.
     */
    public val dataCompressionType: aws.sdk.kotlin.services.fsx.model.OpenZfsDataCompressionType? = builder.dataCompressionType
    /**
     * The configuration object for mounting a Network File System (NFS) file system.
     */
    public val nfsExports: List<OpenZfsNfsExport>? = builder.nfsExports
    /**
     * The configuration object that specifies the snapshot to use as the origin of the data for the volume.
     */
    public val originSnapshot: aws.sdk.kotlin.services.fsx.model.CreateOpenZfsOriginSnapshotConfiguration? = builder.originSnapshot
    /**
     * The ID of the volume to use as the parent volume of the volume that you are creating.
     */
    public val parentVolumeId: kotlin.String? = builder.parentVolumeId
    /**
     * A Boolean value indicating whether the volume is read-only.
     */
    public val readOnly: kotlin.Boolean? = builder.readOnly
    /**
     * Specifies the suggested block size for a volume in a ZFS dataset, in kibibytes (KiB). Valid values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB. We recommend using the default setting for the majority of use cases. Generally, workloads that write in fixed small or large record sizes may benefit from setting a custom record size, like database workloads (small record size) or media streaming workloads (large record size). For additional guidance on when to set a custom record size, see [ ZFS Record size](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#record-size-performance) in the *Amazon FSx for OpenZFS User Guide*.
     */
    public val recordSizeKib: kotlin.Int? = builder.recordSizeKib
    /**
     * Sets the maximum storage size in gibibytes (GiB) for the volume. You can specify a quota that is larger than the storage on the parent volume. A volume quota limits the amount of storage that the volume can consume to the configured amount, but does not guarantee the space will be available on the parent volume. To guarantee quota space, you must also set `StorageCapacityReservationGiB`. To *not* specify a storage capacity quota, set this to `-1`.
     *
     * For more information, see [Volume properties](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties) in the *Amazon FSx for OpenZFS User Guide*.
     */
    public val storageCapacityQuotaGib: kotlin.Int? = builder.storageCapacityQuotaGib
    /**
     * Specifies the amount of storage in gibibytes (GiB) to reserve from the parent volume. Setting `StorageCapacityReservationGiB` guarantees that the specified amount of storage space on the parent volume will always be available for the volume. You can't reserve more storage than the parent volume has. To *not* specify a storage capacity reservation, set this to `0` or `-1`. For more information, see [Volume properties](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties) in the *Amazon FSx for OpenZFS User Guide*.
     */
    public val storageCapacityReservationGib: kotlin.Int? = builder.storageCapacityReservationGib
    /**
     * Configures how much storage users and groups can use on the volume.
     */
    public val userAndGroupQuotas: List<OpenZfsUserOrGroupQuota>? = builder.userAndGroupQuotas

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.CreateOpenZfsVolumeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateOpenZfsVolumeConfiguration(")
        append("copyTagsToSnapshots=$copyTagsToSnapshots,")
        append("dataCompressionType=$dataCompressionType,")
        append("nfsExports=$nfsExports,")
        append("originSnapshot=$originSnapshot,")
        append("parentVolumeId=$parentVolumeId,")
        append("readOnly=$readOnly,")
        append("recordSizeKib=$recordSizeKib,")
        append("storageCapacityQuotaGib=$storageCapacityQuotaGib,")
        append("storageCapacityReservationGib=$storageCapacityReservationGib,")
        append("userAndGroupQuotas=$userAndGroupQuotas")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = copyTagsToSnapshots?.hashCode() ?: 0
        result = 31 * result + (dataCompressionType?.hashCode() ?: 0)
        result = 31 * result + (nfsExports?.hashCode() ?: 0)
        result = 31 * result + (originSnapshot?.hashCode() ?: 0)
        result = 31 * result + (parentVolumeId?.hashCode() ?: 0)
        result = 31 * result + (readOnly?.hashCode() ?: 0)
        result = 31 * result + (recordSizeKib ?: 0)
        result = 31 * result + (storageCapacityQuotaGib ?: 0)
        result = 31 * result + (storageCapacityReservationGib ?: 0)
        result = 31 * result + (userAndGroupQuotas?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateOpenZfsVolumeConfiguration

        if (copyTagsToSnapshots != other.copyTagsToSnapshots) return false
        if (dataCompressionType != other.dataCompressionType) return false
        if (nfsExports != other.nfsExports) return false
        if (originSnapshot != other.originSnapshot) return false
        if (parentVolumeId != other.parentVolumeId) return false
        if (readOnly != other.readOnly) return false
        if (recordSizeKib != other.recordSizeKib) return false
        if (storageCapacityQuotaGib != other.storageCapacityQuotaGib) return false
        if (storageCapacityReservationGib != other.storageCapacityReservationGib) return false
        if (userAndGroupQuotas != other.userAndGroupQuotas) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.CreateOpenZfsVolumeConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A Boolean value indicating whether tags for the volume should be copied to snapshots. This value defaults to `false`. If it's set to `true`, all tags for the volume are copied to snapshots where the user doesn't specify tags. If this value is `true`, and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.
         */
        public var copyTagsToSnapshots: kotlin.Boolean? = null
        /**
         * Specifies the method used to compress the data on the volume. The compression type is `NONE` by default.
         * + `NONE` - Doesn't compress the data on the volume. `NONE` is the default.
         * + `ZSTD` - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. ZSTD compression provides a higher level of data compression and higher read throughput performance than LZ4 compression.
         * + `LZ4` - Compresses the data in the volume using the LZ4 compression algorithm. LZ4 compression provides a lower level of compression and higher write throughput performance than ZSTD compression.
         *
         * For more information about volume compression types and the performance of your Amazon FSx for OpenZFS file system, see [ Tips for maximizing performance](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs) File system and volume settings in the *Amazon FSx for OpenZFS User Guide*.
         */
        public var dataCompressionType: aws.sdk.kotlin.services.fsx.model.OpenZfsDataCompressionType? = null
        /**
         * The configuration object for mounting a Network File System (NFS) file system.
         */
        public var nfsExports: List<OpenZfsNfsExport>? = null
        /**
         * The configuration object that specifies the snapshot to use as the origin of the data for the volume.
         */
        public var originSnapshot: aws.sdk.kotlin.services.fsx.model.CreateOpenZfsOriginSnapshotConfiguration? = null
        /**
         * The ID of the volume to use as the parent volume of the volume that you are creating.
         */
        public var parentVolumeId: kotlin.String? = null
        /**
         * A Boolean value indicating whether the volume is read-only.
         */
        public var readOnly: kotlin.Boolean? = null
        /**
         * Specifies the suggested block size for a volume in a ZFS dataset, in kibibytes (KiB). Valid values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB. We recommend using the default setting for the majority of use cases. Generally, workloads that write in fixed small or large record sizes may benefit from setting a custom record size, like database workloads (small record size) or media streaming workloads (large record size). For additional guidance on when to set a custom record size, see [ ZFS Record size](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#record-size-performance) in the *Amazon FSx for OpenZFS User Guide*.
         */
        public var recordSizeKib: kotlin.Int? = null
        /**
         * Sets the maximum storage size in gibibytes (GiB) for the volume. You can specify a quota that is larger than the storage on the parent volume. A volume quota limits the amount of storage that the volume can consume to the configured amount, but does not guarantee the space will be available on the parent volume. To guarantee quota space, you must also set `StorageCapacityReservationGiB`. To *not* specify a storage capacity quota, set this to `-1`.
         *
         * For more information, see [Volume properties](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties) in the *Amazon FSx for OpenZFS User Guide*.
         */
        public var storageCapacityQuotaGib: kotlin.Int? = null
        /**
         * Specifies the amount of storage in gibibytes (GiB) to reserve from the parent volume. Setting `StorageCapacityReservationGiB` guarantees that the specified amount of storage space on the parent volume will always be available for the volume. You can't reserve more storage than the parent volume has. To *not* specify a storage capacity reservation, set this to `0` or `-1`. For more information, see [Volume properties](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties) in the *Amazon FSx for OpenZFS User Guide*.
         */
        public var storageCapacityReservationGib: kotlin.Int? = null
        /**
         * Configures how much storage users and groups can use on the volume.
         */
        public var userAndGroupQuotas: List<OpenZfsUserOrGroupQuota>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.CreateOpenZfsVolumeConfiguration) : this() {
            this.copyTagsToSnapshots = x.copyTagsToSnapshots
            this.dataCompressionType = x.dataCompressionType
            this.nfsExports = x.nfsExports
            this.originSnapshot = x.originSnapshot
            this.parentVolumeId = x.parentVolumeId
            this.readOnly = x.readOnly
            this.recordSizeKib = x.recordSizeKib
            this.storageCapacityQuotaGib = x.storageCapacityQuotaGib
            this.storageCapacityReservationGib = x.storageCapacityReservationGib
            this.userAndGroupQuotas = x.userAndGroupQuotas
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.CreateOpenZfsVolumeConfiguration = CreateOpenZfsVolumeConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.CreateOpenZfsOriginSnapshotConfiguration] inside the given [block]
         */
        public fun originSnapshot(block: aws.sdk.kotlin.services.fsx.model.CreateOpenZfsOriginSnapshotConfiguration.Builder.() -> kotlin.Unit) {
            this.originSnapshot = aws.sdk.kotlin.services.fsx.model.CreateOpenZfsOriginSnapshotConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
