// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the configuration of the ONTAP volume that you are creating.
 */
public class CreateOntapVolumeConfiguration private constructor(builder: Builder) {
    /**
     * Use to specify configuration options for a volume’s storage aggregate or aggregates.
     */
    public val aggregateConfiguration: aws.sdk.kotlin.services.fsx.model.CreateAggregateConfiguration? = builder.aggregateConfiguration
    /**
     * A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to false. If it's set to true, all tags for the volume are copied to all automatic and user-initiated backups where the user doesn't specify tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the volume, regardless of this value.
     */
    public val copyTagsToBackups: kotlin.Boolean? = builder.copyTagsToBackups
    /**
     * Specifies the location in the SVM's namespace where the volume is mounted. This parameter is required. The `JunctionPath` must have a leading forward slash, such as `/vol3`.
     */
    public val junctionPath: kotlin.String? = builder.junctionPath
    /**
     * Specifies the type of volume you are creating. Valid values are the following:
     * + `RW` specifies a read/write volume. `RW` is the default.
     * + `DP` specifies a data-protection volume. A `DP` volume is read-only and can be used as the destination of a NetApp SnapMirror relationship.
     *
     * For more information, see [Volume types](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types) in the Amazon FSx for NetApp ONTAP User Guide.
     */
    public val ontapVolumeType: aws.sdk.kotlin.services.fsx.model.InputOntapVolumeType? = builder.ontapVolumeType
    /**
     * Specifies the security style for the volume. If a volume's security style is not specified, it is automatically set to the root volume's security style. The security style determines the type of permissions that FSx for ONTAP uses to control data access. For more information, see [Volume security style](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style) in the *Amazon FSx for NetApp ONTAP User Guide*. Specify one of the following values:
     * + `UNIX` if the file system is managed by a UNIX administrator, the majority of users are NFS clients, and an application accessing the data uses a UNIX user as the service account.
     * + `NTFS` if the file system is managed by a Windows administrator, the majority of users are SMB clients, and an application accessing the data uses a Windows user as the service account.
     * + `MIXED` This is an advanced setting. For more information, see the topic [What the security styles and their effects are](https://docs.netapp.com/us-en/ontap/nfs-admin/security-styles-their-effects-concept.html) in the NetApp Documentation Center.
     *
     * For more information, see [Volume security style](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style.html) in the FSx for ONTAP User Guide.
     */
    public val securityStyle: aws.sdk.kotlin.services.fsx.model.SecurityStyle? = builder.securityStyle
    /**
     * Specifies the configured size of the volume, in bytes.
     */
    public val sizeInBytes: kotlin.Long? = builder.sizeInBytes
    /**
     * Use `SizeInBytes` instead. Specifies the size of the volume, in megabytes (MB), that you are creating.
     */
    @Deprecated("This property is deprecated, use SizeInBytes instead")
    public val sizeInMegabytes: kotlin.Int? = builder.sizeInMegabytes
    /**
     * Specifies the SnapLock configuration for an FSx for ONTAP volume.
     */
    public val snaplockConfiguration: aws.sdk.kotlin.services.fsx.model.CreateSnaplockConfiguration? = builder.snaplockConfiguration
    /**
     * Specifies the snapshot policy for the volume. There are three built-in snapshot policies:
     * + `default`: This is the default policy. A maximum of six hourly snapshots taken five minutes past the hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after midnight. A maximum of two weekly snapshots taken every Sunday at 15 minutes after midnight.
     * + `default-1weekly`: This policy is the same as the `default` policy except that it only retains one snapshot from the weekly schedule.
     * + `none`: This policy does not take any snapshots. This policy can be assigned to volumes to prevent automatic snapshots from being taken.
     *
     * You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
     *
     * For more information, see [Snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the Amazon FSx for NetApp ONTAP User Guide.
     */
    public val snapshotPolicy: kotlin.String? = builder.snapshotPolicy
    /**
     * Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume, or set to false to disable them.
     *
     * `StorageEfficiencyEnabled` is required when creating a `RW` volume (`OntapVolumeType` set to `RW`).
     */
    public val storageEfficiencyEnabled: kotlin.Boolean? = builder.storageEfficiencyEnabled
    /**
     * Specifies the ONTAP SVM in which to create the volume.
     */
    public val storageVirtualMachineId: kotlin.String? = builder.storageVirtualMachineId
    /**
     * Describes the data tiering policy for an ONTAP volume. When enabled, Amazon FSx for ONTAP's intelligent tiering automatically transitions a volume's data between the file system's primary storage and capacity pool storage based on your access patterns.
     *
     * Valid tiering policies are the following:
     * + `SNAPSHOT_ONLY` - (Default value) moves cold snapshots to the capacity pool storage tier.
     *
     * + `AUTO` - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.
     *
     * + `ALL` - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.
     *
     * + `NONE` - keeps a volume's data in the primary storage tier, preventing it from being moved to the capacity pool tier.
     */
    public val tieringPolicy: aws.sdk.kotlin.services.fsx.model.TieringPolicy? = builder.tieringPolicy
    /**
     * Use to specify the style of an ONTAP volume. FSx for ONTAP offers two styles of volumes that you can use for different purposes, FlexVol and FlexGroup volumes. For more information, see [Volume styles](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html) in the Amazon FSx for NetApp ONTAP User Guide.
     */
    public val volumeStyle: aws.sdk.kotlin.services.fsx.model.VolumeStyle? = builder.volumeStyle

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.CreateOntapVolumeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateOntapVolumeConfiguration(")
        append("aggregateConfiguration=$aggregateConfiguration,")
        append("copyTagsToBackups=$copyTagsToBackups,")
        append("junctionPath=$junctionPath,")
        append("ontapVolumeType=$ontapVolumeType,")
        append("securityStyle=$securityStyle,")
        append("sizeInBytes=$sizeInBytes,")
        append("sizeInMegabytes=$sizeInMegabytes,")
        append("snaplockConfiguration=$snaplockConfiguration,")
        append("snapshotPolicy=$snapshotPolicy,")
        append("storageEfficiencyEnabled=$storageEfficiencyEnabled,")
        append("storageVirtualMachineId=$storageVirtualMachineId,")
        append("tieringPolicy=$tieringPolicy,")
        append("volumeStyle=$volumeStyle")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregateConfiguration?.hashCode() ?: 0
        result = 31 * result + (copyTagsToBackups?.hashCode() ?: 0)
        result = 31 * result + (junctionPath?.hashCode() ?: 0)
        result = 31 * result + (ontapVolumeType?.hashCode() ?: 0)
        result = 31 * result + (securityStyle?.hashCode() ?: 0)
        result = 31 * result + (sizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (sizeInMegabytes ?: 0)
        result = 31 * result + (snaplockConfiguration?.hashCode() ?: 0)
        result = 31 * result + (snapshotPolicy?.hashCode() ?: 0)
        result = 31 * result + (storageEfficiencyEnabled?.hashCode() ?: 0)
        result = 31 * result + (storageVirtualMachineId?.hashCode() ?: 0)
        result = 31 * result + (tieringPolicy?.hashCode() ?: 0)
        result = 31 * result + (volumeStyle?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateOntapVolumeConfiguration

        if (aggregateConfiguration != other.aggregateConfiguration) return false
        if (copyTagsToBackups != other.copyTagsToBackups) return false
        if (junctionPath != other.junctionPath) return false
        if (ontapVolumeType != other.ontapVolumeType) return false
        if (securityStyle != other.securityStyle) return false
        if (sizeInBytes != other.sizeInBytes) return false
        if (sizeInMegabytes != other.sizeInMegabytes) return false
        if (snaplockConfiguration != other.snaplockConfiguration) return false
        if (snapshotPolicy != other.snapshotPolicy) return false
        if (storageEfficiencyEnabled != other.storageEfficiencyEnabled) return false
        if (storageVirtualMachineId != other.storageVirtualMachineId) return false
        if (tieringPolicy != other.tieringPolicy) return false
        if (volumeStyle != other.volumeStyle) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.CreateOntapVolumeConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Use to specify configuration options for a volume’s storage aggregate or aggregates.
         */
        public var aggregateConfiguration: aws.sdk.kotlin.services.fsx.model.CreateAggregateConfiguration? = null
        /**
         * A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to false. If it's set to true, all tags for the volume are copied to all automatic and user-initiated backups where the user doesn't specify tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the volume, regardless of this value.
         */
        public var copyTagsToBackups: kotlin.Boolean? = null
        /**
         * Specifies the location in the SVM's namespace where the volume is mounted. This parameter is required. The `JunctionPath` must have a leading forward slash, such as `/vol3`.
         */
        public var junctionPath: kotlin.String? = null
        /**
         * Specifies the type of volume you are creating. Valid values are the following:
         * + `RW` specifies a read/write volume. `RW` is the default.
         * + `DP` specifies a data-protection volume. A `DP` volume is read-only and can be used as the destination of a NetApp SnapMirror relationship.
         *
         * For more information, see [Volume types](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-types) in the Amazon FSx for NetApp ONTAP User Guide.
         */
        public var ontapVolumeType: aws.sdk.kotlin.services.fsx.model.InputOntapVolumeType? = null
        /**
         * Specifies the security style for the volume. If a volume's security style is not specified, it is automatically set to the root volume's security style. The security style determines the type of permissions that FSx for ONTAP uses to control data access. For more information, see [Volume security style](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style) in the *Amazon FSx for NetApp ONTAP User Guide*. Specify one of the following values:
         * + `UNIX` if the file system is managed by a UNIX administrator, the majority of users are NFS clients, and an application accessing the data uses a UNIX user as the service account.
         * + `NTFS` if the file system is managed by a Windows administrator, the majority of users are SMB clients, and an application accessing the data uses a Windows user as the service account.
         * + `MIXED` This is an advanced setting. For more information, see the topic [What the security styles and their effects are](https://docs.netapp.com/us-en/ontap/nfs-admin/security-styles-their-effects-concept.html) in the NetApp Documentation Center.
         *
         * For more information, see [Volume security style](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style.html) in the FSx for ONTAP User Guide.
         */
        public var securityStyle: aws.sdk.kotlin.services.fsx.model.SecurityStyle? = null
        /**
         * Specifies the configured size of the volume, in bytes.
         */
        public var sizeInBytes: kotlin.Long? = null
        /**
         * Use `SizeInBytes` instead. Specifies the size of the volume, in megabytes (MB), that you are creating.
         */
        @Deprecated("This property is deprecated, use SizeInBytes instead")
        public var sizeInMegabytes: kotlin.Int? = null
        /**
         * Specifies the SnapLock configuration for an FSx for ONTAP volume.
         */
        public var snaplockConfiguration: aws.sdk.kotlin.services.fsx.model.CreateSnaplockConfiguration? = null
        /**
         * Specifies the snapshot policy for the volume. There are three built-in snapshot policies:
         * + `default`: This is the default policy. A maximum of six hourly snapshots taken five minutes past the hour. A maximum of two daily snapshots taken Monday through Saturday at 10 minutes after midnight. A maximum of two weekly snapshots taken every Sunday at 15 minutes after midnight.
         * + `default-1weekly`: This policy is the same as the `default` policy except that it only retains one snapshot from the weekly schedule.
         * + `none`: This policy does not take any snapshots. This policy can be assigned to volumes to prevent automatic snapshots from being taken.
         *
         * You can also provide the name of a custom policy that you created with the ONTAP CLI or REST API.
         *
         * For more information, see [Snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the Amazon FSx for NetApp ONTAP User Guide.
         */
        public var snapshotPolicy: kotlin.String? = null
        /**
         * Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume, or set to false to disable them.
         *
         * `StorageEfficiencyEnabled` is required when creating a `RW` volume (`OntapVolumeType` set to `RW`).
         */
        public var storageEfficiencyEnabled: kotlin.Boolean? = null
        /**
         * Specifies the ONTAP SVM in which to create the volume.
         */
        public var storageVirtualMachineId: kotlin.String? = null
        /**
         * Describes the data tiering policy for an ONTAP volume. When enabled, Amazon FSx for ONTAP's intelligent tiering automatically transitions a volume's data between the file system's primary storage and capacity pool storage based on your access patterns.
         *
         * Valid tiering policies are the following:
         * + `SNAPSHOT_ONLY` - (Default value) moves cold snapshots to the capacity pool storage tier.
         *
         * + `AUTO` - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.
         *
         * + `ALL` - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.
         *
         * + `NONE` - keeps a volume's data in the primary storage tier, preventing it from being moved to the capacity pool tier.
         */
        public var tieringPolicy: aws.sdk.kotlin.services.fsx.model.TieringPolicy? = null
        /**
         * Use to specify the style of an ONTAP volume. FSx for ONTAP offers two styles of volumes that you can use for different purposes, FlexVol and FlexGroup volumes. For more information, see [Volume styles](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html) in the Amazon FSx for NetApp ONTAP User Guide.
         */
        public var volumeStyle: aws.sdk.kotlin.services.fsx.model.VolumeStyle? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.CreateOntapVolumeConfiguration) : this() {
            this.aggregateConfiguration = x.aggregateConfiguration
            this.copyTagsToBackups = x.copyTagsToBackups
            this.junctionPath = x.junctionPath
            this.ontapVolumeType = x.ontapVolumeType
            this.securityStyle = x.securityStyle
            this.sizeInBytes = x.sizeInBytes
            this.sizeInMegabytes = x.sizeInMegabytes
            this.snaplockConfiguration = x.snaplockConfiguration
            this.snapshotPolicy = x.snapshotPolicy
            this.storageEfficiencyEnabled = x.storageEfficiencyEnabled
            this.storageVirtualMachineId = x.storageVirtualMachineId
            this.tieringPolicy = x.tieringPolicy
            this.volumeStyle = x.volumeStyle
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.CreateOntapVolumeConfiguration = CreateOntapVolumeConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.CreateAggregateConfiguration] inside the given [block]
         */
        public fun aggregateConfiguration(block: aws.sdk.kotlin.services.fsx.model.CreateAggregateConfiguration.Builder.() -> kotlin.Unit) {
            this.aggregateConfiguration = aws.sdk.kotlin.services.fsx.model.CreateAggregateConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.CreateSnaplockConfiguration] inside the given [block]
         */
        public fun snaplockConfiguration(block: aws.sdk.kotlin.services.fsx.model.CreateSnaplockConfiguration.Builder.() -> kotlin.Unit) {
            this.snaplockConfiguration = aws.sdk.kotlin.services.fsx.model.CreateSnaplockConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.TieringPolicy] inside the given [block]
         */
        public fun tieringPolicy(block: aws.sdk.kotlin.services.fsx.model.TieringPolicy.Builder.() -> kotlin.Unit) {
            this.tieringPolicy = aws.sdk.kotlin.services.fsx.model.TieringPolicy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
