// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration object for the Microsoft Windows file system used in `CreateFileSystem` and `CreateFileSystemFromBackup` operations.
 */
public class CreateFileSystemWindowsConfiguration private constructor(builder: Builder) {
    /**
     * The ID for an existing Amazon Web Services Managed Microsoft Active Directory (AD) instance that the file system should join when it's created.
     */
    public val activeDirectoryId: kotlin.String? = builder.activeDirectoryId
    /**
     * An array of one or more DNS alias names that you want to associate with the Amazon FSx file system. Aliases allow you to use existing DNS names to access the data in your Amazon FSx file system. You can associate up to 50 aliases with a file system at any time. You can associate additional DNS aliases after you create the file system using the AssociateFileSystemAliases operation. You can remove DNS aliases from the file system after it is created using the DisassociateFileSystemAliases operation. You only need to specify the alias name in the request payload.
     *
     * For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html) and [Walkthrough 5: Using DNS aliases to access your file system](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html), including additional steps you must take to be able to access your file system using a DNS alias.
     *
     * An alias name has to meet the following requirements:
     * + Formatted as a fully-qualified domain name (FQDN), `hostname.domain`, for example, `accounting.example.com`.
     * + Can contain alphanumeric characters, the underscore (_), and the hyphen (-).
     * + Cannot start or end with a hyphen.
     * + Can start with a numeric.
     *
     * For DNS alias names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them: as uppercase letters, lowercase letters, or the corresponding letters in escape codes.
     */
    public val aliases: List<String>? = builder.aliases
    /**
     * The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system.
     */
    public val auditLogConfiguration: aws.sdk.kotlin.services.fsx.model.WindowsAuditLogCreateConfiguration? = builder.auditLogConfiguration
    /**
     * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `30`.
     */
    public val automaticBackupRetentionDays: kotlin.Int? = builder.automaticBackupRetentionDays
    /**
     * A boolean flag indicating whether tags for the file system should be copied to backups. This value defaults to false. If it's set to true, all tags for the file system are copied to all automatic and user-initiated backups where the user doesn't specify tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
     */
    public val copyTagsToBackups: kotlin.Boolean? = builder.copyTagsToBackups
    /**
     * The preferred time to take daily automatic backups, formatted HH:MM in the UTC time zone.
     */
    public val dailyAutomaticBackupStartTime: kotlin.String? = builder.dailyAutomaticBackupStartTime
    /**
     * Specifies the file system deployment type, valid values are the following:
     * + `MULTI_AZ_1` - Deploys a high availability file system that is configured for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability. You can only deploy a Multi-AZ file system in Amazon Web Services Regions that have a minimum of three Availability Zones. Also supports HDD storage type
     * + `SINGLE_AZ_1` - (Default) Choose to deploy a file system that is configured for single AZ redundancy.
     * + `SINGLE_AZ_2` - The latest generation Single AZ file system. Specifies a file system that is configured for single AZ redundancy and supports HDD storage type.
     *
     * For more information, see [ Availability and Durability: Single-AZ and Multi-AZ File Systems](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html).
     */
    public val deploymentType: aws.sdk.kotlin.services.fsx.model.WindowsDeploymentType? = builder.deploymentType
    /**
     * The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for Windows file system. By default, Amazon FSx automatically provisions 3 IOPS per GiB of storage capacity. You can provision additional IOPS per GiB of storage, up to the maximum limit associated with your chosen throughput capacity.
     */
    public val diskIopsConfiguration: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration? = builder.diskIopsConfiguration
    /**
     * Required when `DeploymentType` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located. For in-Amazon Web Services applications, we recommend that you launch your clients in the same Availability Zone (AZ) as your preferred file server to reduce cross-AZ data transfer costs and minimize latency.
     */
    public val preferredSubnetId: kotlin.String? = builder.preferredSubnetId
    /**
     * The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an FSx for ONTAP storage virtual machine (SVM) to a self-managed (including on-premises) Microsoft Active Directory (AD) directory. For more information, see [ Using Amazon FSx for Windows with your self-managed Microsoft Active Directory](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html) or [Managing FSx for ONTAP SVMs](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html).
     */
    public val selfManagedActiveDirectoryConfiguration: aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfiguration? = builder.selfManagedActiveDirectoryConfiguration
    /**
     * Sets the throughput capacity of an Amazon FSx file system, measured in megabytes per second (MB/s), in 2 to the *n*th increments, between 2^3 (8) and 2^11 (2048).
     */
    public val throughputCapacity: kotlin.Int? = builder.throughputCapacity
    /**
     * The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
     */
    public val weeklyMaintenanceStartTime: kotlin.String? = builder.weeklyMaintenanceStartTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.CreateFileSystemWindowsConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFileSystemWindowsConfiguration(")
        append("activeDirectoryId=$activeDirectoryId,")
        append("aliases=$aliases,")
        append("auditLogConfiguration=$auditLogConfiguration,")
        append("automaticBackupRetentionDays=$automaticBackupRetentionDays,")
        append("copyTagsToBackups=$copyTagsToBackups,")
        append("dailyAutomaticBackupStartTime=$dailyAutomaticBackupStartTime,")
        append("deploymentType=$deploymentType,")
        append("diskIopsConfiguration=$diskIopsConfiguration,")
        append("preferredSubnetId=$preferredSubnetId,")
        append("selfManagedActiveDirectoryConfiguration=$selfManagedActiveDirectoryConfiguration,")
        append("throughputCapacity=$throughputCapacity,")
        append("weeklyMaintenanceStartTime=$weeklyMaintenanceStartTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeDirectoryId?.hashCode() ?: 0
        result = 31 * result + (aliases?.hashCode() ?: 0)
        result = 31 * result + (auditLogConfiguration?.hashCode() ?: 0)
        result = 31 * result + (automaticBackupRetentionDays ?: 0)
        result = 31 * result + (copyTagsToBackups?.hashCode() ?: 0)
        result = 31 * result + (dailyAutomaticBackupStartTime?.hashCode() ?: 0)
        result = 31 * result + (deploymentType?.hashCode() ?: 0)
        result = 31 * result + (diskIopsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (preferredSubnetId?.hashCode() ?: 0)
        result = 31 * result + (selfManagedActiveDirectoryConfiguration?.hashCode() ?: 0)
        result = 31 * result + (throughputCapacity ?: 0)
        result = 31 * result + (weeklyMaintenanceStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFileSystemWindowsConfiguration

        if (activeDirectoryId != other.activeDirectoryId) return false
        if (aliases != other.aliases) return false
        if (auditLogConfiguration != other.auditLogConfiguration) return false
        if (automaticBackupRetentionDays != other.automaticBackupRetentionDays) return false
        if (copyTagsToBackups != other.copyTagsToBackups) return false
        if (dailyAutomaticBackupStartTime != other.dailyAutomaticBackupStartTime) return false
        if (deploymentType != other.deploymentType) return false
        if (diskIopsConfiguration != other.diskIopsConfiguration) return false
        if (preferredSubnetId != other.preferredSubnetId) return false
        if (selfManagedActiveDirectoryConfiguration != other.selfManagedActiveDirectoryConfiguration) return false
        if (throughputCapacity != other.throughputCapacity) return false
        if (weeklyMaintenanceStartTime != other.weeklyMaintenanceStartTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.CreateFileSystemWindowsConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID for an existing Amazon Web Services Managed Microsoft Active Directory (AD) instance that the file system should join when it's created.
         */
        public var activeDirectoryId: kotlin.String? = null
        /**
         * An array of one or more DNS alias names that you want to associate with the Amazon FSx file system. Aliases allow you to use existing DNS names to access the data in your Amazon FSx file system. You can associate up to 50 aliases with a file system at any time. You can associate additional DNS aliases after you create the file system using the AssociateFileSystemAliases operation. You can remove DNS aliases from the file system after it is created using the DisassociateFileSystemAliases operation. You only need to specify the alias name in the request payload.
         *
         * For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html) and [Walkthrough 5: Using DNS aliases to access your file system](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html), including additional steps you must take to be able to access your file system using a DNS alias.
         *
         * An alias name has to meet the following requirements:
         * + Formatted as a fully-qualified domain name (FQDN), `hostname.domain`, for example, `accounting.example.com`.
         * + Can contain alphanumeric characters, the underscore (_), and the hyphen (-).
         * + Cannot start or end with a hyphen.
         * + Can start with a numeric.
         *
         * For DNS alias names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them: as uppercase letters, lowercase letters, or the corresponding letters in escape codes.
         */
        public var aliases: List<String>? = null
        /**
         * The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system.
         */
        public var auditLogConfiguration: aws.sdk.kotlin.services.fsx.model.WindowsAuditLogCreateConfiguration? = null
        /**
         * The number of days to retain automatic backups. Setting this property to `0` disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is `30`.
         */
        public var automaticBackupRetentionDays: kotlin.Int? = null
        /**
         * A boolean flag indicating whether tags for the file system should be copied to backups. This value defaults to false. If it's set to true, all tags for the file system are copied to all automatic and user-initiated backups where the user doesn't specify tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
         */
        public var copyTagsToBackups: kotlin.Boolean? = null
        /**
         * The preferred time to take daily automatic backups, formatted HH:MM in the UTC time zone.
         */
        public var dailyAutomaticBackupStartTime: kotlin.String? = null
        /**
         * Specifies the file system deployment type, valid values are the following:
         * + `MULTI_AZ_1` - Deploys a high availability file system that is configured for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability. You can only deploy a Multi-AZ file system in Amazon Web Services Regions that have a minimum of three Availability Zones. Also supports HDD storage type
         * + `SINGLE_AZ_1` - (Default) Choose to deploy a file system that is configured for single AZ redundancy.
         * + `SINGLE_AZ_2` - The latest generation Single AZ file system. Specifies a file system that is configured for single AZ redundancy and supports HDD storage type.
         *
         * For more information, see [ Availability and Durability: Single-AZ and Multi-AZ File Systems](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html).
         */
        public var deploymentType: aws.sdk.kotlin.services.fsx.model.WindowsDeploymentType? = null
        /**
         * The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for Windows file system. By default, Amazon FSx automatically provisions 3 IOPS per GiB of storage capacity. You can provision additional IOPS per GiB of storage, up to the maximum limit associated with your chosen throughput capacity.
         */
        public var diskIopsConfiguration: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration? = null
        /**
         * Required when `DeploymentType` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located. For in-Amazon Web Services applications, we recommend that you launch your clients in the same Availability Zone (AZ) as your preferred file server to reduce cross-AZ data transfer costs and minimize latency.
         */
        public var preferredSubnetId: kotlin.String? = null
        /**
         * The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an FSx for ONTAP storage virtual machine (SVM) to a self-managed (including on-premises) Microsoft Active Directory (AD) directory. For more information, see [ Using Amazon FSx for Windows with your self-managed Microsoft Active Directory](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html) or [Managing FSx for ONTAP SVMs](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html).
         */
        public var selfManagedActiveDirectoryConfiguration: aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfiguration? = null
        /**
         * Sets the throughput capacity of an Amazon FSx file system, measured in megabytes per second (MB/s), in 2 to the *n*th increments, between 2^3 (8) and 2^11 (2048).
         */
        public var throughputCapacity: kotlin.Int? = null
        /**
         * The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.
         */
        public var weeklyMaintenanceStartTime: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.CreateFileSystemWindowsConfiguration) : this() {
            this.activeDirectoryId = x.activeDirectoryId
            this.aliases = x.aliases
            this.auditLogConfiguration = x.auditLogConfiguration
            this.automaticBackupRetentionDays = x.automaticBackupRetentionDays
            this.copyTagsToBackups = x.copyTagsToBackups
            this.dailyAutomaticBackupStartTime = x.dailyAutomaticBackupStartTime
            this.deploymentType = x.deploymentType
            this.diskIopsConfiguration = x.diskIopsConfiguration
            this.preferredSubnetId = x.preferredSubnetId
            this.selfManagedActiveDirectoryConfiguration = x.selfManagedActiveDirectoryConfiguration
            this.throughputCapacity = x.throughputCapacity
            this.weeklyMaintenanceStartTime = x.weeklyMaintenanceStartTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.CreateFileSystemWindowsConfiguration = CreateFileSystemWindowsConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.WindowsAuditLogCreateConfiguration] inside the given [block]
         */
        public fun auditLogConfiguration(block: aws.sdk.kotlin.services.fsx.model.WindowsAuditLogCreateConfiguration.Builder.() -> kotlin.Unit) {
            this.auditLogConfiguration = aws.sdk.kotlin.services.fsx.model.WindowsAuditLogCreateConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration] inside the given [block]
         */
        public fun diskIopsConfiguration(block: aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration.Builder.() -> kotlin.Unit) {
            this.diskIopsConfiguration = aws.sdk.kotlin.services.fsx.model.DiskIopsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfiguration] inside the given [block]
         */
        public fun selfManagedActiveDirectoryConfiguration(block: aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfiguration.Builder.() -> kotlin.Unit) {
            this.selfManagedActiveDirectoryConfiguration = aws.sdk.kotlin.services.fsx.model.SelfManagedActiveDirectoryConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
