// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateFileCacheRequest private constructor(builder: Builder) {
    /**
     * An idempotency token for resource creation, in a string of up to 63 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
     *
     * By using the idempotent operation, you can retry a `CreateFileCache` operation without the risk of creating an extra cache. This approach can be useful when an initial call fails in a way that makes it unclear whether a cache was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a cache, the client receives success as long as the parameters are the same.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
     */
    public val copyTagsToDataRepositoryAssociations: kotlin.Boolean? = builder.copyTagsToDataRepositoryAssociations
    /**
     * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol.
     *
     * The DRA configurations must meet the following requirements:
     * + All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time.
     * + An NFS DRA must link to an NFS file system that supports the NFSv3 protocol.
     *
     * DRA automatic import and automatic export is not supported.
     */
    public val dataRepositoryAssociations: List<FileCacheDataRepositoryAssociation>? = builder.dataRepositoryAssociations
    /**
     * The type of cache that you're creating, which must be `LUSTRE`.
     */
    public val fileCacheType: aws.sdk.kotlin.services.fsx.model.FileCacheType? = builder.fileCacheType
    /**
     * Sets the Lustre version for the cache that you're creating, which must be `2.12`.
     */
    public val fileCacheTypeVersion: kotlin.String? = builder.fileCacheTypeVersion
    /**
     * Specifies the ID of the Key Management Service (KMS) key to use for encrypting data on an Amazon File Cache. If a `KmsKeyId` isn't specified, the Amazon FSx-managed KMS key for your account is used. For more information, see [Encrypt](https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html) in the *Key Management Service API Reference*.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The configuration for the Amazon File Cache resource being created.
     */
    public val lustreConfiguration: aws.sdk.kotlin.services.fsx.model.CreateFileCacheLustreConfiguration? = builder.lustreConfiguration
    /**
     * A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access. This list isn't returned in later requests to describe the cache.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The storage capacity of the cache in gibibytes (GiB). Valid values are 1200 GiB, 2400 GiB, and increments of 2400 GiB.
     */
    public val storageCapacity: kotlin.Int? = builder.storageCapacity
    /**
     * A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID in a call to the `CreateFileCache` operation.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * A list of `Tag` values, with a maximum of 50 elements.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.CreateFileCacheRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFileCacheRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("copyTagsToDataRepositoryAssociations=$copyTagsToDataRepositoryAssociations,")
        append("dataRepositoryAssociations=$dataRepositoryAssociations,")
        append("fileCacheType=$fileCacheType,")
        append("fileCacheTypeVersion=$fileCacheTypeVersion,")
        append("kmsKeyId=$kmsKeyId,")
        append("lustreConfiguration=$lustreConfiguration,")
        append("securityGroupIds=$securityGroupIds,")
        append("storageCapacity=$storageCapacity,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (copyTagsToDataRepositoryAssociations?.hashCode() ?: 0)
        result = 31 * result + (dataRepositoryAssociations?.hashCode() ?: 0)
        result = 31 * result + (fileCacheType?.hashCode() ?: 0)
        result = 31 * result + (fileCacheTypeVersion?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (lustreConfiguration?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (storageCapacity ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFileCacheRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (copyTagsToDataRepositoryAssociations != other.copyTagsToDataRepositoryAssociations) return false
        if (dataRepositoryAssociations != other.dataRepositoryAssociations) return false
        if (fileCacheType != other.fileCacheType) return false
        if (fileCacheTypeVersion != other.fileCacheTypeVersion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (lustreConfiguration != other.lustreConfiguration) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (storageCapacity != other.storageCapacity) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.CreateFileCacheRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An idempotency token for resource creation, in a string of up to 63 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
         *
         * By using the idempotent operation, you can retry a `CreateFileCache` operation without the risk of creating an extra cache. This approach can be useful when an initial call fails in a way that makes it unclear whether a cache was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a cache, the client receives success as long as the parameters are the same.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
         */
        public var copyTagsToDataRepositoryAssociations: kotlin.Boolean? = null
        /**
         * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol.
         *
         * The DRA configurations must meet the following requirements:
         * + All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time.
         * + An NFS DRA must link to an NFS file system that supports the NFSv3 protocol.
         *
         * DRA automatic import and automatic export is not supported.
         */
        public var dataRepositoryAssociations: List<FileCacheDataRepositoryAssociation>? = null
        /**
         * The type of cache that you're creating, which must be `LUSTRE`.
         */
        public var fileCacheType: aws.sdk.kotlin.services.fsx.model.FileCacheType? = null
        /**
         * Sets the Lustre version for the cache that you're creating, which must be `2.12`.
         */
        public var fileCacheTypeVersion: kotlin.String? = null
        /**
         * Specifies the ID of the Key Management Service (KMS) key to use for encrypting data on an Amazon File Cache. If a `KmsKeyId` isn't specified, the Amazon FSx-managed KMS key for your account is used. For more information, see [Encrypt](https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html) in the *Key Management Service API Reference*.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The configuration for the Amazon File Cache resource being created.
         */
        public var lustreConfiguration: aws.sdk.kotlin.services.fsx.model.CreateFileCacheLustreConfiguration? = null
        /**
         * A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access. This list isn't returned in later requests to describe the cache.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The storage capacity of the cache in gibibytes (GiB). Valid values are 1200 GiB, 2400 GiB, and increments of 2400 GiB.
         */
        public var storageCapacity: kotlin.Int? = null
        /**
         * A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID in a call to the `CreateFileCache` operation.
         */
        public var subnetIds: List<String>? = null
        /**
         * A list of `Tag` values, with a maximum of 50 elements.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.CreateFileCacheRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.copyTagsToDataRepositoryAssociations = x.copyTagsToDataRepositoryAssociations
            this.dataRepositoryAssociations = x.dataRepositoryAssociations
            this.fileCacheType = x.fileCacheType
            this.fileCacheTypeVersion = x.fileCacheTypeVersion
            this.kmsKeyId = x.kmsKeyId
            this.lustreConfiguration = x.lustreConfiguration
            this.securityGroupIds = x.securityGroupIds
            this.storageCapacity = x.storageCapacity
            this.subnetIds = x.subnetIds
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.CreateFileCacheRequest = CreateFileCacheRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.CreateFileCacheLustreConfiguration] inside the given [block]
         */
        public fun lustreConfiguration(block: aws.sdk.kotlin.services.fsx.model.CreateFileCacheLustreConfiguration.Builder.() -> kotlin.Unit) {
            this.lustreConfiguration = aws.sdk.kotlin.services.fsx.model.CreateFileCacheLustreConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
