// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateDataRepositoryTaskRequest private constructor(builder: Builder) {
    /**
     * Specifies the amount of data to release, in GiB, by an Amazon File Cache `AUTO_RELEASE_DATA` task that automatically releases files from the cache.
     */
    public val capacityToRelease: kotlin.Long? = builder.capacityToRelease
    /**
     * (Optional) An idempotency token for resource creation, in a string of up to 63 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The globally unique ID of the file system, assigned by Amazon FSx.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * A list of paths for the data repository task to use when the task is processed. If a path that you provide isn't valid, the task fails. If you don't provide paths, the default behavior is to export all files to S3 (for export tasks), import all files from S3 (for import tasks), or release all exported files that meet the last accessed time criteria (for release tasks).
     * + For export tasks, the list contains paths on the FSx for Lustre file system from which the files are exported to the Amazon S3 bucket. The default path is the file system root directory. The paths you provide need to be relative to the mount point of the file system. If the mount point is `/mnt/fsx` and `/mnt/fsx/path1` is a directory or file on the file system you want to export, then the path to provide is `path1`.
     * + For import tasks, the list contains paths in the Amazon S3 bucket from which POSIX metadata changes are imported to the FSx for Lustre file system. The path can be an S3 bucket or prefix in the format `s3://myBucket/myPrefix` (where `myPrefix` is optional).
     * + For release tasks, the list contains directory or file paths on the FSx for Lustre file system from which to release exported files. If a directory is specified, files within the directory are released. If a file path is specified, only that file is released. To release all exported files in the file system, specify a forward slash (/) as the path.A file must also meet the last accessed time criteria specified in for the file to be released.
     */
    public val paths: List<String>? = builder.paths
    /**
     * The configuration that specifies the last accessed time criteria for files that will be released from an Amazon FSx for Lustre file system.
     */
    public val releaseConfiguration: aws.sdk.kotlin.services.fsx.model.ReleaseConfiguration? = builder.releaseConfiguration
    /**
     * Defines whether or not Amazon FSx provides a CompletionReport once the task has completed. A CompletionReport provides a detailed report on the files that Amazon FSx processed that meet the criteria specified by the `Scope` parameter. For more information, see [Working with Task Completion Reports](https://docs.aws.amazon.com/fsx/latest/LustreGuide/task-completion-report.html).
     */
    public val report: aws.sdk.kotlin.services.fsx.model.CompletionReport? = builder.report
    /**
     * A list of `Tag` values, with a maximum of 50 elements.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Specifies the type of data repository task to create.
     * + `EXPORT_TO_REPOSITORY` tasks export from your Amazon FSx for Lustre file system to a linked data repository.
     * + `IMPORT_METADATA_FROM_REPOSITORY` tasks import metadata changes from a linked S3 bucket to your Amazon FSx for Lustre file system.
     * + `RELEASE_DATA_FROM_FILESYSTEM` tasks release files in your Amazon FSx for Lustre file system that have been exported to a linked S3 bucket and that meet your specified release criteria.
     * + `AUTO_RELEASE_DATA` tasks automatically release files from an Amazon File Cache resource.
     */
    public val type: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDataRepositoryTaskRequest(")
        append("capacityToRelease=$capacityToRelease,")
        append("clientRequestToken=$clientRequestToken,")
        append("fileSystemId=$fileSystemId,")
        append("paths=$paths,")
        append("releaseConfiguration=$releaseConfiguration,")
        append("report=$report,")
        append("tags=$tags,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityToRelease?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (paths?.hashCode() ?: 0)
        result = 31 * result + (releaseConfiguration?.hashCode() ?: 0)
        result = 31 * result + (report?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDataRepositoryTaskRequest

        if (capacityToRelease != other.capacityToRelease) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (fileSystemId != other.fileSystemId) return false
        if (paths != other.paths) return false
        if (releaseConfiguration != other.releaseConfiguration) return false
        if (report != other.report) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryTaskRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the amount of data to release, in GiB, by an Amazon File Cache `AUTO_RELEASE_DATA` task that automatically releases files from the cache.
         */
        public var capacityToRelease: kotlin.Long? = null
        /**
         * (Optional) An idempotency token for resource creation, in a string of up to 63 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The globally unique ID of the file system, assigned by Amazon FSx.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * A list of paths for the data repository task to use when the task is processed. If a path that you provide isn't valid, the task fails. If you don't provide paths, the default behavior is to export all files to S3 (for export tasks), import all files from S3 (for import tasks), or release all exported files that meet the last accessed time criteria (for release tasks).
         * + For export tasks, the list contains paths on the FSx for Lustre file system from which the files are exported to the Amazon S3 bucket. The default path is the file system root directory. The paths you provide need to be relative to the mount point of the file system. If the mount point is `/mnt/fsx` and `/mnt/fsx/path1` is a directory or file on the file system you want to export, then the path to provide is `path1`.
         * + For import tasks, the list contains paths in the Amazon S3 bucket from which POSIX metadata changes are imported to the FSx for Lustre file system. The path can be an S3 bucket or prefix in the format `s3://myBucket/myPrefix` (where `myPrefix` is optional).
         * + For release tasks, the list contains directory or file paths on the FSx for Lustre file system from which to release exported files. If a directory is specified, files within the directory are released. If a file path is specified, only that file is released. To release all exported files in the file system, specify a forward slash (/) as the path.A file must also meet the last accessed time criteria specified in for the file to be released.
         */
        public var paths: List<String>? = null
        /**
         * The configuration that specifies the last accessed time criteria for files that will be released from an Amazon FSx for Lustre file system.
         */
        public var releaseConfiguration: aws.sdk.kotlin.services.fsx.model.ReleaseConfiguration? = null
        /**
         * Defines whether or not Amazon FSx provides a CompletionReport once the task has completed. A CompletionReport provides a detailed report on the files that Amazon FSx processed that meet the criteria specified by the `Scope` parameter. For more information, see [Working with Task Completion Reports](https://docs.aws.amazon.com/fsx/latest/LustreGuide/task-completion-report.html).
         */
        public var report: aws.sdk.kotlin.services.fsx.model.CompletionReport? = null
        /**
         * A list of `Tag` values, with a maximum of 50 elements.
         */
        public var tags: List<Tag>? = null
        /**
         * Specifies the type of data repository task to create.
         * + `EXPORT_TO_REPOSITORY` tasks export from your Amazon FSx for Lustre file system to a linked data repository.
         * + `IMPORT_METADATA_FROM_REPOSITORY` tasks import metadata changes from a linked S3 bucket to your Amazon FSx for Lustre file system.
         * + `RELEASE_DATA_FROM_FILESYSTEM` tasks release files in your Amazon FSx for Lustre file system that have been exported to a linked S3 bucket and that meet your specified release criteria.
         * + `AUTO_RELEASE_DATA` tasks automatically release files from an Amazon File Cache resource.
         */
        public var type: aws.sdk.kotlin.services.fsx.model.DataRepositoryTaskType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryTaskRequest) : this() {
            this.capacityToRelease = x.capacityToRelease
            this.clientRequestToken = x.clientRequestToken
            this.fileSystemId = x.fileSystemId
            this.paths = x.paths
            this.releaseConfiguration = x.releaseConfiguration
            this.report = x.report
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryTaskRequest = CreateDataRepositoryTaskRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.ReleaseConfiguration] inside the given [block]
         */
        public fun releaseConfiguration(block: aws.sdk.kotlin.services.fsx.model.ReleaseConfiguration.Builder.() -> kotlin.Unit) {
            this.releaseConfiguration = aws.sdk.kotlin.services.fsx.model.ReleaseConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.CompletionReport] inside the given [block]
         */
        public fun report(block: aws.sdk.kotlin.services.fsx.model.CompletionReport.Builder.() -> kotlin.Unit) {
            this.report = aws.sdk.kotlin.services.fsx.model.CompletionReport.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
