// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CopySnapshotAndUpdateVolumeRequest private constructor(builder: Builder) {
    /**
     * (Optional) An idempotency token for resource creation, in a string of up to 63 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Specifies the strategy to use when copying data from a snapshot to the volume.
     * + `FULL_COPY` - Copies all data from the snapshot to the volume.
     * + `INCREMENTAL_COPY` - Copies only the snapshot data that's changed since the previous replication.
     *
     * `CLONE` isn't a valid copy strategy option for the `CopySnapshotAndUpdateVolume` operation.
     */
    public val copyStrategy: aws.sdk.kotlin.services.fsx.model.OpenZfsCopyStrategy? = builder.copyStrategy
    /**
     * Confirms that you want to delete data on the destination volume that wasn’t there during the previous snapshot replication.
     *
     * Your replication will fail if you don’t include an option for a specific type of data and that data is on your destination. For example, if you don’t include `DELETE_INTERMEDIATE_SNAPSHOTS` and there are intermediate snapshots on the destination, you can’t copy the snapshot.
     * + `DELETE_INTERMEDIATE_SNAPSHOTS` - Deletes snapshots on the destination volume that aren’t on the source volume.
     * + `DELETE_CLONED_VOLUMES` - Deletes snapshot clones on the destination volume that aren't on the source volume.
     * + `DELETE_INTERMEDIATE_DATA` - Overwrites snapshots on the destination volume that don’t match the source snapshot that you’re copying.
     */
    public val options: List<UpdateOpenZfsVolumeOption>? = builder.options
    /**
     * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val sourceSnapshotArn: kotlin.String? = builder.sourceSnapshotArn
    /**
     * Specifies the ID of the volume that you are copying the snapshot to.
     */
    public val volumeId: kotlin.String? = builder.volumeId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.CopySnapshotAndUpdateVolumeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopySnapshotAndUpdateVolumeRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("copyStrategy=$copyStrategy,")
        append("options=$options,")
        append("sourceSnapshotArn=$sourceSnapshotArn,")
        append("volumeId=$volumeId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (copyStrategy?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (sourceSnapshotArn?.hashCode() ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopySnapshotAndUpdateVolumeRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (copyStrategy != other.copyStrategy) return false
        if (options != other.options) return false
        if (sourceSnapshotArn != other.sourceSnapshotArn) return false
        if (volumeId != other.volumeId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.CopySnapshotAndUpdateVolumeRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * (Optional) An idempotency token for resource creation, in a string of up to 63 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * Specifies the strategy to use when copying data from a snapshot to the volume.
         * + `FULL_COPY` - Copies all data from the snapshot to the volume.
         * + `INCREMENTAL_COPY` - Copies only the snapshot data that's changed since the previous replication.
         *
         * `CLONE` isn't a valid copy strategy option for the `CopySnapshotAndUpdateVolume` operation.
         */
        public var copyStrategy: aws.sdk.kotlin.services.fsx.model.OpenZfsCopyStrategy? = null
        /**
         * Confirms that you want to delete data on the destination volume that wasn’t there during the previous snapshot replication.
         *
         * Your replication will fail if you don’t include an option for a specific type of data and that data is on your destination. For example, if you don’t include `DELETE_INTERMEDIATE_SNAPSHOTS` and there are intermediate snapshots on the destination, you can’t copy the snapshot.
         * + `DELETE_INTERMEDIATE_SNAPSHOTS` - Deletes snapshots on the destination volume that aren’t on the source volume.
         * + `DELETE_CLONED_VOLUMES` - Deletes snapshot clones on the destination volume that aren't on the source volume.
         * + `DELETE_INTERMEDIATE_DATA` - Overwrites snapshots on the destination volume that don’t match the source snapshot that you’re copying.
         */
        public var options: List<UpdateOpenZfsVolumeOption>? = null
        /**
         * The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var sourceSnapshotArn: kotlin.String? = null
        /**
         * Specifies the ID of the volume that you are copying the snapshot to.
         */
        public var volumeId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.CopySnapshotAndUpdateVolumeRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.copyStrategy = x.copyStrategy
            this.options = x.options
            this.sourceSnapshotArn = x.sourceSnapshotArn
            this.volumeId = x.volumeId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.CopySnapshotAndUpdateVolumeRequest = CopySnapshotAndUpdateVolumeRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
