// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A backup of an Amazon FSx for Windows File Server, Amazon FSx for Lustre file system, Amazon FSx for NetApp ONTAP volume, or Amazon FSx for OpenZFS file system.
 */
public class Backup private constructor(builder: Builder) {
    /**
     * The ID of the backup.
     */
    public val backupId: kotlin.String? = builder.backupId
    /**
     * The time when a particular backup was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The configuration of the self-managed Microsoft Active Directory directory to which the Windows File Server instance is joined.
     */
    public val directoryInformation: aws.sdk.kotlin.services.fsx.model.ActiveDirectoryBackupAttributes? = builder.directoryInformation
    /**
     * Details explaining any failures that occurred when creating a backup.
     */
    public val failureDetails: aws.sdk.kotlin.services.fsx.model.BackupFailureDetails? = builder.failureDetails
    /**
     * The metadata of the file system associated with the backup. This metadata is persisted even if the file system is deleted.
     */
    public val fileSystem: aws.sdk.kotlin.services.fsx.model.FileSystem? = builder.fileSystem
    /**
     * The ID of the Key Management Service (KMS) key used to encrypt the backup of the Amazon FSx file system's data at rest.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The lifecycle status of the backup.
     * + `AVAILABLE` - The backup is fully available.
     * + `PENDING` - For user-initiated backups on Lustre file systems only; Amazon FSx hasn't started creating the backup.
     * + `CREATING` - Amazon FSx is creating the backup.
     * + `TRANSFERRING` - For user-initiated backups on Lustre file systems only; Amazon FSx is transferring the backup to Amazon S3.
     * + `COPYING` - Amazon FSx is copying the backup.
     * + `DELETED` - Amazon FSx deleted the backup and it's no longer available.
     * + `FAILED` - Amazon FSx couldn't finish the backup.
     */
    public val lifecycle: aws.sdk.kotlin.services.fsx.model.BackupLifecycle? = builder.lifecycle
    /**
     * An Amazon Web Services account ID. This ID is a 12-digit number that you use to construct Amazon Resource Names (ARNs) for resources.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * Displays the current percent of progress of an asynchronous task.
     */
    public val progressPercent: kotlin.Int? = builder.progressPercent
    /**
     * The Amazon Resource Name (ARN) for the backup resource.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * Specifies the resource type that's backed up.
     */
    public val resourceType: aws.sdk.kotlin.services.fsx.model.ResourceType? = builder.resourceType
    /**
     * The ID of the source backup. Specifies the backup that you are copying.
     */
    public val sourceBackupId: kotlin.String? = builder.sourceBackupId
    /**
     * The source Region of the backup. Specifies the Region from where this backup is copied.
     */
    public val sourceBackupRegion: kotlin.String? = builder.sourceBackupRegion
    /**
     * The tags associated with a particular file system.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The type of the file-system backup.
     */
    public val type: aws.sdk.kotlin.services.fsx.model.BackupType? = builder.type
    /**
     * Describes an Amazon FSx volume.
     */
    public val volume: aws.sdk.kotlin.services.fsx.model.Volume? = builder.volume

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.Backup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Backup(")
        append("backupId=$backupId,")
        append("creationTime=$creationTime,")
        append("directoryInformation=$directoryInformation,")
        append("failureDetails=$failureDetails,")
        append("fileSystem=$fileSystem,")
        append("kmsKeyId=$kmsKeyId,")
        append("lifecycle=$lifecycle,")
        append("ownerId=$ownerId,")
        append("progressPercent=$progressPercent,")
        append("resourceArn=$resourceArn,")
        append("resourceType=$resourceType,")
        append("sourceBackupId=$sourceBackupId,")
        append("sourceBackupRegion=$sourceBackupRegion,")
        append("tags=$tags,")
        append("type=$type,")
        append("volume=$volume")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupId?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (directoryInformation?.hashCode() ?: 0)
        result = 31 * result + (failureDetails?.hashCode() ?: 0)
        result = 31 * result + (fileSystem?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (progressPercent ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sourceBackupId?.hashCode() ?: 0)
        result = 31 * result + (sourceBackupRegion?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (volume?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Backup

        if (backupId != other.backupId) return false
        if (creationTime != other.creationTime) return false
        if (directoryInformation != other.directoryInformation) return false
        if (failureDetails != other.failureDetails) return false
        if (fileSystem != other.fileSystem) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (lifecycle != other.lifecycle) return false
        if (ownerId != other.ownerId) return false
        if (progressPercent != other.progressPercent) return false
        if (resourceArn != other.resourceArn) return false
        if (resourceType != other.resourceType) return false
        if (sourceBackupId != other.sourceBackupId) return false
        if (sourceBackupRegion != other.sourceBackupRegion) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (volume != other.volume) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.Backup = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the backup.
         */
        public var backupId: kotlin.String? = null
        /**
         * The time when a particular backup was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The configuration of the self-managed Microsoft Active Directory directory to which the Windows File Server instance is joined.
         */
        public var directoryInformation: aws.sdk.kotlin.services.fsx.model.ActiveDirectoryBackupAttributes? = null
        /**
         * Details explaining any failures that occurred when creating a backup.
         */
        public var failureDetails: aws.sdk.kotlin.services.fsx.model.BackupFailureDetails? = null
        /**
         * The metadata of the file system associated with the backup. This metadata is persisted even if the file system is deleted.
         */
        public var fileSystem: aws.sdk.kotlin.services.fsx.model.FileSystem? = null
        /**
         * The ID of the Key Management Service (KMS) key used to encrypt the backup of the Amazon FSx file system's data at rest.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The lifecycle status of the backup.
         * + `AVAILABLE` - The backup is fully available.
         * + `PENDING` - For user-initiated backups on Lustre file systems only; Amazon FSx hasn't started creating the backup.
         * + `CREATING` - Amazon FSx is creating the backup.
         * + `TRANSFERRING` - For user-initiated backups on Lustre file systems only; Amazon FSx is transferring the backup to Amazon S3.
         * + `COPYING` - Amazon FSx is copying the backup.
         * + `DELETED` - Amazon FSx deleted the backup and it's no longer available.
         * + `FAILED` - Amazon FSx couldn't finish the backup.
         */
        public var lifecycle: aws.sdk.kotlin.services.fsx.model.BackupLifecycle? = null
        /**
         * An Amazon Web Services account ID. This ID is a 12-digit number that you use to construct Amazon Resource Names (ARNs) for resources.
         */
        public var ownerId: kotlin.String? = null
        /**
         * Displays the current percent of progress of an asynchronous task.
         */
        public var progressPercent: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) for the backup resource.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * Specifies the resource type that's backed up.
         */
        public var resourceType: aws.sdk.kotlin.services.fsx.model.ResourceType? = null
        /**
         * The ID of the source backup. Specifies the backup that you are copying.
         */
        public var sourceBackupId: kotlin.String? = null
        /**
         * The source Region of the backup. Specifies the Region from where this backup is copied.
         */
        public var sourceBackupRegion: kotlin.String? = null
        /**
         * The tags associated with a particular file system.
         */
        public var tags: List<Tag>? = null
        /**
         * The type of the file-system backup.
         */
        public var type: aws.sdk.kotlin.services.fsx.model.BackupType? = null
        /**
         * Describes an Amazon FSx volume.
         */
        public var volume: aws.sdk.kotlin.services.fsx.model.Volume? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.Backup) : this() {
            this.backupId = x.backupId
            this.creationTime = x.creationTime
            this.directoryInformation = x.directoryInformation
            this.failureDetails = x.failureDetails
            this.fileSystem = x.fileSystem
            this.kmsKeyId = x.kmsKeyId
            this.lifecycle = x.lifecycle
            this.ownerId = x.ownerId
            this.progressPercent = x.progressPercent
            this.resourceArn = x.resourceArn
            this.resourceType = x.resourceType
            this.sourceBackupId = x.sourceBackupId
            this.sourceBackupRegion = x.sourceBackupRegion
            this.tags = x.tags
            this.type = x.type
            this.volume = x.volume
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.Backup = Backup(this)

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.ActiveDirectoryBackupAttributes] inside the given [block]
         */
        public fun directoryInformation(block: aws.sdk.kotlin.services.fsx.model.ActiveDirectoryBackupAttributes.Builder.() -> kotlin.Unit) {
            this.directoryInformation = aws.sdk.kotlin.services.fsx.model.ActiveDirectoryBackupAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.BackupFailureDetails] inside the given [block]
         */
        public fun failureDetails(block: aws.sdk.kotlin.services.fsx.model.BackupFailureDetails.Builder.() -> kotlin.Unit) {
            this.failureDetails = aws.sdk.kotlin.services.fsx.model.BackupFailureDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.FileSystem] inside the given [block]
         */
        public fun fileSystem(block: aws.sdk.kotlin.services.fsx.model.FileSystem.Builder.() -> kotlin.Unit) {
            this.fileSystem = aws.sdk.kotlin.services.fsx.model.FileSystem.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fsx.model.Volume] inside the given [block]
         */
        public fun volume(block: aws.sdk.kotlin.services.fsx.model.Volume.Builder.() -> kotlin.Unit) {
            this.volume = aws.sdk.kotlin.services.fsx.model.Volume.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
