// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the data repository association's automatic import policy. The AutoImportPolicy defines how Amazon FSx keeps your file metadata and directory listings up to date by importing changes to your Amazon FSx for Lustre file system as you modify objects in a linked S3 bucket.
 *
 * The `AutoImportPolicy` is only supported on Amazon FSx for Lustre file systems with a data repository association.
 */
public class AutoImportPolicy private constructor(builder: Builder) {
    /**
     * The `AutoImportPolicy` can have the following event values:
     * + `NEW` - Amazon FSx automatically imports metadata of files added to the linked S3 bucket that do not currently exist in the FSx file system.
     * + `CHANGED` - Amazon FSx automatically updates file metadata and invalidates existing file content on the file system as files change in the data repository.
     * + `DELETED` - Amazon FSx automatically deletes files on the file system as corresponding files are deleted in the data repository.
     *
     * You can define any combination of event types for your `AutoImportPolicy`.
     */
    public val events: List<EventType>? = builder.events

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.AutoImportPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoImportPolicy(")
        append("events=$events")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = events?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoImportPolicy

        if (events != other.events) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.AutoImportPolicy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The `AutoImportPolicy` can have the following event values:
         * + `NEW` - Amazon FSx automatically imports metadata of files added to the linked S3 bucket that do not currently exist in the FSx file system.
         * + `CHANGED` - Amazon FSx automatically updates file metadata and invalidates existing file content on the file system as files change in the data repository.
         * + `DELETED` - Amazon FSx automatically deletes files on the file system as corresponding files are deleted in the data repository.
         *
         * You can define any combination of event types for your `AutoImportPolicy`.
         */
        public var events: List<EventType>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.AutoImportPolicy) : this() {
            this.events = x.events
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.AutoImportPolicy = AutoImportPolicy(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
