// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The request object specifying one or more DNS alias names to associate with an Amazon FSx for Windows File Server file system.
 */
public class AssociateFileSystemAliasesRequest private constructor(builder: Builder) {
    /**
     * An array of one or more DNS alias names to associate with the file system. The alias name has to comply with the following formatting requirements:
     * + Formatted as a fully-qualified domain name (FQDN), *`hostname.domain`*, for example, `accounting.corp.example.com`.
     * + Can contain alphanumeric characters and the hyphen (-).
     * + Cannot start or end with a hyphen.
     * + Can start with a numeric.
     *
     * For DNS alias names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them: as uppercase letters, lowercase letters, or the corresponding letters in escape codes.
     */
    public val aliases: List<String>? = builder.aliases
    /**
     * (Optional) An idempotency token for resource creation, in a string of up to 63 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Specifies the file system with which you want to associate one or more DNS aliases.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.AssociateFileSystemAliasesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssociateFileSystemAliasesRequest(")
        append("aliases=$aliases,")
        append("clientRequestToken=$clientRequestToken,")
        append("fileSystemId=$fileSystemId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliases?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (fileSystemId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssociateFileSystemAliasesRequest

        if (aliases != other.aliases) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (fileSystemId != other.fileSystemId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.AssociateFileSystemAliasesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of one or more DNS alias names to associate with the file system. The alias name has to comply with the following formatting requirements:
         * + Formatted as a fully-qualified domain name (FQDN), *`hostname.domain`*, for example, `accounting.corp.example.com`.
         * + Can contain alphanumeric characters and the hyphen (-).
         * + Cannot start or end with a hyphen.
         * + Can start with a numeric.
         *
         * For DNS alias names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them: as uppercase letters, lowercase letters, or the corresponding letters in escape codes.
         */
        public var aliases: List<String>? = null
        /**
         * (Optional) An idempotency token for resource creation, in a string of up to 63 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * Specifies the file system with which you want to associate one or more DNS aliases.
         */
        public var fileSystemId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.AssociateFileSystemAliasesRequest) : this() {
            this.aliases = x.aliases
            this.clientRequestToken = x.clientRequestToken
            this.fileSystemId = x.fileSystemId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.AssociateFileSystemAliasesRequest = AssociateFileSystemAliasesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
