// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Used to specify configuration options for a volume’s storage aggregate or aggregates.
 */
public class AggregateConfiguration private constructor(builder: Builder) {
    /**
     * The list of aggregates that this volume resides on. Aggregates are storage pools which make up your primary storage tier. Each high-availability (HA) pair has one aggregate. The names of the aggregates map to the names of the aggregates in the ONTAP CLI and REST API. For FlexVols, there will always be a single entry.
     *
     * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
     * + The strings in the value of `Aggregates` are not are not formatted as `aggrX`, where X is a number between 1 and 6.
     * + The value of `Aggregates` contains aggregates that are not present.
     * + One or more of the aggregates supplied are too close to the volume limit to support adding more volumes.
     */
    public val aggregates: List<String>? = builder.aggregates
    /**
     * The total number of constituents this FlexGroup volume has. Not applicable for FlexVols.
     */
    public val totalConstituents: kotlin.Int? = builder.totalConstituents

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fsx.model.AggregateConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AggregateConfiguration(")
        append("aggregates=$aggregates,")
        append("totalConstituents=$totalConstituents")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregates?.hashCode() ?: 0
        result = 31 * result + (totalConstituents ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AggregateConfiguration

        if (aggregates != other.aggregates) return false
        if (totalConstituents != other.totalConstituents) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fsx.model.AggregateConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of aggregates that this volume resides on. Aggregates are storage pools which make up your primary storage tier. Each high-availability (HA) pair has one aggregate. The names of the aggregates map to the names of the aggregates in the ONTAP CLI and REST API. For FlexVols, there will always be a single entry.
         *
         * Amazon FSx responds with an HTTP status code 400 (Bad Request) for the following conditions:
         * + The strings in the value of `Aggregates` are not are not formatted as `aggrX`, where X is a number between 1 and 6.
         * + The value of `Aggregates` contains aggregates that are not present.
         * + One or more of the aggregates supplied are too close to the volume limit to support adding more volumes.
         */
        public var aggregates: List<String>? = null
        /**
         * The total number of constituents this FlexGroup volume has. Not applicable for FlexVols.
         */
        public var totalConstituents: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fsx.model.AggregateConfiguration) : this() {
            this.aggregates = x.aggregates
            this.totalConstituents = x.totalConstituents
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fsx.model.AggregateConfiguration = AggregateConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
