// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx.model

import kotlin.collections.List

/**
 * Describes the type of administrative action, as follows:
 * + `FILE_SYSTEM_UPDATE` - A file system update administrative action initiated from the Amazon FSx console, API (`UpdateFileSystem`), or CLI (`update-file-system`).
 * + `THROUGHPUT_OPTIMIZATION` - After the `FILE_SYSTEM_UPDATE` task to increase a file system's throughput capacity has been completed successfully, a `THROUGHPUT_OPTIMIZATION` task starts.You can track the storage-optimization progress using the `ProgressPercent` property. When `THROUGHPUT_OPTIMIZATION` has been completed successfully, the parent `FILE_SYSTEM_UPDATE` action status changes to `COMPLETED`. For more information, see [Managing throughput capacity](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html) in the *Amazon FSx for Windows File Server User Guide*.
 * + `STORAGE_OPTIMIZATION` - After the `FILE_SYSTEM_UPDATE` task to increase a file system's storage capacity has been completed successfully, a `STORAGE_OPTIMIZATION` task starts.
 *    + For Windows and ONTAP, storage optimization is the process of migrating the file system data to newer larger disks.
 *    + For Lustre, storage optimization consists of rebalancing the data across the existing and newly added file servers.
 * You can track the storage-optimization progress using the `ProgressPercent` property. When `STORAGE_OPTIMIZATION` has been completed successfully, the parent `FILE_SYSTEM_UPDATE` action status changes to `COMPLETED`. For more information, see [Managing storage capacity](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html) in the *Amazon FSx for Windows File Server User Guide*, [Managing storage capacity](https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html) in the *Amazon FSx for Lustre User Guide*, and [Managing storage capacity and provisioned IOPS](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-storage-capacity.html) in the *Amazon FSx for NetApp ONTAP User Guide*.
 * + `FILE_SYSTEM_ALIAS_ASSOCIATION` - A file system update to associate a new Domain Name System (DNS) alias with the file system. For more information, see [ AssociateFileSystemAliases](https://docs.aws.amazon.com/fsx/latest/APIReference/API_AssociateFileSystemAliases.html).
 * + `FILE_SYSTEM_ALIAS_DISASSOCIATION` - A file system update to disassociate a DNS alias from the file system. For more information, see [DisassociateFileSystemAliases](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DisassociateFileSystemAliases.html).
 * + `IOPS_OPTIMIZATION` - After the `FILE_SYSTEM_UPDATE` task to increase a file system's throughput capacity has been completed successfully, a `IOPS_OPTIMIZATION` task starts.You can track the storage-optimization progress using the `ProgressPercent` property. When `IOPS_OPTIMIZATION` has been completed successfully, the parent `FILE_SYSTEM_UPDATE` action status changes to `COMPLETED`. For more information, see [Managing provisioned SSD IOPS](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-provisioned-ssd-iops.html) in the Amazon FSx for Windows File Server User Guide.
 * + `STORAGE_TYPE_OPTIMIZATION` - After the `FILE_SYSTEM_UPDATE` task to increase a file system's throughput capacity has been completed successfully, a `STORAGE_TYPE_OPTIMIZATION` task starts.You can track the storage-optimization progress using the `ProgressPercent` property. When `STORAGE_TYPE_OPTIMIZATION` has been completed successfully, the parent `FILE_SYSTEM_UPDATE` action status changes to `COMPLETED`.
 * + `VOLUME_UPDATE` - A volume update to an Amazon FSx for OpenZFS volume initiated from the Amazon FSx console, API (`UpdateVolume`), or CLI (`update-volume`).
 * + `VOLUME_RESTORE` - An Amazon FSx for OpenZFS volume is returned to the state saved by the specified snapshot, initiated from an API (`RestoreVolumeFromSnapshot`) or CLI (`restore-volume-from-snapshot`).
 * + `SNAPSHOT_UPDATE` - A snapshot update to an Amazon FSx for OpenZFS volume initiated from the Amazon FSx console, API (`UpdateSnapshot`), or CLI (`update-snapshot`).
 * + `RELEASE_NFS_V3_LOCKS` - Tracks the release of Network File System (NFS) V3 locks on an Amazon FSx for OpenZFS file system.
 * + `VOLUME_INITIALIZE_WITH_SNAPSHOT` - A volume is being created from a snapshot on a different FSx for OpenZFS file system. You can initiate this from the Amazon FSx console, API (`CreateVolume`), or CLI (`create-volume`) when using the using the `FULL_COPY` strategy.
 * + `VOLUME_UPDATE_WITH_SNAPSHOT` - A volume is being updated from a snapshot on a different FSx for OpenZFS file system. You can initiate this from the Amazon FSx console, API (`CopySnapshotAndUpdateVolume`), or CLI (`copy-snapshot-and-update-volume`).
 */
public sealed class AdministrativeActionType {
    public abstract val value: kotlin.String

    public object FileSystemAliasAssociation : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "FILE_SYSTEM_ALIAS_ASSOCIATION"
        override fun toString(): kotlin.String = "FileSystemAliasAssociation"
    }

    public object FileSystemAliasDisassociation : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "FILE_SYSTEM_ALIAS_DISASSOCIATION"
        override fun toString(): kotlin.String = "FileSystemAliasDisassociation"
    }

    public object FileSystemUpdate : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "FILE_SYSTEM_UPDATE"
        override fun toString(): kotlin.String = "FileSystemUpdate"
    }

    public object IopsOptimization : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "IOPS_OPTIMIZATION"
        override fun toString(): kotlin.String = "IopsOptimization"
    }

    public object MisconfiguredStateRecovery : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "MISCONFIGURED_STATE_RECOVERY"
        override fun toString(): kotlin.String = "MisconfiguredStateRecovery"
    }

    public object ReleaseNfsV3Locks : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "RELEASE_NFS_V3_LOCKS"
        override fun toString(): kotlin.String = "ReleaseNfsV3Locks"
    }

    public object SnapshotUpdate : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "SNAPSHOT_UPDATE"
        override fun toString(): kotlin.String = "SnapshotUpdate"
    }

    public object StorageOptimization : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "STORAGE_OPTIMIZATION"
        override fun toString(): kotlin.String = "StorageOptimization"
    }

    public object StorageTypeOptimization : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "STORAGE_TYPE_OPTIMIZATION"
        override fun toString(): kotlin.String = "StorageTypeOptimization"
    }

    public object ThroughputOptimization : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "THROUGHPUT_OPTIMIZATION"
        override fun toString(): kotlin.String = "ThroughputOptimization"
    }

    public object VolumeInitializeWithSnapshot : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "VOLUME_INITIALIZE_WITH_SNAPSHOT"
        override fun toString(): kotlin.String = "VolumeInitializeWithSnapshot"
    }

    public object VolumeRestore : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "VOLUME_RESTORE"
        override fun toString(): kotlin.String = "VolumeRestore"
    }

    public object VolumeUpdate : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "VOLUME_UPDATE"
        override fun toString(): kotlin.String = "VolumeUpdate"
    }

    public object VolumeUpdateWithSnapshot : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override val value: kotlin.String = "VOLUME_UPDATE_WITH_SNAPSHOT"
        override fun toString(): kotlin.String = "VolumeUpdateWithSnapshot"
    }

    public data class SdkUnknown(override val value: kotlin.String) : aws.sdk.kotlin.services.fsx.model.AdministrativeActionType() {
        override fun toString(): kotlin.String = "SdkUnknown($value)"
    }

    public companion object {
        /**
         * Convert a raw value to one of the sealed variants or [SdkUnknown]
         */
        public fun fromValue(value: kotlin.String): aws.sdk.kotlin.services.fsx.model.AdministrativeActionType = when (value) {
            "FILE_SYSTEM_ALIAS_ASSOCIATION" -> FileSystemAliasAssociation
            "FILE_SYSTEM_ALIAS_DISASSOCIATION" -> FileSystemAliasDisassociation
            "FILE_SYSTEM_UPDATE" -> FileSystemUpdate
            "IOPS_OPTIMIZATION" -> IopsOptimization
            "MISCONFIGURED_STATE_RECOVERY" -> MisconfiguredStateRecovery
            "RELEASE_NFS_V3_LOCKS" -> ReleaseNfsV3Locks
            "SNAPSHOT_UPDATE" -> SnapshotUpdate
            "STORAGE_OPTIMIZATION" -> StorageOptimization
            "STORAGE_TYPE_OPTIMIZATION" -> StorageTypeOptimization
            "THROUGHPUT_OPTIMIZATION" -> ThroughputOptimization
            "VOLUME_INITIALIZE_WITH_SNAPSHOT" -> VolumeInitializeWithSnapshot
            "VOLUME_RESTORE" -> VolumeRestore
            "VOLUME_UPDATE" -> VolumeUpdate
            "VOLUME_UPDATE_WITH_SNAPSHOT" -> VolumeUpdateWithSnapshot
            else -> SdkUnknown(value)
        }

        /**
         * Get a list of all possible variants
         */
        public fun values(): kotlin.collections.List<aws.sdk.kotlin.services.fsx.model.AdministrativeActionType> = values

        private val values: kotlin.collections.List<aws.sdk.kotlin.services.fsx.model.AdministrativeActionType> = listOf(
            FileSystemAliasAssociation,
            FileSystemAliasDisassociation,
            FileSystemUpdate,
            IopsOptimization,
            MisconfiguredStateRecovery,
            ReleaseNfsV3Locks,
            SnapshotUpdate,
            StorageOptimization,
            StorageTypeOptimization,
            ThroughputOptimization,
            VolumeInitializeWithSnapshot,
            VolumeRestore,
            VolumeUpdate,
            VolumeUpdateWithSnapshot,
        )
    }
}
