// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.fsx.auth.DefaultFSxAuthSchemeProvider
import aws.sdk.kotlin.services.fsx.auth.FSxAuthSchemeProvider
import aws.sdk.kotlin.services.fsx.endpoints.DefaultFSxEndpointProvider
import aws.sdk.kotlin.services.fsx.endpoints.FSxEndpointParameters
import aws.sdk.kotlin.services.fsx.endpoints.FSxEndpointProvider
import aws.sdk.kotlin.services.fsx.model.AssociateFileSystemAliasesRequest
import aws.sdk.kotlin.services.fsx.model.AssociateFileSystemAliasesResponse
import aws.sdk.kotlin.services.fsx.model.CancelDataRepositoryTaskRequest
import aws.sdk.kotlin.services.fsx.model.CancelDataRepositoryTaskResponse
import aws.sdk.kotlin.services.fsx.model.CopyBackupRequest
import aws.sdk.kotlin.services.fsx.model.CopyBackupResponse
import aws.sdk.kotlin.services.fsx.model.CopySnapshotAndUpdateVolumeRequest
import aws.sdk.kotlin.services.fsx.model.CopySnapshotAndUpdateVolumeResponse
import aws.sdk.kotlin.services.fsx.model.CreateBackupRequest
import aws.sdk.kotlin.services.fsx.model.CreateBackupResponse
import aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryAssociationRequest
import aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryAssociationResponse
import aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryTaskRequest
import aws.sdk.kotlin.services.fsx.model.CreateDataRepositoryTaskResponse
import aws.sdk.kotlin.services.fsx.model.CreateFileCacheRequest
import aws.sdk.kotlin.services.fsx.model.CreateFileCacheResponse
import aws.sdk.kotlin.services.fsx.model.CreateFileSystemFromBackupRequest
import aws.sdk.kotlin.services.fsx.model.CreateFileSystemFromBackupResponse
import aws.sdk.kotlin.services.fsx.model.CreateFileSystemRequest
import aws.sdk.kotlin.services.fsx.model.CreateFileSystemResponse
import aws.sdk.kotlin.services.fsx.model.CreateSnapshotRequest
import aws.sdk.kotlin.services.fsx.model.CreateSnapshotResponse
import aws.sdk.kotlin.services.fsx.model.CreateStorageVirtualMachineRequest
import aws.sdk.kotlin.services.fsx.model.CreateStorageVirtualMachineResponse
import aws.sdk.kotlin.services.fsx.model.CreateVolumeFromBackupRequest
import aws.sdk.kotlin.services.fsx.model.CreateVolumeFromBackupResponse
import aws.sdk.kotlin.services.fsx.model.CreateVolumeRequest
import aws.sdk.kotlin.services.fsx.model.CreateVolumeResponse
import aws.sdk.kotlin.services.fsx.model.DeleteBackupRequest
import aws.sdk.kotlin.services.fsx.model.DeleteBackupResponse
import aws.sdk.kotlin.services.fsx.model.DeleteDataRepositoryAssociationRequest
import aws.sdk.kotlin.services.fsx.model.DeleteDataRepositoryAssociationResponse
import aws.sdk.kotlin.services.fsx.model.DeleteFileCacheRequest
import aws.sdk.kotlin.services.fsx.model.DeleteFileCacheResponse
import aws.sdk.kotlin.services.fsx.model.DeleteFileSystemRequest
import aws.sdk.kotlin.services.fsx.model.DeleteFileSystemResponse
import aws.sdk.kotlin.services.fsx.model.DeleteSnapshotRequest
import aws.sdk.kotlin.services.fsx.model.DeleteSnapshotResponse
import aws.sdk.kotlin.services.fsx.model.DeleteStorageVirtualMachineRequest
import aws.sdk.kotlin.services.fsx.model.DeleteStorageVirtualMachineResponse
import aws.sdk.kotlin.services.fsx.model.DeleteVolumeRequest
import aws.sdk.kotlin.services.fsx.model.DeleteVolumeResponse
import aws.sdk.kotlin.services.fsx.model.DescribeBackupsRequest
import aws.sdk.kotlin.services.fsx.model.DescribeBackupsResponse
import aws.sdk.kotlin.services.fsx.model.DescribeDataRepositoryAssociationsRequest
import aws.sdk.kotlin.services.fsx.model.DescribeDataRepositoryAssociationsResponse
import aws.sdk.kotlin.services.fsx.model.DescribeDataRepositoryTasksRequest
import aws.sdk.kotlin.services.fsx.model.DescribeDataRepositoryTasksResponse
import aws.sdk.kotlin.services.fsx.model.DescribeFileCachesRequest
import aws.sdk.kotlin.services.fsx.model.DescribeFileCachesResponse
import aws.sdk.kotlin.services.fsx.model.DescribeFileSystemAliasesRequest
import aws.sdk.kotlin.services.fsx.model.DescribeFileSystemAliasesResponse
import aws.sdk.kotlin.services.fsx.model.DescribeFileSystemsRequest
import aws.sdk.kotlin.services.fsx.model.DescribeFileSystemsResponse
import aws.sdk.kotlin.services.fsx.model.DescribeSharedVpcConfigurationRequest
import aws.sdk.kotlin.services.fsx.model.DescribeSharedVpcConfigurationResponse
import aws.sdk.kotlin.services.fsx.model.DescribeSnapshotsRequest
import aws.sdk.kotlin.services.fsx.model.DescribeSnapshotsResponse
import aws.sdk.kotlin.services.fsx.model.DescribeStorageVirtualMachinesRequest
import aws.sdk.kotlin.services.fsx.model.DescribeStorageVirtualMachinesResponse
import aws.sdk.kotlin.services.fsx.model.DescribeVolumesRequest
import aws.sdk.kotlin.services.fsx.model.DescribeVolumesResponse
import aws.sdk.kotlin.services.fsx.model.DisassociateFileSystemAliasesRequest
import aws.sdk.kotlin.services.fsx.model.DisassociateFileSystemAliasesResponse
import aws.sdk.kotlin.services.fsx.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.fsx.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.fsx.model.ReleaseFileSystemNfsV3LocksRequest
import aws.sdk.kotlin.services.fsx.model.ReleaseFileSystemNfsV3LocksResponse
import aws.sdk.kotlin.services.fsx.model.RestoreVolumeFromSnapshotRequest
import aws.sdk.kotlin.services.fsx.model.RestoreVolumeFromSnapshotResponse
import aws.sdk.kotlin.services.fsx.model.StartMisconfiguredStateRecoveryRequest
import aws.sdk.kotlin.services.fsx.model.StartMisconfiguredStateRecoveryResponse
import aws.sdk.kotlin.services.fsx.model.TagResourceRequest
import aws.sdk.kotlin.services.fsx.model.TagResourceResponse
import aws.sdk.kotlin.services.fsx.model.UntagResourceRequest
import aws.sdk.kotlin.services.fsx.model.UntagResourceResponse
import aws.sdk.kotlin.services.fsx.model.UpdateDataRepositoryAssociationRequest
import aws.sdk.kotlin.services.fsx.model.UpdateDataRepositoryAssociationResponse
import aws.sdk.kotlin.services.fsx.model.UpdateFileCacheRequest
import aws.sdk.kotlin.services.fsx.model.UpdateFileCacheResponse
import aws.sdk.kotlin.services.fsx.model.UpdateFileSystemRequest
import aws.sdk.kotlin.services.fsx.model.UpdateFileSystemResponse
import aws.sdk.kotlin.services.fsx.model.UpdateSharedVpcConfigurationRequest
import aws.sdk.kotlin.services.fsx.model.UpdateSharedVpcConfigurationResponse
import aws.sdk.kotlin.services.fsx.model.UpdateSnapshotRequest
import aws.sdk.kotlin.services.fsx.model.UpdateSnapshotResponse
import aws.sdk.kotlin.services.fsx.model.UpdateStorageVirtualMachineRequest
import aws.sdk.kotlin.services.fsx.model.UpdateStorageVirtualMachineResponse
import aws.sdk.kotlin.services.fsx.model.UpdateVolumeRequest
import aws.sdk.kotlin.services.fsx.model.UpdateVolumeResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "FSx"
public const val SdkVersion: String = "1.1.26"
public const val ServiceApiVersion: String = "2018-03-01"

/**
 * Amazon FSx is a fully managed service that makes it easy for storage and application administrators to launch and use shared file storage.
 */
public interface FSxClient : SdkClient {
    /**
     * FSxClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, FSxClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "FSx",
                "FSX",
                "fsx",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, FSxClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): FSxClient = DefaultFSxClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: FSxEndpointProvider = builder.endpointProvider ?: DefaultFSxEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: FSxAuthSchemeProvider = builder.authSchemeProvider ?: DefaultFSxAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "FSx"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: FSxEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: FSxAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Use this action to associate one or more Domain Name Server (DNS) aliases with an existing Amazon FSx for Windows File Server file system. A file system can have a maximum of 50 DNS aliases associated with it at any one time. If you try to associate a DNS alias that is already associated with the file system, FSx takes no action on that alias in the request. For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html) and [Walkthrough 5: Using DNS aliases to access your file system](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html), including additional steps you must take to be able to access your file system using a DNS alias.
     *
     * The system response shows the DNS aliases that Amazon FSx is attempting to associate with the file system. Use the API operation to monitor the status of the aliases Amazon FSx is associating with the file system.
     */
    public suspend fun associateFileSystemAliases(input: AssociateFileSystemAliasesRequest): AssociateFileSystemAliasesResponse

    /**
     * Cancels an existing Amazon FSx for Lustre data repository task if that task is in either the `PENDING` or `EXECUTING` state. When you cancel am export task, Amazon FSx does the following.
     * + Any files that FSx has already exported are not reverted.
     * + FSx continues to export any files that are in-flight when the cancel operation is received.
     * + FSx does not export any files that have not yet been exported.
     *
     * For a release task, Amazon FSx will stop releasing files upon cancellation. Any files that have already been released will remain in the released state.
     */
    public suspend fun cancelDataRepositoryTask(input: CancelDataRepositoryTaskRequest): CancelDataRepositoryTaskResponse

    /**
     * Copies an existing backup within the same Amazon Web Services account to another Amazon Web Services Region (cross-Region copy) or within the same Amazon Web Services Region (in-Region copy). You can have up to five backup copy requests in progress to a single destination Region per account.
     *
     * You can use cross-Region backup copies for cross-Region disaster recovery. You can periodically take backups and copy them to another Region so that in the event of a disaster in the primary Region, you can restore from backup and recover availability quickly in the other Region. You can make cross-Region copies only within your Amazon Web Services partition. A partition is a grouping of Regions. Amazon Web Services currently has three partitions: `aws` (Standard Regions), `aws-cn` (China Regions), and `aws-us-gov` (Amazon Web Services GovCloud &#91;US&#93; Regions).
     *
     * You can also use backup copies to clone your file dataset to another Region or within the same Region.
     *
     * You can use the `SourceRegion` parameter to specify the Amazon Web Services Region from which the backup will be copied. For example, if you make the call from the `us-west-1` Region and want to copy a backup from the `us-east-2` Region, you specify `us-east-2` in the `SourceRegion` parameter to make a cross-Region copy. If you don't specify a Region, the backup copy is created in the same Region where the request is sent from (in-Region copy).
     *
     * For more information about creating backup copies, see [ Copying backups](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#copy-backups) in the *Amazon FSx for Windows User Guide*, [Copying backups](https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html#copy-backups) in the *Amazon FSx for Lustre User Guide*, and [Copying backups](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/using-backups.html#copy-backups) in the *Amazon FSx for OpenZFS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.fsx.samples.CopyBackup.sample
     */
    public suspend fun copyBackup(input: CopyBackupRequest): CopyBackupResponse

    /**
     * Updates an existing volume by using a snapshot from another Amazon FSx for OpenZFS file system. For more information, see [on-demand data replication](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/on-demand-replication.html) in the Amazon FSx for OpenZFS User Guide.
     */
    public suspend fun copySnapshotAndUpdateVolume(input: CopySnapshotAndUpdateVolumeRequest): CopySnapshotAndUpdateVolumeResponse

    /**
     * Creates a backup of an existing Amazon FSx for Windows File Server file system, Amazon FSx for Lustre file system, Amazon FSx for NetApp ONTAP volume, or Amazon FSx for OpenZFS file system. We recommend creating regular backups so that you can restore a file system or volume from a backup if an issue arises with the original file system or volume.
     *
     * For Amazon FSx for Lustre file systems, you can create a backup only for file systems that have the following configuration:
     * + A Persistent deployment type
     * + Are *not* linked to a data repository
     *
     * For more information about backups, see the following:
     * + For Amazon FSx for Lustre, see [Working with FSx for Lustre backups](https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html).
     * + For Amazon FSx for Windows, see [Working with FSx for Windows backups](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html).
     * + For Amazon FSx for NetApp ONTAP, see [Working with FSx for NetApp ONTAP backups](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/using-backups.html).
     * + For Amazon FSx for OpenZFS, see [Working with FSx for OpenZFS backups](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/using-backups.html).
     *
     * If a backup with the specified client request token exists and the parameters match, this operation returns the description of the existing backup. If a backup with the specified client request token exists and the parameters don't match, this operation returns `IncompatibleParameterError`. If a backup with the specified client request token doesn't exist, `CreateBackup` does the following:
     * + Creates a new Amazon FSx backup with an assigned ID, and an initial lifecycle state of `CREATING`.
     * + Returns the description of the backup.
     *
     * By using the idempotent operation, you can retry a `CreateBackup` operation without the risk of creating an extra backup. This approach can be useful when an initial call fails in a way that makes it unclear whether a backup was created. If you use the same client request token and the initial call created a backup, the operation returns a successful result because all the parameters are the same.
     *
     * The `CreateBackup` operation returns while the backup's lifecycle state is still `CREATING`. You can check the backup creation status by calling the [DescribeBackups](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeBackups.html) operation, which returns the backup state along with other information.
     */
    public suspend fun createBackup(input: CreateBackupRequest = CreateBackupRequest { }): CreateBackupResponse

    /**
     * Creates an Amazon FSx for Lustre data repository association (DRA). A data repository association is a link between a directory on the file system and an Amazon S3 bucket or prefix. You can have a maximum of 8 data repository associations on a file system. Data repository associations are supported on all FSx for Lustre 2.12 and 2.15 file systems, excluding `scratch_1` deployment type.
     *
     * Each data repository association must have a unique Amazon FSx file system directory and a unique S3 bucket or prefix associated with it. You can configure a data repository association for automatic import only, for automatic export only, or for both. To learn more about linking a data repository to your file system, see [Linking your file system to an S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html).
     *
     * `CreateDataRepositoryAssociation` isn't supported on Amazon File Cache resources. To create a DRA on Amazon File Cache, use the `CreateFileCache` operation.
     */
    public suspend fun createDataRepositoryAssociation(input: CreateDataRepositoryAssociationRequest): CreateDataRepositoryAssociationResponse

    /**
     * Creates an Amazon FSx for Lustre data repository task. A `CreateDataRepositoryTask` operation will fail if a data repository is not linked to the FSx file system.
     *
     * You use import and export data repository tasks to perform bulk operations between your FSx for Lustre file system and its linked data repositories. An example of a data repository task is exporting any data and metadata changes, including POSIX metadata, to files, directories, and symbolic links (symlinks) from your FSx file system to a linked data repository.
     *
     * You use release data repository tasks to release data from your file system for files that are exported to S3. The metadata of released files remains on the file system so users or applications can still access released files by reading the files again, which will restore data from Amazon S3 to the FSx for Lustre file system.
     *
     * To learn more about data repository tasks, see [Data Repository Tasks](https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-repository-tasks.html). To learn more about linking a data repository to your file system, see [Linking your file system to an S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html).
     */
    public suspend fun createDataRepositoryTask(input: CreateDataRepositoryTaskRequest): CreateDataRepositoryTaskResponse

    /**
     * Creates a new Amazon File Cache resource.
     *
     * You can use this operation with a client request token in the request that Amazon File Cache uses to ensure idempotent creation. If a cache with the specified client request token exists and the parameters match, `CreateFileCache` returns the description of the existing cache. If a cache with the specified client request token exists and the parameters don't match, this call returns `IncompatibleParameterError`. If a file cache with the specified client request token doesn't exist, `CreateFileCache` does the following:
     * + Creates a new, empty Amazon File Cache resourcewith an assigned ID, and an initial lifecycle state of `CREATING`.
     * + Returns the description of the cache in JSON format.
     *
     * The `CreateFileCache` call returns while the cache's lifecycle state is still `CREATING`. You can check the cache creation status by calling the [DescribeFileCaches](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileCaches.html) operation, which returns the cache state along with other information.
     */
    public suspend fun createFileCache(input: CreateFileCacheRequest): CreateFileCacheResponse

    /**
     * Creates a new, empty Amazon FSx file system. You can create the following supported Amazon FSx file systems using the `CreateFileSystem` API operation:
     * + Amazon FSx for Lustre
     * + Amazon FSx for NetApp ONTAP
     * + Amazon FSx for OpenZFS
     * + Amazon FSx for Windows File Server
     *
     * This operation requires a client request token in the request that Amazon FSx uses to ensure idempotent creation. This means that calling the operation multiple times with the same client request token has no effect. By using the idempotent operation, you can retry a `CreateFileSystem` operation without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives success as long as the parameters are the same.
     *
     * If a file system with the specified client request token exists and the parameters match, `CreateFileSystem` returns the description of the existing file system. If a file system with the specified client request token exists and the parameters don't match, this call returns `IncompatibleParameterError`. If a file system with the specified client request token doesn't exist, `CreateFileSystem` does the following:
     * + Creates a new, empty Amazon FSx file system with an assigned ID, and an initial lifecycle state of `CREATING`.
     * + Returns the description of the file system in JSON format.
     *
     * The `CreateFileSystem` call returns while the file system's lifecycle state is still `CREATING`. You can check the file-system creation status by calling the [DescribeFileSystems](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html) operation, which returns the file system state along with other information.
     */
    public suspend fun createFileSystem(input: CreateFileSystemRequest): CreateFileSystemResponse

    /**
     * Creates a new Amazon FSx for Lustre, Amazon FSx for Windows File Server, or Amazon FSx for OpenZFS file system from an existing Amazon FSx backup.
     *
     * If a file system with the specified client request token exists and the parameters match, this operation returns the description of the file system. If a file system with the specified client request token exists but the parameters don't match, this call returns `IncompatibleParameterError`. If a file system with the specified client request token doesn't exist, this operation does the following:
     * + Creates a new Amazon FSx file system from backup with an assigned ID, and an initial lifecycle state of `CREATING`.
     * + Returns the description of the file system.
     *
     * Parameters like the Active Directory, default share name, automatic backup, and backup settings default to the parameters of the file system that was backed up, unless overridden. You can explicitly supply other settings.
     *
     * By using the idempotent operation, you can retry a `CreateFileSystemFromBackup` call without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives a success message as long as the parameters are the same.
     *
     * The `CreateFileSystemFromBackup` call returns while the file system's lifecycle state is still `CREATING`. You can check the file-system creation status by calling the [ DescribeFileSystems](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html) operation, which returns the file system state along with other information.
     */
    public suspend fun createFileSystemFromBackup(input: CreateFileSystemFromBackupRequest): CreateFileSystemFromBackupResponse

    /**
     * Creates a snapshot of an existing Amazon FSx for OpenZFS volume. With snapshots, you can easily undo file changes and compare file versions by restoring the volume to a previous version.
     *
     * If a snapshot with the specified client request token exists, and the parameters match, this operation returns the description of the existing snapshot. If a snapshot with the specified client request token exists, and the parameters don't match, this operation returns `IncompatibleParameterError`. If a snapshot with the specified client request token doesn't exist, `CreateSnapshot` does the following:
     * + Creates a new OpenZFS snapshot with an assigned ID, and an initial lifecycle state of `CREATING`.
     * + Returns the description of the snapshot.
     *
     * By using the idempotent operation, you can retry a `CreateSnapshot` operation without the risk of creating an extra snapshot. This approach can be useful when an initial call fails in a way that makes it unclear whether a snapshot was created. If you use the same client request token and the initial call created a snapshot, the operation returns a successful result because all the parameters are the same.
     *
     * The `CreateSnapshot` operation returns while the snapshot's lifecycle state is still `CREATING`. You can check the snapshot creation status by calling the [DescribeSnapshots](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeSnapshots.html) operation, which returns the snapshot state along with other information.
     */
    public suspend fun createSnapshot(input: CreateSnapshotRequest): CreateSnapshotResponse

    /**
     * Creates a storage virtual machine (SVM) for an Amazon FSx for ONTAP file system.
     */
    public suspend fun createStorageVirtualMachine(input: CreateStorageVirtualMachineRequest): CreateStorageVirtualMachineResponse

    /**
     * Creates an FSx for ONTAP or Amazon FSx for OpenZFS storage volume.
     */
    public suspend fun createVolume(input: CreateVolumeRequest): CreateVolumeResponse

    /**
     * Creates a new Amazon FSx for NetApp ONTAP volume from an existing Amazon FSx volume backup.
     */
    public suspend fun createVolumeFromBackup(input: CreateVolumeFromBackupRequest): CreateVolumeFromBackupResponse

    /**
     * Deletes an Amazon FSx backup. After deletion, the backup no longer exists, and its data is gone.
     *
     * The `DeleteBackup` call returns instantly. The backup won't show up in later `DescribeBackups` calls.
     *
     * The data in a deleted backup is also deleted and can't be recovered by any means.
     *
     * @sample aws.sdk.kotlin.services.fsx.samples.DeleteBackup.sample
     */
    public suspend fun deleteBackup(input: DeleteBackupRequest): DeleteBackupResponse

    /**
     * Deletes a data repository association on an Amazon FSx for Lustre file system. Deleting the data repository association unlinks the file system from the Amazon S3 bucket. When deleting a data repository association, you have the option of deleting the data in the file system that corresponds to the data repository association. Data repository associations are supported on all FSx for Lustre 2.12 and 2.15 file systems, excluding `scratch_1` deployment type.
     */
    public suspend fun deleteDataRepositoryAssociation(input: DeleteDataRepositoryAssociationRequest): DeleteDataRepositoryAssociationResponse

    /**
     * Deletes an Amazon File Cache resource. After deletion, the cache no longer exists, and its data is gone.
     *
     * The `DeleteFileCache` operation returns while the cache has the `DELETING` status. You can check the cache deletion status by calling the [DescribeFileCaches](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileCaches.html) operation, which returns a list of caches in your account. If you pass the cache ID for a deleted cache, the `DescribeFileCaches` operation returns a `FileCacheNotFound` error.
     *
     * The data in a deleted cache is also deleted and can't be recovered by any means.
     */
    public suspend fun deleteFileCache(input: DeleteFileCacheRequest): DeleteFileCacheResponse

    /**
     * Deletes a file system. After deletion, the file system no longer exists, and its data is gone. Any existing automatic backups and snapshots are also deleted.
     *
     * To delete an Amazon FSx for NetApp ONTAP file system, first delete all the volumes and storage virtual machines (SVMs) on the file system. Then provide a `FileSystemId` value to the `DeleFileSystem` operation.
     *
     * By default, when you delete an Amazon FSx for Windows File Server file system, a final backup is created upon deletion. This final backup isn't subject to the file system's retention policy, and must be manually deleted.
     *
     * To delete an Amazon FSx for Lustre file system, first [unmount](https://docs.aws.amazon.com/fsx/latest/LustreGuide/unmounting-fs.html) it from every connected Amazon EC2 instance, then provide a `FileSystemId` value to the `DeleFileSystem` operation. By default, Amazon FSx will not take a final backup when the `DeleteFileSystem` operation is invoked. On file systems not linked to an Amazon S3 bucket, set `SkipFinalBackup` to `false` to take a final backup of the file system you are deleting. Backups cannot be enabled on S3-linked file systems. To ensure all of your data is written back to S3 before deleting your file system, you can either monitor for the [AgeOfOldestQueuedMessage](https://docs.aws.amazon.com/fsx/latest/LustreGuide/monitoring-cloudwatch.html#auto-import-export-metrics) metric to be zero (if using automatic export) or you can run an [export data repository task](https://docs.aws.amazon.com/fsx/latest/LustreGuide/export-data-repo-task-dra.html). If you have automatic export enabled and want to use an export data repository task, you have to disable automatic export before executing the export data repository task.
     *
     * The `DeleteFileSystem` operation returns while the file system has the `DELETING` status. You can check the file system deletion status by calling the [DescribeFileSystems](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html) operation, which returns a list of file systems in your account. If you pass the file system ID for a deleted file system, the `DescribeFileSystems` operation returns a `FileSystemNotFound` error.
     *
     * If a data repository task is in a `PENDING` or `EXECUTING` state, deleting an Amazon FSx for Lustre file system will fail with an HTTP status code 400 (Bad Request).
     *
     * The data in a deleted file system is also deleted and can't be recovered by any means.
     *
     * @sample aws.sdk.kotlin.services.fsx.samples.DeleteFileSystem.sample
     */
    public suspend fun deleteFileSystem(input: DeleteFileSystemRequest): DeleteFileSystemResponse

    /**
     * Deletes an Amazon FSx for OpenZFS snapshot. After deletion, the snapshot no longer exists, and its data is gone. Deleting a snapshot doesn't affect snapshots stored in a file system backup.
     *
     * The `DeleteSnapshot` operation returns instantly. The snapshot appears with the lifecycle status of `DELETING` until the deletion is complete.
     */
    public suspend fun deleteSnapshot(input: DeleteSnapshotRequest): DeleteSnapshotResponse

    /**
     * Deletes an existing Amazon FSx for ONTAP storage virtual machine (SVM). Prior to deleting an SVM, you must delete all non-root volumes in the SVM, otherwise the operation will fail.
     */
    public suspend fun deleteStorageVirtualMachine(input: DeleteStorageVirtualMachineRequest): DeleteStorageVirtualMachineResponse

    /**
     * Deletes an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.
     */
    public suspend fun deleteVolume(input: DeleteVolumeRequest): DeleteVolumeResponse

    /**
     * Returns the description of a specific Amazon FSx backup, if a `BackupIds` value is provided for that backup. Otherwise, it returns all backups owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all backups, you can optionally specify the `MaxResults` parameter to limit the number of backups in a response. If more backups remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of the `NextToken` value from the last response.
     *
     * This operation is used in an iterative process to retrieve a list of your backups. `DescribeBackups` is called first without a `NextToken` value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken` value.
     *
     * When using this operation, keep the following in mind:
     * + The operation might return fewer than the `MaxResults` value of backup descriptions while still including a `NextToken` value.
     * + The order of the backups returned in the response of one `DescribeBackups` call and the order of the backups returned across the responses of a multi-call iteration is unspecified.
     */
    public suspend fun describeBackups(input: DescribeBackupsRequest = DescribeBackupsRequest { }): DescribeBackupsResponse

    /**
     * Returns the description of specific Amazon FSx for Lustre or Amazon File Cache data repository associations, if one or more `AssociationIds` values are provided in the request, or if filters are used in the request. Data repository associations are supported on Amazon File Cache resources and all FSx for Lustre 2.12 and 2,15 file systems, excluding `scratch_1` deployment type.
     *
     * You can use filters to narrow the response to include just data repository associations for specific file systems (use the `file-system-id` filter with the ID of the file system) or caches (use the `file-cache-id` filter with the ID of the cache), or data repository associations for a specific repository type (use the `data-repository-type` filter with a value of `S3` or `NFS`). If you don't use filters, the response returns all data repository associations owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all data repository associations, you can paginate the response by using the optional `MaxResults` parameter to limit the number of data repository associations returned in a response. If more data repository associations remain, a `NextToken` value is returned in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     */
    public suspend fun describeDataRepositoryAssociations(input: DescribeDataRepositoryAssociationsRequest = DescribeDataRepositoryAssociationsRequest { }): DescribeDataRepositoryAssociationsResponse

    /**
     * Returns the description of specific Amazon FSx for Lustre or Amazon File Cache data repository tasks, if one or more `TaskIds` values are provided in the request, or if filters are used in the request. You can use filters to narrow the response to include just tasks for specific file systems or caches, or tasks in a specific lifecycle state. Otherwise, it returns all data repository tasks owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all tasks, you can paginate the response by using the optional `MaxResults` parameter to limit the number of tasks returned in a response. If more tasks remain, a `NextToken` value is returned in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     */
    public suspend fun describeDataRepositoryTasks(input: DescribeDataRepositoryTasksRequest = DescribeDataRepositoryTasksRequest { }): DescribeDataRepositoryTasksResponse

    /**
     * Returns the description of a specific Amazon File Cache resource, if a `FileCacheIds` value is provided for that cache. Otherwise, it returns descriptions of all caches owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all cache descriptions, you can optionally specify the `MaxResults` parameter to limit the number of descriptions in a response. If more cache descriptions remain, the operation returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     *
     * This operation is used in an iterative process to retrieve a list of your cache descriptions. `DescribeFileCaches` is called first without a `NextToken`value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken`.
     *
     * When using this operation, keep the following in mind:
     * + The implementation might return fewer than `MaxResults` cache descriptions while still including a `NextToken` value.
     * + The order of caches returned in the response of one `DescribeFileCaches` call and the order of caches returned across the responses of a multicall iteration is unspecified.
     */
    public suspend fun describeFileCaches(input: DescribeFileCachesRequest = DescribeFileCachesRequest { }): DescribeFileCachesResponse

    /**
     * Returns the DNS aliases that are associated with the specified Amazon FSx for Windows File Server file system. A history of all DNS aliases that have been associated with and disassociated from the file system is available in the list of AdministrativeAction provided in the DescribeFileSystems operation response.
     */
    public suspend fun describeFileSystemAliases(input: DescribeFileSystemAliasesRequest): DescribeFileSystemAliasesResponse

    /**
     * Returns the description of specific Amazon FSx file systems, if a `FileSystemIds` value is provided for that file system. Otherwise, it returns descriptions of all file systems owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all file system descriptions, you can optionally specify the `MaxResults` parameter to limit the number of descriptions in a response. If more file system descriptions remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     *
     * This operation is used in an iterative process to retrieve a list of your file system descriptions. `DescribeFileSystems` is called first without a `NextToken`value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken`.
     *
     * When using this operation, keep the following in mind:
     * + The implementation might return fewer than `MaxResults` file system descriptions while still including a `NextToken` value.
     * + The order of file systems returned in the response of one `DescribeFileSystems` call and the order of file systems returned across the responses of a multicall iteration is unspecified.
     */
    public suspend fun describeFileSystems(input: DescribeFileSystemsRequest = DescribeFileSystemsRequest { }): DescribeFileSystemsResponse

    /**
     * Indicates whether participant accounts in your organization can create Amazon FSx for NetApp ONTAP Multi-AZ file systems in subnets that are shared by a virtual private cloud (VPC) owner. For more information, see [Creating FSx for ONTAP file systems in shared subnets](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/creating-file-systems.html#fsxn-vpc-shared-subnets).
     */
    public suspend fun describeSharedVpcConfiguration(input: DescribeSharedVpcConfigurationRequest = DescribeSharedVpcConfigurationRequest { }): DescribeSharedVpcConfigurationResponse

    /**
     * Returns the description of specific Amazon FSx for OpenZFS snapshots, if a `SnapshotIds` value is provided. Otherwise, this operation returns all snapshots owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all snapshots, you can optionally specify the `MaxResults` parameter to limit the number of snapshots in a response. If more backups remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     *
     * Use this operation in an iterative process to retrieve a list of your snapshots. `DescribeSnapshots` is called first without a `NextToken` value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken` value.
     *
     * When using this operation, keep the following in mind:
     * + The operation might return fewer than the `MaxResults` value of snapshot descriptions while still including a `NextToken` value.
     * + The order of snapshots returned in the response of one `DescribeSnapshots` call and the order of backups returned across the responses of a multi-call iteration is unspecified.
     */
    public suspend fun describeSnapshots(input: DescribeSnapshotsRequest = DescribeSnapshotsRequest { }): DescribeSnapshotsResponse

    /**
     * Describes one or more Amazon FSx for NetApp ONTAP storage virtual machines (SVMs).
     */
    public suspend fun describeStorageVirtualMachines(input: DescribeStorageVirtualMachinesRequest = DescribeStorageVirtualMachinesRequest { }): DescribeStorageVirtualMachinesResponse

    /**
     * Describes one or more Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volumes.
     */
    public suspend fun describeVolumes(input: DescribeVolumesRequest = DescribeVolumesRequest { }): DescribeVolumesResponse

    /**
     * Use this action to disassociate, or remove, one or more Domain Name Service (DNS) aliases from an Amazon FSx for Windows File Server file system. If you attempt to disassociate a DNS alias that is not associated with the file system, Amazon FSx responds with an HTTP status code 400 (Bad Request). For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html).
     *
     * The system generated response showing the DNS aliases that Amazon FSx is attempting to disassociate from the file system. Use the API operation to monitor the status of the aliases Amazon FSx is disassociating with the file system.
     */
    public suspend fun disassociateFileSystemAliases(input: DisassociateFileSystemAliasesRequest): DisassociateFileSystemAliasesResponse

    /**
     * Lists tags for Amazon FSx resources.
     *
     * When retrieving all tags, you can optionally specify the `MaxResults` parameter to limit the number of tags in a response. If more tags remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     *
     * This action is used in an iterative process to retrieve a list of your tags. `ListTagsForResource` is called first without a `NextToken`value. Then the action continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken`.
     *
     * When using this action, keep the following in mind:
     * + The implementation might return fewer than `MaxResults` file system descriptions while still including a `NextToken` value.
     * + The order of tags returned in the response of one `ListTagsForResource` call and the order of tags returned across the responses of a multi-call iteration is unspecified.
     *
     * @sample aws.sdk.kotlin.services.fsx.samples.ListTagsForResource.sample
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Releases the file system lock from an Amazon FSx for OpenZFS file system.
     */
    public suspend fun releaseFileSystemNfsV3Locks(input: ReleaseFileSystemNfsV3LocksRequest): ReleaseFileSystemNfsV3LocksResponse

    /**
     * Returns an Amazon FSx for OpenZFS volume to the state saved by the specified snapshot.
     */
    public suspend fun restoreVolumeFromSnapshot(input: RestoreVolumeFromSnapshotRequest): RestoreVolumeFromSnapshotResponse

    /**
     * After performing steps to repair the Active Directory configuration of an FSx for Windows File Server file system, use this action to initiate the process of Amazon FSx attempting to reconnect to the file system.
     */
    public suspend fun startMisconfiguredStateRecovery(input: StartMisconfiguredStateRecoveryRequest): StartMisconfiguredStateRecoveryResponse

    /**
     * Tags an Amazon FSx resource.
     *
     * @sample aws.sdk.kotlin.services.fsx.samples.TagResource.sample
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * This action removes a tag from an Amazon FSx resource.
     *
     * @sample aws.sdk.kotlin.services.fsx.samples.UntagResource.sample
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the configuration of an existing data repository association on an Amazon FSx for Lustre file system. Data repository associations are supported on all FSx for Lustre 2.12 and 2.15 file systems, excluding `scratch_1` deployment type.
     */
    public suspend fun updateDataRepositoryAssociation(input: UpdateDataRepositoryAssociationRequest): UpdateDataRepositoryAssociationResponse

    /**
     * Updates the configuration of an existing Amazon File Cache resource. You can update multiple properties in a single request.
     */
    public suspend fun updateFileCache(input: UpdateFileCacheRequest): UpdateFileCacheResponse

    /**
     * Use this operation to update the configuration of an existing Amazon FSx file system. You can update multiple properties in a single request.
     *
     * For FSx for Windows File Server file systems, you can update the following properties:
     * + `AuditLogConfiguration`
     * + `AutomaticBackupRetentionDays`
     * + `DailyAutomaticBackupStartTime`
     * + `SelfManagedActiveDirectoryConfiguration`
     * + `StorageCapacity`
     * + `StorageType`
     * + `ThroughputCapacity`
     * + `DiskIopsConfiguration`
     * + `WeeklyMaintenanceStartTime`
     *
     * For FSx for Lustre file systems, you can update the following properties:
     * + `AutoImportPolicy`
     * + `AutomaticBackupRetentionDays`
     * + `DailyAutomaticBackupStartTime`
     * + `DataCompressionType`
     * + `LogConfiguration`
     * + `LustreRootSquashConfiguration`
     * + `PerUnitStorageThroughput`
     * + `StorageCapacity`
     * + `WeeklyMaintenanceStartTime`
     *
     * For FSx for ONTAP file systems, you can update the following properties:
     * + `AddRouteTableIds`
     * + `AutomaticBackupRetentionDays`
     * + `DailyAutomaticBackupStartTime`
     * + `DiskIopsConfiguration`
     * + `FsxAdminPassword`
     * + `HAPairs`
     * + `RemoveRouteTableIds`
     * + `StorageCapacity`
     * + `ThroughputCapacity`
     * + `ThroughputCapacityPerHAPair`
     * + `WeeklyMaintenanceStartTime`
     *
     * For FSx for OpenZFS file systems, you can update the following properties:
     * + `AddRouteTableIds`
     * + `AutomaticBackupRetentionDays`
     * + `CopyTagsToBackups`
     * + `CopyTagsToVolumes`
     * + `DailyAutomaticBackupStartTime`
     * + `DiskIopsConfiguration`
     * + `RemoveRouteTableIds`
     * + `StorageCapacity`
     * + `ThroughputCapacity`
     * + `WeeklyMaintenanceStartTime`
     */
    public suspend fun updateFileSystem(input: UpdateFileSystemRequest): UpdateFileSystemResponse

    /**
     * Configures whether participant accounts in your organization can create Amazon FSx for NetApp ONTAP Multi-AZ file systems in subnets that are shared by a virtual private cloud (VPC) owner. For more information, see the [Amazon FSx for NetApp ONTAP User Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/maz-shared-vpc.html).
     *
     * We strongly recommend that participant-created Multi-AZ file systems in the shared VPC are deleted before you disable this feature. Once the feature is disabled, these file systems will enter a `MISCONFIGURED` state and behave like Single-AZ file systems. For more information, see [Important considerations before disabling shared VPC support for Multi-AZ file systems](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/maz-shared-vpc.html#disabling-maz-vpc-sharing).
     */
    public suspend fun updateSharedVpcConfiguration(input: UpdateSharedVpcConfigurationRequest = UpdateSharedVpcConfigurationRequest { }): UpdateSharedVpcConfigurationResponse

    /**
     * Updates the name of an Amazon FSx for OpenZFS snapshot.
     */
    public suspend fun updateSnapshot(input: UpdateSnapshotRequest): UpdateSnapshotResponse

    /**
     * Updates an FSx for ONTAP storage virtual machine (SVM).
     */
    public suspend fun updateStorageVirtualMachine(input: UpdateStorageVirtualMachineRequest): UpdateStorageVirtualMachineResponse

    /**
     * Updates the configuration of an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.
     */
    public suspend fun updateVolume(input: UpdateVolumeRequest): UpdateVolumeResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun FSxClient.withConfig(block: FSxClient.Config.Builder.() -> Unit): FSxClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultFSxClient(newConfig)
}

/**
 * Use this action to associate one or more Domain Name Server (DNS) aliases with an existing Amazon FSx for Windows File Server file system. A file system can have a maximum of 50 DNS aliases associated with it at any one time. If you try to associate a DNS alias that is already associated with the file system, FSx takes no action on that alias in the request. For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html) and [Walkthrough 5: Using DNS aliases to access your file system](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html), including additional steps you must take to be able to access your file system using a DNS alias.
 *
 * The system response shows the DNS aliases that Amazon FSx is attempting to associate with the file system. Use the API operation to monitor the status of the aliases Amazon FSx is associating with the file system.
 */
public suspend inline fun FSxClient.associateFileSystemAliases(crossinline block: AssociateFileSystemAliasesRequest.Builder.() -> Unit): AssociateFileSystemAliasesResponse = associateFileSystemAliases(AssociateFileSystemAliasesRequest.Builder().apply(block).build())

/**
 * Cancels an existing Amazon FSx for Lustre data repository task if that task is in either the `PENDING` or `EXECUTING` state. When you cancel am export task, Amazon FSx does the following.
 * + Any files that FSx has already exported are not reverted.
 * + FSx continues to export any files that are in-flight when the cancel operation is received.
 * + FSx does not export any files that have not yet been exported.
 *
 * For a release task, Amazon FSx will stop releasing files upon cancellation. Any files that have already been released will remain in the released state.
 */
public suspend inline fun FSxClient.cancelDataRepositoryTask(crossinline block: CancelDataRepositoryTaskRequest.Builder.() -> Unit): CancelDataRepositoryTaskResponse = cancelDataRepositoryTask(CancelDataRepositoryTaskRequest.Builder().apply(block).build())

/**
 * Copies an existing backup within the same Amazon Web Services account to another Amazon Web Services Region (cross-Region copy) or within the same Amazon Web Services Region (in-Region copy). You can have up to five backup copy requests in progress to a single destination Region per account.
 *
 * You can use cross-Region backup copies for cross-Region disaster recovery. You can periodically take backups and copy them to another Region so that in the event of a disaster in the primary Region, you can restore from backup and recover availability quickly in the other Region. You can make cross-Region copies only within your Amazon Web Services partition. A partition is a grouping of Regions. Amazon Web Services currently has three partitions: `aws` (Standard Regions), `aws-cn` (China Regions), and `aws-us-gov` (Amazon Web Services GovCloud &#91;US&#93; Regions).
 *
 * You can also use backup copies to clone your file dataset to another Region or within the same Region.
 *
 * You can use the `SourceRegion` parameter to specify the Amazon Web Services Region from which the backup will be copied. For example, if you make the call from the `us-west-1` Region and want to copy a backup from the `us-east-2` Region, you specify `us-east-2` in the `SourceRegion` parameter to make a cross-Region copy. If you don't specify a Region, the backup copy is created in the same Region where the request is sent from (in-Region copy).
 *
 * For more information about creating backup copies, see [ Copying backups](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#copy-backups) in the *Amazon FSx for Windows User Guide*, [Copying backups](https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html#copy-backups) in the *Amazon FSx for Lustre User Guide*, and [Copying backups](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/using-backups.html#copy-backups) in the *Amazon FSx for OpenZFS User Guide*.
 *
 * @sample aws.sdk.kotlin.services.fsx.samples.CopyBackup.sample
 */
public suspend inline fun FSxClient.copyBackup(crossinline block: CopyBackupRequest.Builder.() -> Unit): CopyBackupResponse = copyBackup(CopyBackupRequest.Builder().apply(block).build())

/**
 * Updates an existing volume by using a snapshot from another Amazon FSx for OpenZFS file system. For more information, see [on-demand data replication](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/on-demand-replication.html) in the Amazon FSx for OpenZFS User Guide.
 */
public suspend inline fun FSxClient.copySnapshotAndUpdateVolume(crossinline block: CopySnapshotAndUpdateVolumeRequest.Builder.() -> Unit): CopySnapshotAndUpdateVolumeResponse = copySnapshotAndUpdateVolume(CopySnapshotAndUpdateVolumeRequest.Builder().apply(block).build())

/**
 * Creates a backup of an existing Amazon FSx for Windows File Server file system, Amazon FSx for Lustre file system, Amazon FSx for NetApp ONTAP volume, or Amazon FSx for OpenZFS file system. We recommend creating regular backups so that you can restore a file system or volume from a backup if an issue arises with the original file system or volume.
 *
 * For Amazon FSx for Lustre file systems, you can create a backup only for file systems that have the following configuration:
 * + A Persistent deployment type
 * + Are *not* linked to a data repository
 *
 * For more information about backups, see the following:
 * + For Amazon FSx for Lustre, see [Working with FSx for Lustre backups](https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html).
 * + For Amazon FSx for Windows, see [Working with FSx for Windows backups](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html).
 * + For Amazon FSx for NetApp ONTAP, see [Working with FSx for NetApp ONTAP backups](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/using-backups.html).
 * + For Amazon FSx for OpenZFS, see [Working with FSx for OpenZFS backups](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/using-backups.html).
 *
 * If a backup with the specified client request token exists and the parameters match, this operation returns the description of the existing backup. If a backup with the specified client request token exists and the parameters don't match, this operation returns `IncompatibleParameterError`. If a backup with the specified client request token doesn't exist, `CreateBackup` does the following:
 * + Creates a new Amazon FSx backup with an assigned ID, and an initial lifecycle state of `CREATING`.
 * + Returns the description of the backup.
 *
 * By using the idempotent operation, you can retry a `CreateBackup` operation without the risk of creating an extra backup. This approach can be useful when an initial call fails in a way that makes it unclear whether a backup was created. If you use the same client request token and the initial call created a backup, the operation returns a successful result because all the parameters are the same.
 *
 * The `CreateBackup` operation returns while the backup's lifecycle state is still `CREATING`. You can check the backup creation status by calling the [DescribeBackups](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeBackups.html) operation, which returns the backup state along with other information.
 */
public suspend inline fun FSxClient.createBackup(crossinline block: CreateBackupRequest.Builder.() -> Unit): CreateBackupResponse = createBackup(CreateBackupRequest.Builder().apply(block).build())

/**
 * Creates an Amazon FSx for Lustre data repository association (DRA). A data repository association is a link between a directory on the file system and an Amazon S3 bucket or prefix. You can have a maximum of 8 data repository associations on a file system. Data repository associations are supported on all FSx for Lustre 2.12 and 2.15 file systems, excluding `scratch_1` deployment type.
 *
 * Each data repository association must have a unique Amazon FSx file system directory and a unique S3 bucket or prefix associated with it. You can configure a data repository association for automatic import only, for automatic export only, or for both. To learn more about linking a data repository to your file system, see [Linking your file system to an S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html).
 *
 * `CreateDataRepositoryAssociation` isn't supported on Amazon File Cache resources. To create a DRA on Amazon File Cache, use the `CreateFileCache` operation.
 */
public suspend inline fun FSxClient.createDataRepositoryAssociation(crossinline block: CreateDataRepositoryAssociationRequest.Builder.() -> Unit): CreateDataRepositoryAssociationResponse = createDataRepositoryAssociation(CreateDataRepositoryAssociationRequest.Builder().apply(block).build())

/**
 * Creates an Amazon FSx for Lustre data repository task. A `CreateDataRepositoryTask` operation will fail if a data repository is not linked to the FSx file system.
 *
 * You use import and export data repository tasks to perform bulk operations between your FSx for Lustre file system and its linked data repositories. An example of a data repository task is exporting any data and metadata changes, including POSIX metadata, to files, directories, and symbolic links (symlinks) from your FSx file system to a linked data repository.
 *
 * You use release data repository tasks to release data from your file system for files that are exported to S3. The metadata of released files remains on the file system so users or applications can still access released files by reading the files again, which will restore data from Amazon S3 to the FSx for Lustre file system.
 *
 * To learn more about data repository tasks, see [Data Repository Tasks](https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-repository-tasks.html). To learn more about linking a data repository to your file system, see [Linking your file system to an S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html).
 */
public suspend inline fun FSxClient.createDataRepositoryTask(crossinline block: CreateDataRepositoryTaskRequest.Builder.() -> Unit): CreateDataRepositoryTaskResponse = createDataRepositoryTask(CreateDataRepositoryTaskRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon File Cache resource.
 *
 * You can use this operation with a client request token in the request that Amazon File Cache uses to ensure idempotent creation. If a cache with the specified client request token exists and the parameters match, `CreateFileCache` returns the description of the existing cache. If a cache with the specified client request token exists and the parameters don't match, this call returns `IncompatibleParameterError`. If a file cache with the specified client request token doesn't exist, `CreateFileCache` does the following:
 * + Creates a new, empty Amazon File Cache resourcewith an assigned ID, and an initial lifecycle state of `CREATING`.
 * + Returns the description of the cache in JSON format.
 *
 * The `CreateFileCache` call returns while the cache's lifecycle state is still `CREATING`. You can check the cache creation status by calling the [DescribeFileCaches](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileCaches.html) operation, which returns the cache state along with other information.
 */
public suspend inline fun FSxClient.createFileCache(crossinline block: CreateFileCacheRequest.Builder.() -> Unit): CreateFileCacheResponse = createFileCache(CreateFileCacheRequest.Builder().apply(block).build())

/**
 * Creates a new, empty Amazon FSx file system. You can create the following supported Amazon FSx file systems using the `CreateFileSystem` API operation:
 * + Amazon FSx for Lustre
 * + Amazon FSx for NetApp ONTAP
 * + Amazon FSx for OpenZFS
 * + Amazon FSx for Windows File Server
 *
 * This operation requires a client request token in the request that Amazon FSx uses to ensure idempotent creation. This means that calling the operation multiple times with the same client request token has no effect. By using the idempotent operation, you can retry a `CreateFileSystem` operation without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives success as long as the parameters are the same.
 *
 * If a file system with the specified client request token exists and the parameters match, `CreateFileSystem` returns the description of the existing file system. If a file system with the specified client request token exists and the parameters don't match, this call returns `IncompatibleParameterError`. If a file system with the specified client request token doesn't exist, `CreateFileSystem` does the following:
 * + Creates a new, empty Amazon FSx file system with an assigned ID, and an initial lifecycle state of `CREATING`.
 * + Returns the description of the file system in JSON format.
 *
 * The `CreateFileSystem` call returns while the file system's lifecycle state is still `CREATING`. You can check the file-system creation status by calling the [DescribeFileSystems](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html) operation, which returns the file system state along with other information.
 */
public suspend inline fun FSxClient.createFileSystem(crossinline block: CreateFileSystemRequest.Builder.() -> Unit): CreateFileSystemResponse = createFileSystem(CreateFileSystemRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon FSx for Lustre, Amazon FSx for Windows File Server, or Amazon FSx for OpenZFS file system from an existing Amazon FSx backup.
 *
 * If a file system with the specified client request token exists and the parameters match, this operation returns the description of the file system. If a file system with the specified client request token exists but the parameters don't match, this call returns `IncompatibleParameterError`. If a file system with the specified client request token doesn't exist, this operation does the following:
 * + Creates a new Amazon FSx file system from backup with an assigned ID, and an initial lifecycle state of `CREATING`.
 * + Returns the description of the file system.
 *
 * Parameters like the Active Directory, default share name, automatic backup, and backup settings default to the parameters of the file system that was backed up, unless overridden. You can explicitly supply other settings.
 *
 * By using the idempotent operation, you can retry a `CreateFileSystemFromBackup` call without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives a success message as long as the parameters are the same.
 *
 * The `CreateFileSystemFromBackup` call returns while the file system's lifecycle state is still `CREATING`. You can check the file-system creation status by calling the [ DescribeFileSystems](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html) operation, which returns the file system state along with other information.
 */
public suspend inline fun FSxClient.createFileSystemFromBackup(crossinline block: CreateFileSystemFromBackupRequest.Builder.() -> Unit): CreateFileSystemFromBackupResponse = createFileSystemFromBackup(CreateFileSystemFromBackupRequest.Builder().apply(block).build())

/**
 * Creates a snapshot of an existing Amazon FSx for OpenZFS volume. With snapshots, you can easily undo file changes and compare file versions by restoring the volume to a previous version.
 *
 * If a snapshot with the specified client request token exists, and the parameters match, this operation returns the description of the existing snapshot. If a snapshot with the specified client request token exists, and the parameters don't match, this operation returns `IncompatibleParameterError`. If a snapshot with the specified client request token doesn't exist, `CreateSnapshot` does the following:
 * + Creates a new OpenZFS snapshot with an assigned ID, and an initial lifecycle state of `CREATING`.
 * + Returns the description of the snapshot.
 *
 * By using the idempotent operation, you can retry a `CreateSnapshot` operation without the risk of creating an extra snapshot. This approach can be useful when an initial call fails in a way that makes it unclear whether a snapshot was created. If you use the same client request token and the initial call created a snapshot, the operation returns a successful result because all the parameters are the same.
 *
 * The `CreateSnapshot` operation returns while the snapshot's lifecycle state is still `CREATING`. You can check the snapshot creation status by calling the [DescribeSnapshots](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeSnapshots.html) operation, which returns the snapshot state along with other information.
 */
public suspend inline fun FSxClient.createSnapshot(crossinline block: CreateSnapshotRequest.Builder.() -> Unit): CreateSnapshotResponse = createSnapshot(CreateSnapshotRequest.Builder().apply(block).build())

/**
 * Creates a storage virtual machine (SVM) for an Amazon FSx for ONTAP file system.
 */
public suspend inline fun FSxClient.createStorageVirtualMachine(crossinline block: CreateStorageVirtualMachineRequest.Builder.() -> Unit): CreateStorageVirtualMachineResponse = createStorageVirtualMachine(CreateStorageVirtualMachineRequest.Builder().apply(block).build())

/**
 * Creates an FSx for ONTAP or Amazon FSx for OpenZFS storage volume.
 */
public suspend inline fun FSxClient.createVolume(crossinline block: CreateVolumeRequest.Builder.() -> Unit): CreateVolumeResponse = createVolume(CreateVolumeRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon FSx for NetApp ONTAP volume from an existing Amazon FSx volume backup.
 */
public suspend inline fun FSxClient.createVolumeFromBackup(crossinline block: CreateVolumeFromBackupRequest.Builder.() -> Unit): CreateVolumeFromBackupResponse = createVolumeFromBackup(CreateVolumeFromBackupRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon FSx backup. After deletion, the backup no longer exists, and its data is gone.
 *
 * The `DeleteBackup` call returns instantly. The backup won't show up in later `DescribeBackups` calls.
 *
 * The data in a deleted backup is also deleted and can't be recovered by any means.
 *
 * @sample aws.sdk.kotlin.services.fsx.samples.DeleteBackup.sample
 */
public suspend inline fun FSxClient.deleteBackup(crossinline block: DeleteBackupRequest.Builder.() -> Unit): DeleteBackupResponse = deleteBackup(DeleteBackupRequest.Builder().apply(block).build())

/**
 * Deletes a data repository association on an Amazon FSx for Lustre file system. Deleting the data repository association unlinks the file system from the Amazon S3 bucket. When deleting a data repository association, you have the option of deleting the data in the file system that corresponds to the data repository association. Data repository associations are supported on all FSx for Lustre 2.12 and 2.15 file systems, excluding `scratch_1` deployment type.
 */
public suspend inline fun FSxClient.deleteDataRepositoryAssociation(crossinline block: DeleteDataRepositoryAssociationRequest.Builder.() -> Unit): DeleteDataRepositoryAssociationResponse = deleteDataRepositoryAssociation(DeleteDataRepositoryAssociationRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon File Cache resource. After deletion, the cache no longer exists, and its data is gone.
 *
 * The `DeleteFileCache` operation returns while the cache has the `DELETING` status. You can check the cache deletion status by calling the [DescribeFileCaches](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileCaches.html) operation, which returns a list of caches in your account. If you pass the cache ID for a deleted cache, the `DescribeFileCaches` operation returns a `FileCacheNotFound` error.
 *
 * The data in a deleted cache is also deleted and can't be recovered by any means.
 */
public suspend inline fun FSxClient.deleteFileCache(crossinline block: DeleteFileCacheRequest.Builder.() -> Unit): DeleteFileCacheResponse = deleteFileCache(DeleteFileCacheRequest.Builder().apply(block).build())

/**
 * Deletes a file system. After deletion, the file system no longer exists, and its data is gone. Any existing automatic backups and snapshots are also deleted.
 *
 * To delete an Amazon FSx for NetApp ONTAP file system, first delete all the volumes and storage virtual machines (SVMs) on the file system. Then provide a `FileSystemId` value to the `DeleFileSystem` operation.
 *
 * By default, when you delete an Amazon FSx for Windows File Server file system, a final backup is created upon deletion. This final backup isn't subject to the file system's retention policy, and must be manually deleted.
 *
 * To delete an Amazon FSx for Lustre file system, first [unmount](https://docs.aws.amazon.com/fsx/latest/LustreGuide/unmounting-fs.html) it from every connected Amazon EC2 instance, then provide a `FileSystemId` value to the `DeleFileSystem` operation. By default, Amazon FSx will not take a final backup when the `DeleteFileSystem` operation is invoked. On file systems not linked to an Amazon S3 bucket, set `SkipFinalBackup` to `false` to take a final backup of the file system you are deleting. Backups cannot be enabled on S3-linked file systems. To ensure all of your data is written back to S3 before deleting your file system, you can either monitor for the [AgeOfOldestQueuedMessage](https://docs.aws.amazon.com/fsx/latest/LustreGuide/monitoring-cloudwatch.html#auto-import-export-metrics) metric to be zero (if using automatic export) or you can run an [export data repository task](https://docs.aws.amazon.com/fsx/latest/LustreGuide/export-data-repo-task-dra.html). If you have automatic export enabled and want to use an export data repository task, you have to disable automatic export before executing the export data repository task.
 *
 * The `DeleteFileSystem` operation returns while the file system has the `DELETING` status. You can check the file system deletion status by calling the [DescribeFileSystems](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html) operation, which returns a list of file systems in your account. If you pass the file system ID for a deleted file system, the `DescribeFileSystems` operation returns a `FileSystemNotFound` error.
 *
 * If a data repository task is in a `PENDING` or `EXECUTING` state, deleting an Amazon FSx for Lustre file system will fail with an HTTP status code 400 (Bad Request).
 *
 * The data in a deleted file system is also deleted and can't be recovered by any means.
 *
 * @sample aws.sdk.kotlin.services.fsx.samples.DeleteFileSystem.sample
 */
public suspend inline fun FSxClient.deleteFileSystem(crossinline block: DeleteFileSystemRequest.Builder.() -> Unit): DeleteFileSystemResponse = deleteFileSystem(DeleteFileSystemRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon FSx for OpenZFS snapshot. After deletion, the snapshot no longer exists, and its data is gone. Deleting a snapshot doesn't affect snapshots stored in a file system backup.
 *
 * The `DeleteSnapshot` operation returns instantly. The snapshot appears with the lifecycle status of `DELETING` until the deletion is complete.
 */
public suspend inline fun FSxClient.deleteSnapshot(crossinline block: DeleteSnapshotRequest.Builder.() -> Unit): DeleteSnapshotResponse = deleteSnapshot(DeleteSnapshotRequest.Builder().apply(block).build())

/**
 * Deletes an existing Amazon FSx for ONTAP storage virtual machine (SVM). Prior to deleting an SVM, you must delete all non-root volumes in the SVM, otherwise the operation will fail.
 */
public suspend inline fun FSxClient.deleteStorageVirtualMachine(crossinline block: DeleteStorageVirtualMachineRequest.Builder.() -> Unit): DeleteStorageVirtualMachineResponse = deleteStorageVirtualMachine(DeleteStorageVirtualMachineRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.
 */
public suspend inline fun FSxClient.deleteVolume(crossinline block: DeleteVolumeRequest.Builder.() -> Unit): DeleteVolumeResponse = deleteVolume(DeleteVolumeRequest.Builder().apply(block).build())

/**
 * Returns the description of a specific Amazon FSx backup, if a `BackupIds` value is provided for that backup. Otherwise, it returns all backups owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
 *
 * When retrieving all backups, you can optionally specify the `MaxResults` parameter to limit the number of backups in a response. If more backups remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of the `NextToken` value from the last response.
 *
 * This operation is used in an iterative process to retrieve a list of your backups. `DescribeBackups` is called first without a `NextToken` value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken` value.
 *
 * When using this operation, keep the following in mind:
 * + The operation might return fewer than the `MaxResults` value of backup descriptions while still including a `NextToken` value.
 * + The order of the backups returned in the response of one `DescribeBackups` call and the order of the backups returned across the responses of a multi-call iteration is unspecified.
 */
public suspend inline fun FSxClient.describeBackups(crossinline block: DescribeBackupsRequest.Builder.() -> Unit): DescribeBackupsResponse = describeBackups(DescribeBackupsRequest.Builder().apply(block).build())

/**
 * Returns the description of specific Amazon FSx for Lustre or Amazon File Cache data repository associations, if one or more `AssociationIds` values are provided in the request, or if filters are used in the request. Data repository associations are supported on Amazon File Cache resources and all FSx for Lustre 2.12 and 2,15 file systems, excluding `scratch_1` deployment type.
 *
 * You can use filters to narrow the response to include just data repository associations for specific file systems (use the `file-system-id` filter with the ID of the file system) or caches (use the `file-cache-id` filter with the ID of the cache), or data repository associations for a specific repository type (use the `data-repository-type` filter with a value of `S3` or `NFS`). If you don't use filters, the response returns all data repository associations owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
 *
 * When retrieving all data repository associations, you can paginate the response by using the optional `MaxResults` parameter to limit the number of data repository associations returned in a response. If more data repository associations remain, a `NextToken` value is returned in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
 */
public suspend inline fun FSxClient.describeDataRepositoryAssociations(crossinline block: DescribeDataRepositoryAssociationsRequest.Builder.() -> Unit): DescribeDataRepositoryAssociationsResponse = describeDataRepositoryAssociations(DescribeDataRepositoryAssociationsRequest.Builder().apply(block).build())

/**
 * Returns the description of specific Amazon FSx for Lustre or Amazon File Cache data repository tasks, if one or more `TaskIds` values are provided in the request, or if filters are used in the request. You can use filters to narrow the response to include just tasks for specific file systems or caches, or tasks in a specific lifecycle state. Otherwise, it returns all data repository tasks owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
 *
 * When retrieving all tasks, you can paginate the response by using the optional `MaxResults` parameter to limit the number of tasks returned in a response. If more tasks remain, a `NextToken` value is returned in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
 */
public suspend inline fun FSxClient.describeDataRepositoryTasks(crossinline block: DescribeDataRepositoryTasksRequest.Builder.() -> Unit): DescribeDataRepositoryTasksResponse = describeDataRepositoryTasks(DescribeDataRepositoryTasksRequest.Builder().apply(block).build())

/**
 * Returns the description of a specific Amazon File Cache resource, if a `FileCacheIds` value is provided for that cache. Otherwise, it returns descriptions of all caches owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
 *
 * When retrieving all cache descriptions, you can optionally specify the `MaxResults` parameter to limit the number of descriptions in a response. If more cache descriptions remain, the operation returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
 *
 * This operation is used in an iterative process to retrieve a list of your cache descriptions. `DescribeFileCaches` is called first without a `NextToken`value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken`.
 *
 * When using this operation, keep the following in mind:
 * + The implementation might return fewer than `MaxResults` cache descriptions while still including a `NextToken` value.
 * + The order of caches returned in the response of one `DescribeFileCaches` call and the order of caches returned across the responses of a multicall iteration is unspecified.
 */
public suspend inline fun FSxClient.describeFileCaches(crossinline block: DescribeFileCachesRequest.Builder.() -> Unit): DescribeFileCachesResponse = describeFileCaches(DescribeFileCachesRequest.Builder().apply(block).build())

/**
 * Returns the DNS aliases that are associated with the specified Amazon FSx for Windows File Server file system. A history of all DNS aliases that have been associated with and disassociated from the file system is available in the list of AdministrativeAction provided in the DescribeFileSystems operation response.
 */
public suspend inline fun FSxClient.describeFileSystemAliases(crossinline block: DescribeFileSystemAliasesRequest.Builder.() -> Unit): DescribeFileSystemAliasesResponse = describeFileSystemAliases(DescribeFileSystemAliasesRequest.Builder().apply(block).build())

/**
 * Returns the description of specific Amazon FSx file systems, if a `FileSystemIds` value is provided for that file system. Otherwise, it returns descriptions of all file systems owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
 *
 * When retrieving all file system descriptions, you can optionally specify the `MaxResults` parameter to limit the number of descriptions in a response. If more file system descriptions remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
 *
 * This operation is used in an iterative process to retrieve a list of your file system descriptions. `DescribeFileSystems` is called first without a `NextToken`value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken`.
 *
 * When using this operation, keep the following in mind:
 * + The implementation might return fewer than `MaxResults` file system descriptions while still including a `NextToken` value.
 * + The order of file systems returned in the response of one `DescribeFileSystems` call and the order of file systems returned across the responses of a multicall iteration is unspecified.
 */
public suspend inline fun FSxClient.describeFileSystems(crossinline block: DescribeFileSystemsRequest.Builder.() -> Unit): DescribeFileSystemsResponse = describeFileSystems(DescribeFileSystemsRequest.Builder().apply(block).build())

/**
 * Indicates whether participant accounts in your organization can create Amazon FSx for NetApp ONTAP Multi-AZ file systems in subnets that are shared by a virtual private cloud (VPC) owner. For more information, see [Creating FSx for ONTAP file systems in shared subnets](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/creating-file-systems.html#fsxn-vpc-shared-subnets).
 */
public suspend inline fun FSxClient.describeSharedVpcConfiguration(crossinline block: DescribeSharedVpcConfigurationRequest.Builder.() -> Unit): DescribeSharedVpcConfigurationResponse = describeSharedVpcConfiguration(DescribeSharedVpcConfigurationRequest.Builder().apply(block).build())

/**
 * Returns the description of specific Amazon FSx for OpenZFS snapshots, if a `SnapshotIds` value is provided. Otherwise, this operation returns all snapshots owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
 *
 * When retrieving all snapshots, you can optionally specify the `MaxResults` parameter to limit the number of snapshots in a response. If more backups remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
 *
 * Use this operation in an iterative process to retrieve a list of your snapshots. `DescribeSnapshots` is called first without a `NextToken` value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken` value.
 *
 * When using this operation, keep the following in mind:
 * + The operation might return fewer than the `MaxResults` value of snapshot descriptions while still including a `NextToken` value.
 * + The order of snapshots returned in the response of one `DescribeSnapshots` call and the order of backups returned across the responses of a multi-call iteration is unspecified.
 */
public suspend inline fun FSxClient.describeSnapshots(crossinline block: DescribeSnapshotsRequest.Builder.() -> Unit): DescribeSnapshotsResponse = describeSnapshots(DescribeSnapshotsRequest.Builder().apply(block).build())

/**
 * Describes one or more Amazon FSx for NetApp ONTAP storage virtual machines (SVMs).
 */
public suspend inline fun FSxClient.describeStorageVirtualMachines(crossinline block: DescribeStorageVirtualMachinesRequest.Builder.() -> Unit): DescribeStorageVirtualMachinesResponse = describeStorageVirtualMachines(DescribeStorageVirtualMachinesRequest.Builder().apply(block).build())

/**
 * Describes one or more Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volumes.
 */
public suspend inline fun FSxClient.describeVolumes(crossinline block: DescribeVolumesRequest.Builder.() -> Unit): DescribeVolumesResponse = describeVolumes(DescribeVolumesRequest.Builder().apply(block).build())

/**
 * Use this action to disassociate, or remove, one or more Domain Name Service (DNS) aliases from an Amazon FSx for Windows File Server file system. If you attempt to disassociate a DNS alias that is not associated with the file system, Amazon FSx responds with an HTTP status code 400 (Bad Request). For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html).
 *
 * The system generated response showing the DNS aliases that Amazon FSx is attempting to disassociate from the file system. Use the API operation to monitor the status of the aliases Amazon FSx is disassociating with the file system.
 */
public suspend inline fun FSxClient.disassociateFileSystemAliases(crossinline block: DisassociateFileSystemAliasesRequest.Builder.() -> Unit): DisassociateFileSystemAliasesResponse = disassociateFileSystemAliases(DisassociateFileSystemAliasesRequest.Builder().apply(block).build())

/**
 * Lists tags for Amazon FSx resources.
 *
 * When retrieving all tags, you can optionally specify the `MaxResults` parameter to limit the number of tags in a response. If more tags remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
 *
 * This action is used in an iterative process to retrieve a list of your tags. `ListTagsForResource` is called first without a `NextToken`value. Then the action continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken`.
 *
 * When using this action, keep the following in mind:
 * + The implementation might return fewer than `MaxResults` file system descriptions while still including a `NextToken` value.
 * + The order of tags returned in the response of one `ListTagsForResource` call and the order of tags returned across the responses of a multi-call iteration is unspecified.
 *
 * @sample aws.sdk.kotlin.services.fsx.samples.ListTagsForResource.sample
 */
public suspend inline fun FSxClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Releases the file system lock from an Amazon FSx for OpenZFS file system.
 */
public suspend inline fun FSxClient.releaseFileSystemNfsV3Locks(crossinline block: ReleaseFileSystemNfsV3LocksRequest.Builder.() -> Unit): ReleaseFileSystemNfsV3LocksResponse = releaseFileSystemNfsV3Locks(ReleaseFileSystemNfsV3LocksRequest.Builder().apply(block).build())

/**
 * Returns an Amazon FSx for OpenZFS volume to the state saved by the specified snapshot.
 */
public suspend inline fun FSxClient.restoreVolumeFromSnapshot(crossinline block: RestoreVolumeFromSnapshotRequest.Builder.() -> Unit): RestoreVolumeFromSnapshotResponse = restoreVolumeFromSnapshot(RestoreVolumeFromSnapshotRequest.Builder().apply(block).build())

/**
 * After performing steps to repair the Active Directory configuration of an FSx for Windows File Server file system, use this action to initiate the process of Amazon FSx attempting to reconnect to the file system.
 */
public suspend inline fun FSxClient.startMisconfiguredStateRecovery(crossinline block: StartMisconfiguredStateRecoveryRequest.Builder.() -> Unit): StartMisconfiguredStateRecoveryResponse = startMisconfiguredStateRecovery(StartMisconfiguredStateRecoveryRequest.Builder().apply(block).build())

/**
 * Tags an Amazon FSx resource.
 *
 * @sample aws.sdk.kotlin.services.fsx.samples.TagResource.sample
 */
public suspend inline fun FSxClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * This action removes a tag from an Amazon FSx resource.
 *
 * @sample aws.sdk.kotlin.services.fsx.samples.UntagResource.sample
 */
public suspend inline fun FSxClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the configuration of an existing data repository association on an Amazon FSx for Lustre file system. Data repository associations are supported on all FSx for Lustre 2.12 and 2.15 file systems, excluding `scratch_1` deployment type.
 */
public suspend inline fun FSxClient.updateDataRepositoryAssociation(crossinline block: UpdateDataRepositoryAssociationRequest.Builder.() -> Unit): UpdateDataRepositoryAssociationResponse = updateDataRepositoryAssociation(UpdateDataRepositoryAssociationRequest.Builder().apply(block).build())

/**
 * Updates the configuration of an existing Amazon File Cache resource. You can update multiple properties in a single request.
 */
public suspend inline fun FSxClient.updateFileCache(crossinline block: UpdateFileCacheRequest.Builder.() -> Unit): UpdateFileCacheResponse = updateFileCache(UpdateFileCacheRequest.Builder().apply(block).build())

/**
 * Use this operation to update the configuration of an existing Amazon FSx file system. You can update multiple properties in a single request.
 *
 * For FSx for Windows File Server file systems, you can update the following properties:
 * + `AuditLogConfiguration`
 * + `AutomaticBackupRetentionDays`
 * + `DailyAutomaticBackupStartTime`
 * + `SelfManagedActiveDirectoryConfiguration`
 * + `StorageCapacity`
 * + `StorageType`
 * + `ThroughputCapacity`
 * + `DiskIopsConfiguration`
 * + `WeeklyMaintenanceStartTime`
 *
 * For FSx for Lustre file systems, you can update the following properties:
 * + `AutoImportPolicy`
 * + `AutomaticBackupRetentionDays`
 * + `DailyAutomaticBackupStartTime`
 * + `DataCompressionType`
 * + `LogConfiguration`
 * + `LustreRootSquashConfiguration`
 * + `PerUnitStorageThroughput`
 * + `StorageCapacity`
 * + `WeeklyMaintenanceStartTime`
 *
 * For FSx for ONTAP file systems, you can update the following properties:
 * + `AddRouteTableIds`
 * + `AutomaticBackupRetentionDays`
 * + `DailyAutomaticBackupStartTime`
 * + `DiskIopsConfiguration`
 * + `FsxAdminPassword`
 * + `HAPairs`
 * + `RemoveRouteTableIds`
 * + `StorageCapacity`
 * + `ThroughputCapacity`
 * + `ThroughputCapacityPerHAPair`
 * + `WeeklyMaintenanceStartTime`
 *
 * For FSx for OpenZFS file systems, you can update the following properties:
 * + `AddRouteTableIds`
 * + `AutomaticBackupRetentionDays`
 * + `CopyTagsToBackups`
 * + `CopyTagsToVolumes`
 * + `DailyAutomaticBackupStartTime`
 * + `DiskIopsConfiguration`
 * + `RemoveRouteTableIds`
 * + `StorageCapacity`
 * + `ThroughputCapacity`
 * + `WeeklyMaintenanceStartTime`
 */
public suspend inline fun FSxClient.updateFileSystem(crossinline block: UpdateFileSystemRequest.Builder.() -> Unit): UpdateFileSystemResponse = updateFileSystem(UpdateFileSystemRequest.Builder().apply(block).build())

/**
 * Configures whether participant accounts in your organization can create Amazon FSx for NetApp ONTAP Multi-AZ file systems in subnets that are shared by a virtual private cloud (VPC) owner. For more information, see the [Amazon FSx for NetApp ONTAP User Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/maz-shared-vpc.html).
 *
 * We strongly recommend that participant-created Multi-AZ file systems in the shared VPC are deleted before you disable this feature. Once the feature is disabled, these file systems will enter a `MISCONFIGURED` state and behave like Single-AZ file systems. For more information, see [Important considerations before disabling shared VPC support for Multi-AZ file systems](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/maz-shared-vpc.html#disabling-maz-vpc-sharing).
 */
public suspend inline fun FSxClient.updateSharedVpcConfiguration(crossinline block: UpdateSharedVpcConfigurationRequest.Builder.() -> Unit): UpdateSharedVpcConfigurationResponse = updateSharedVpcConfiguration(UpdateSharedVpcConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the name of an Amazon FSx for OpenZFS snapshot.
 */
public suspend inline fun FSxClient.updateSnapshot(crossinline block: UpdateSnapshotRequest.Builder.() -> Unit): UpdateSnapshotResponse = updateSnapshot(UpdateSnapshotRequest.Builder().apply(block).build())

/**
 * Updates an FSx for ONTAP storage virtual machine (SVM).
 */
public suspend inline fun FSxClient.updateStorageVirtualMachine(crossinline block: UpdateStorageVirtualMachineRequest.Builder.() -> Unit): UpdateStorageVirtualMachineResponse = updateStorageVirtualMachine(UpdateStorageVirtualMachineRequest.Builder().apply(block).build())

/**
 * Updates the configuration of an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.
 */
public suspend inline fun FSxClient.updateVolume(crossinline block: UpdateVolumeRequest.Builder.() -> Unit): UpdateVolumeResponse = updateVolume(UpdateVolumeRequest.Builder().apply(block).build())
