// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fsx

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.fsx.auth.FSxAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.fsx.auth.FSxIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.fsx.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.fsx.model.*
import aws.sdk.kotlin.services.fsx.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultFSxClient(override val config: FSxClient.Config) : FSxClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = FSxIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "fsx")
        }
        toMap()
    }
    private val authSchemeAdapter = FSxAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.fsx"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Use this action to associate one or more Domain Name Server (DNS) aliases with an existing Amazon FSx for Windows File Server file system. A file system can have a maximum of 50 DNS aliases associated with it at any one time. If you try to associate a DNS alias that is already associated with the file system, FSx takes no action on that alias in the request. For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html) and [Walkthrough 5: Using DNS aliases to access your file system](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html), including additional steps you must take to be able to access your file system using a DNS alias.
     *
     * The system response shows the DNS aliases that Amazon FSx is attempting to associate with the file system. Use the API operation to monitor the status of the aliases Amazon FSx is associating with the file system.
     */
    override suspend fun associateFileSystemAliases(input: AssociateFileSystemAliasesRequest): AssociateFileSystemAliasesResponse {
        val op = SdkHttpOperation.build<AssociateFileSystemAliasesRequest, AssociateFileSystemAliasesResponse> {
            serializeWith = AssociateFileSystemAliasesOperationSerializer()
            deserializeWith = AssociateFileSystemAliasesOperationDeserializer()
            operationName = "AssociateFileSystemAliases"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Cancels an existing Amazon FSx for Lustre data repository task if that task is in either the `PENDING` or `EXECUTING` state. When you cancel am export task, Amazon FSx does the following.
     * + Any files that FSx has already exported are not reverted.
     * + FSx continues to export any files that are in-flight when the cancel operation is received.
     * + FSx does not export any files that have not yet been exported.
     *
     * For a release task, Amazon FSx will stop releasing files upon cancellation. Any files that have already been released will remain in the released state.
     */
    override suspend fun cancelDataRepositoryTask(input: CancelDataRepositoryTaskRequest): CancelDataRepositoryTaskResponse {
        val op = SdkHttpOperation.build<CancelDataRepositoryTaskRequest, CancelDataRepositoryTaskResponse> {
            serializeWith = CancelDataRepositoryTaskOperationSerializer()
            deserializeWith = CancelDataRepositoryTaskOperationDeserializer()
            operationName = "CancelDataRepositoryTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Copies an existing backup within the same Amazon Web Services account to another Amazon Web Services Region (cross-Region copy) or within the same Amazon Web Services Region (in-Region copy). You can have up to five backup copy requests in progress to a single destination Region per account.
     *
     * You can use cross-Region backup copies for cross-Region disaster recovery. You can periodically take backups and copy them to another Region so that in the event of a disaster in the primary Region, you can restore from backup and recover availability quickly in the other Region. You can make cross-Region copies only within your Amazon Web Services partition. A partition is a grouping of Regions. Amazon Web Services currently has three partitions: `aws` (Standard Regions), `aws-cn` (China Regions), and `aws-us-gov` (Amazon Web Services GovCloud &#91;US&#93; Regions).
     *
     * You can also use backup copies to clone your file dataset to another Region or within the same Region.
     *
     * You can use the `SourceRegion` parameter to specify the Amazon Web Services Region from which the backup will be copied. For example, if you make the call from the `us-west-1` Region and want to copy a backup from the `us-east-2` Region, you specify `us-east-2` in the `SourceRegion` parameter to make a cross-Region copy. If you don't specify a Region, the backup copy is created in the same Region where the request is sent from (in-Region copy).
     *
     * For more information about creating backup copies, see [ Copying backups](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#copy-backups) in the *Amazon FSx for Windows User Guide*, [Copying backups](https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html#copy-backups) in the *Amazon FSx for Lustre User Guide*, and [Copying backups](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/using-backups.html#copy-backups) in the *Amazon FSx for OpenZFS User Guide*.
     *
     * @sample aws.sdk.kotlin.services.fsx.samples.CopyBackup.sample
     */
    override suspend fun copyBackup(input: CopyBackupRequest): CopyBackupResponse {
        val op = SdkHttpOperation.build<CopyBackupRequest, CopyBackupResponse> {
            serializeWith = CopyBackupOperationSerializer()
            deserializeWith = CopyBackupOperationDeserializer()
            operationName = "CopyBackup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing volume by using a snapshot from another Amazon FSx for OpenZFS file system. For more information, see [on-demand data replication](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/on-demand-replication.html) in the Amazon FSx for OpenZFS User Guide.
     */
    override suspend fun copySnapshotAndUpdateVolume(input: CopySnapshotAndUpdateVolumeRequest): CopySnapshotAndUpdateVolumeResponse {
        val op = SdkHttpOperation.build<CopySnapshotAndUpdateVolumeRequest, CopySnapshotAndUpdateVolumeResponse> {
            serializeWith = CopySnapshotAndUpdateVolumeOperationSerializer()
            deserializeWith = CopySnapshotAndUpdateVolumeOperationDeserializer()
            operationName = "CopySnapshotAndUpdateVolume"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a backup of an existing Amazon FSx for Windows File Server file system, Amazon FSx for Lustre file system, Amazon FSx for NetApp ONTAP volume, or Amazon FSx for OpenZFS file system. We recommend creating regular backups so that you can restore a file system or volume from a backup if an issue arises with the original file system or volume.
     *
     * For Amazon FSx for Lustre file systems, you can create a backup only for file systems that have the following configuration:
     * + A Persistent deployment type
     * + Are *not* linked to a data repository
     *
     * For more information about backups, see the following:
     * + For Amazon FSx for Lustre, see [Working with FSx for Lustre backups](https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html).
     * + For Amazon FSx for Windows, see [Working with FSx for Windows backups](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html).
     * + For Amazon FSx for NetApp ONTAP, see [Working with FSx for NetApp ONTAP backups](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/using-backups.html).
     * + For Amazon FSx for OpenZFS, see [Working with FSx for OpenZFS backups](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/using-backups.html).
     *
     * If a backup with the specified client request token exists and the parameters match, this operation returns the description of the existing backup. If a backup with the specified client request token exists and the parameters don't match, this operation returns `IncompatibleParameterError`. If a backup with the specified client request token doesn't exist, `CreateBackup` does the following:
     * + Creates a new Amazon FSx backup with an assigned ID, and an initial lifecycle state of `CREATING`.
     * + Returns the description of the backup.
     *
     * By using the idempotent operation, you can retry a `CreateBackup` operation without the risk of creating an extra backup. This approach can be useful when an initial call fails in a way that makes it unclear whether a backup was created. If you use the same client request token and the initial call created a backup, the operation returns a successful result because all the parameters are the same.
     *
     * The `CreateBackup` operation returns while the backup's lifecycle state is still `CREATING`. You can check the backup creation status by calling the [DescribeBackups](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeBackups.html) operation, which returns the backup state along with other information.
     */
    override suspend fun createBackup(input: CreateBackupRequest): CreateBackupResponse {
        val op = SdkHttpOperation.build<CreateBackupRequest, CreateBackupResponse> {
            serializeWith = CreateBackupOperationSerializer()
            deserializeWith = CreateBackupOperationDeserializer()
            operationName = "CreateBackup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon FSx for Lustre data repository association (DRA). A data repository association is a link between a directory on the file system and an Amazon S3 bucket or prefix. You can have a maximum of 8 data repository associations on a file system. Data repository associations are supported on all FSx for Lustre 2.12 and 2.15 file systems, excluding `scratch_1` deployment type.
     *
     * Each data repository association must have a unique Amazon FSx file system directory and a unique S3 bucket or prefix associated with it. You can configure a data repository association for automatic import only, for automatic export only, or for both. To learn more about linking a data repository to your file system, see [Linking your file system to an S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html).
     *
     * `CreateDataRepositoryAssociation` isn't supported on Amazon File Cache resources. To create a DRA on Amazon File Cache, use the `CreateFileCache` operation.
     */
    override suspend fun createDataRepositoryAssociation(input: CreateDataRepositoryAssociationRequest): CreateDataRepositoryAssociationResponse {
        val op = SdkHttpOperation.build<CreateDataRepositoryAssociationRequest, CreateDataRepositoryAssociationResponse> {
            serializeWith = CreateDataRepositoryAssociationOperationSerializer()
            deserializeWith = CreateDataRepositoryAssociationOperationDeserializer()
            operationName = "CreateDataRepositoryAssociation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon FSx for Lustre data repository task. A `CreateDataRepositoryTask` operation will fail if a data repository is not linked to the FSx file system.
     *
     * You use import and export data repository tasks to perform bulk operations between your FSx for Lustre file system and its linked data repositories. An example of a data repository task is exporting any data and metadata changes, including POSIX metadata, to files, directories, and symbolic links (symlinks) from your FSx file system to a linked data repository.
     *
     * You use release data repository tasks to release data from your file system for files that are exported to S3. The metadata of released files remains on the file system so users or applications can still access released files by reading the files again, which will restore data from Amazon S3 to the FSx for Lustre file system.
     *
     * To learn more about data repository tasks, see [Data Repository Tasks](https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-repository-tasks.html). To learn more about linking a data repository to your file system, see [Linking your file system to an S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html).
     */
    override suspend fun createDataRepositoryTask(input: CreateDataRepositoryTaskRequest): CreateDataRepositoryTaskResponse {
        val op = SdkHttpOperation.build<CreateDataRepositoryTaskRequest, CreateDataRepositoryTaskResponse> {
            serializeWith = CreateDataRepositoryTaskOperationSerializer()
            deserializeWith = CreateDataRepositoryTaskOperationDeserializer()
            operationName = "CreateDataRepositoryTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Amazon File Cache resource.
     *
     * You can use this operation with a client request token in the request that Amazon File Cache uses to ensure idempotent creation. If a cache with the specified client request token exists and the parameters match, `CreateFileCache` returns the description of the existing cache. If a cache with the specified client request token exists and the parameters don't match, this call returns `IncompatibleParameterError`. If a file cache with the specified client request token doesn't exist, `CreateFileCache` does the following:
     * + Creates a new, empty Amazon File Cache resourcewith an assigned ID, and an initial lifecycle state of `CREATING`.
     * + Returns the description of the cache in JSON format.
     *
     * The `CreateFileCache` call returns while the cache's lifecycle state is still `CREATING`. You can check the cache creation status by calling the [DescribeFileCaches](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileCaches.html) operation, which returns the cache state along with other information.
     */
    override suspend fun createFileCache(input: CreateFileCacheRequest): CreateFileCacheResponse {
        val op = SdkHttpOperation.build<CreateFileCacheRequest, CreateFileCacheResponse> {
            serializeWith = CreateFileCacheOperationSerializer()
            deserializeWith = CreateFileCacheOperationDeserializer()
            operationName = "CreateFileCache"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new, empty Amazon FSx file system. You can create the following supported Amazon FSx file systems using the `CreateFileSystem` API operation:
     * + Amazon FSx for Lustre
     * + Amazon FSx for NetApp ONTAP
     * + Amazon FSx for OpenZFS
     * + Amazon FSx for Windows File Server
     *
     * This operation requires a client request token in the request that Amazon FSx uses to ensure idempotent creation. This means that calling the operation multiple times with the same client request token has no effect. By using the idempotent operation, you can retry a `CreateFileSystem` operation without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives success as long as the parameters are the same.
     *
     * If a file system with the specified client request token exists and the parameters match, `CreateFileSystem` returns the description of the existing file system. If a file system with the specified client request token exists and the parameters don't match, this call returns `IncompatibleParameterError`. If a file system with the specified client request token doesn't exist, `CreateFileSystem` does the following:
     * + Creates a new, empty Amazon FSx file system with an assigned ID, and an initial lifecycle state of `CREATING`.
     * + Returns the description of the file system in JSON format.
     *
     * The `CreateFileSystem` call returns while the file system's lifecycle state is still `CREATING`. You can check the file-system creation status by calling the [DescribeFileSystems](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html) operation, which returns the file system state along with other information.
     */
    override suspend fun createFileSystem(input: CreateFileSystemRequest): CreateFileSystemResponse {
        val op = SdkHttpOperation.build<CreateFileSystemRequest, CreateFileSystemResponse> {
            serializeWith = CreateFileSystemOperationSerializer()
            deserializeWith = CreateFileSystemOperationDeserializer()
            operationName = "CreateFileSystem"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Amazon FSx for Lustre, Amazon FSx for Windows File Server, or Amazon FSx for OpenZFS file system from an existing Amazon FSx backup.
     *
     * If a file system with the specified client request token exists and the parameters match, this operation returns the description of the file system. If a file system with the specified client request token exists but the parameters don't match, this call returns `IncompatibleParameterError`. If a file system with the specified client request token doesn't exist, this operation does the following:
     * + Creates a new Amazon FSx file system from backup with an assigned ID, and an initial lifecycle state of `CREATING`.
     * + Returns the description of the file system.
     *
     * Parameters like the Active Directory, default share name, automatic backup, and backup settings default to the parameters of the file system that was backed up, unless overridden. You can explicitly supply other settings.
     *
     * By using the idempotent operation, you can retry a `CreateFileSystemFromBackup` call without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives a success message as long as the parameters are the same.
     *
     * The `CreateFileSystemFromBackup` call returns while the file system's lifecycle state is still `CREATING`. You can check the file-system creation status by calling the [ DescribeFileSystems](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html) operation, which returns the file system state along with other information.
     */
    override suspend fun createFileSystemFromBackup(input: CreateFileSystemFromBackupRequest): CreateFileSystemFromBackupResponse {
        val op = SdkHttpOperation.build<CreateFileSystemFromBackupRequest, CreateFileSystemFromBackupResponse> {
            serializeWith = CreateFileSystemFromBackupOperationSerializer()
            deserializeWith = CreateFileSystemFromBackupOperationDeserializer()
            operationName = "CreateFileSystemFromBackup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a snapshot of an existing Amazon FSx for OpenZFS volume. With snapshots, you can easily undo file changes and compare file versions by restoring the volume to a previous version.
     *
     * If a snapshot with the specified client request token exists, and the parameters match, this operation returns the description of the existing snapshot. If a snapshot with the specified client request token exists, and the parameters don't match, this operation returns `IncompatibleParameterError`. If a snapshot with the specified client request token doesn't exist, `CreateSnapshot` does the following:
     * + Creates a new OpenZFS snapshot with an assigned ID, and an initial lifecycle state of `CREATING`.
     * + Returns the description of the snapshot.
     *
     * By using the idempotent operation, you can retry a `CreateSnapshot` operation without the risk of creating an extra snapshot. This approach can be useful when an initial call fails in a way that makes it unclear whether a snapshot was created. If you use the same client request token and the initial call created a snapshot, the operation returns a successful result because all the parameters are the same.
     *
     * The `CreateSnapshot` operation returns while the snapshot's lifecycle state is still `CREATING`. You can check the snapshot creation status by calling the [DescribeSnapshots](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeSnapshots.html) operation, which returns the snapshot state along with other information.
     */
    override suspend fun createSnapshot(input: CreateSnapshotRequest): CreateSnapshotResponse {
        val op = SdkHttpOperation.build<CreateSnapshotRequest, CreateSnapshotResponse> {
            serializeWith = CreateSnapshotOperationSerializer()
            deserializeWith = CreateSnapshotOperationDeserializer()
            operationName = "CreateSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a storage virtual machine (SVM) for an Amazon FSx for ONTAP file system.
     */
    override suspend fun createStorageVirtualMachine(input: CreateStorageVirtualMachineRequest): CreateStorageVirtualMachineResponse {
        val op = SdkHttpOperation.build<CreateStorageVirtualMachineRequest, CreateStorageVirtualMachineResponse> {
            serializeWith = CreateStorageVirtualMachineOperationSerializer()
            deserializeWith = CreateStorageVirtualMachineOperationDeserializer()
            operationName = "CreateStorageVirtualMachine"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an FSx for ONTAP or Amazon FSx for OpenZFS storage volume.
     */
    override suspend fun createVolume(input: CreateVolumeRequest): CreateVolumeResponse {
        val op = SdkHttpOperation.build<CreateVolumeRequest, CreateVolumeResponse> {
            serializeWith = CreateVolumeOperationSerializer()
            deserializeWith = CreateVolumeOperationDeserializer()
            operationName = "CreateVolume"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Amazon FSx for NetApp ONTAP volume from an existing Amazon FSx volume backup.
     */
    override suspend fun createVolumeFromBackup(input: CreateVolumeFromBackupRequest): CreateVolumeFromBackupResponse {
        val op = SdkHttpOperation.build<CreateVolumeFromBackupRequest, CreateVolumeFromBackupResponse> {
            serializeWith = CreateVolumeFromBackupOperationSerializer()
            deserializeWith = CreateVolumeFromBackupOperationDeserializer()
            operationName = "CreateVolumeFromBackup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon FSx backup. After deletion, the backup no longer exists, and its data is gone.
     *
     * The `DeleteBackup` call returns instantly. The backup won't show up in later `DescribeBackups` calls.
     *
     * The data in a deleted backup is also deleted and can't be recovered by any means.
     *
     * @sample aws.sdk.kotlin.services.fsx.samples.DeleteBackup.sample
     */
    override suspend fun deleteBackup(input: DeleteBackupRequest): DeleteBackupResponse {
        val op = SdkHttpOperation.build<DeleteBackupRequest, DeleteBackupResponse> {
            serializeWith = DeleteBackupOperationSerializer()
            deserializeWith = DeleteBackupOperationDeserializer()
            operationName = "DeleteBackup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a data repository association on an Amazon FSx for Lustre file system. Deleting the data repository association unlinks the file system from the Amazon S3 bucket. When deleting a data repository association, you have the option of deleting the data in the file system that corresponds to the data repository association. Data repository associations are supported on all FSx for Lustre 2.12 and 2.15 file systems, excluding `scratch_1` deployment type.
     */
    override suspend fun deleteDataRepositoryAssociation(input: DeleteDataRepositoryAssociationRequest): DeleteDataRepositoryAssociationResponse {
        val op = SdkHttpOperation.build<DeleteDataRepositoryAssociationRequest, DeleteDataRepositoryAssociationResponse> {
            serializeWith = DeleteDataRepositoryAssociationOperationSerializer()
            deserializeWith = DeleteDataRepositoryAssociationOperationDeserializer()
            operationName = "DeleteDataRepositoryAssociation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon File Cache resource. After deletion, the cache no longer exists, and its data is gone.
     *
     * The `DeleteFileCache` operation returns while the cache has the `DELETING` status. You can check the cache deletion status by calling the [DescribeFileCaches](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileCaches.html) operation, which returns a list of caches in your account. If you pass the cache ID for a deleted cache, the `DescribeFileCaches` operation returns a `FileCacheNotFound` error.
     *
     * The data in a deleted cache is also deleted and can't be recovered by any means.
     */
    override suspend fun deleteFileCache(input: DeleteFileCacheRequest): DeleteFileCacheResponse {
        val op = SdkHttpOperation.build<DeleteFileCacheRequest, DeleteFileCacheResponse> {
            serializeWith = DeleteFileCacheOperationSerializer()
            deserializeWith = DeleteFileCacheOperationDeserializer()
            operationName = "DeleteFileCache"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a file system. After deletion, the file system no longer exists, and its data is gone. Any existing automatic backups and snapshots are also deleted.
     *
     * To delete an Amazon FSx for NetApp ONTAP file system, first delete all the volumes and storage virtual machines (SVMs) on the file system. Then provide a `FileSystemId` value to the `DeleFileSystem` operation.
     *
     * By default, when you delete an Amazon FSx for Windows File Server file system, a final backup is created upon deletion. This final backup isn't subject to the file system's retention policy, and must be manually deleted.
     *
     * To delete an Amazon FSx for Lustre file system, first [unmount](https://docs.aws.amazon.com/fsx/latest/LustreGuide/unmounting-fs.html) it from every connected Amazon EC2 instance, then provide a `FileSystemId` value to the `DeleFileSystem` operation. By default, Amazon FSx will not take a final backup when the `DeleteFileSystem` operation is invoked. On file systems not linked to an Amazon S3 bucket, set `SkipFinalBackup` to `false` to take a final backup of the file system you are deleting. Backups cannot be enabled on S3-linked file systems. To ensure all of your data is written back to S3 before deleting your file system, you can either monitor for the [AgeOfOldestQueuedMessage](https://docs.aws.amazon.com/fsx/latest/LustreGuide/monitoring-cloudwatch.html#auto-import-export-metrics) metric to be zero (if using automatic export) or you can run an [export data repository task](https://docs.aws.amazon.com/fsx/latest/LustreGuide/export-data-repo-task-dra.html). If you have automatic export enabled and want to use an export data repository task, you have to disable automatic export before executing the export data repository task.
     *
     * The `DeleteFileSystem` operation returns while the file system has the `DELETING` status. You can check the file system deletion status by calling the [DescribeFileSystems](https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html) operation, which returns a list of file systems in your account. If you pass the file system ID for a deleted file system, the `DescribeFileSystems` operation returns a `FileSystemNotFound` error.
     *
     * If a data repository task is in a `PENDING` or `EXECUTING` state, deleting an Amazon FSx for Lustre file system will fail with an HTTP status code 400 (Bad Request).
     *
     * The data in a deleted file system is also deleted and can't be recovered by any means.
     *
     * @sample aws.sdk.kotlin.services.fsx.samples.DeleteFileSystem.sample
     */
    override suspend fun deleteFileSystem(input: DeleteFileSystemRequest): DeleteFileSystemResponse {
        val op = SdkHttpOperation.build<DeleteFileSystemRequest, DeleteFileSystemResponse> {
            serializeWith = DeleteFileSystemOperationSerializer()
            deserializeWith = DeleteFileSystemOperationDeserializer()
            operationName = "DeleteFileSystem"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon FSx for OpenZFS snapshot. After deletion, the snapshot no longer exists, and its data is gone. Deleting a snapshot doesn't affect snapshots stored in a file system backup.
     *
     * The `DeleteSnapshot` operation returns instantly. The snapshot appears with the lifecycle status of `DELETING` until the deletion is complete.
     */
    override suspend fun deleteSnapshot(input: DeleteSnapshotRequest): DeleteSnapshotResponse {
        val op = SdkHttpOperation.build<DeleteSnapshotRequest, DeleteSnapshotResponse> {
            serializeWith = DeleteSnapshotOperationSerializer()
            deserializeWith = DeleteSnapshotOperationDeserializer()
            operationName = "DeleteSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing Amazon FSx for ONTAP storage virtual machine (SVM). Prior to deleting an SVM, you must delete all non-root volumes in the SVM, otherwise the operation will fail.
     */
    override suspend fun deleteStorageVirtualMachine(input: DeleteStorageVirtualMachineRequest): DeleteStorageVirtualMachineResponse {
        val op = SdkHttpOperation.build<DeleteStorageVirtualMachineRequest, DeleteStorageVirtualMachineResponse> {
            serializeWith = DeleteStorageVirtualMachineOperationSerializer()
            deserializeWith = DeleteStorageVirtualMachineOperationDeserializer()
            operationName = "DeleteStorageVirtualMachine"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.
     */
    override suspend fun deleteVolume(input: DeleteVolumeRequest): DeleteVolumeResponse {
        val op = SdkHttpOperation.build<DeleteVolumeRequest, DeleteVolumeResponse> {
            serializeWith = DeleteVolumeOperationSerializer()
            deserializeWith = DeleteVolumeOperationDeserializer()
            operationName = "DeleteVolume"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the description of a specific Amazon FSx backup, if a `BackupIds` value is provided for that backup. Otherwise, it returns all backups owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all backups, you can optionally specify the `MaxResults` parameter to limit the number of backups in a response. If more backups remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of the `NextToken` value from the last response.
     *
     * This operation is used in an iterative process to retrieve a list of your backups. `DescribeBackups` is called first without a `NextToken` value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken` value.
     *
     * When using this operation, keep the following in mind:
     * + The operation might return fewer than the `MaxResults` value of backup descriptions while still including a `NextToken` value.
     * + The order of the backups returned in the response of one `DescribeBackups` call and the order of the backups returned across the responses of a multi-call iteration is unspecified.
     */
    override suspend fun describeBackups(input: DescribeBackupsRequest): DescribeBackupsResponse {
        val op = SdkHttpOperation.build<DescribeBackupsRequest, DescribeBackupsResponse> {
            serializeWith = DescribeBackupsOperationSerializer()
            deserializeWith = DescribeBackupsOperationDeserializer()
            operationName = "DescribeBackups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the description of specific Amazon FSx for Lustre or Amazon File Cache data repository associations, if one or more `AssociationIds` values are provided in the request, or if filters are used in the request. Data repository associations are supported on Amazon File Cache resources and all FSx for Lustre 2.12 and 2,15 file systems, excluding `scratch_1` deployment type.
     *
     * You can use filters to narrow the response to include just data repository associations for specific file systems (use the `file-system-id` filter with the ID of the file system) or caches (use the `file-cache-id` filter with the ID of the cache), or data repository associations for a specific repository type (use the `data-repository-type` filter with a value of `S3` or `NFS`). If you don't use filters, the response returns all data repository associations owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all data repository associations, you can paginate the response by using the optional `MaxResults` parameter to limit the number of data repository associations returned in a response. If more data repository associations remain, a `NextToken` value is returned in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     */
    override suspend fun describeDataRepositoryAssociations(input: DescribeDataRepositoryAssociationsRequest): DescribeDataRepositoryAssociationsResponse {
        val op = SdkHttpOperation.build<DescribeDataRepositoryAssociationsRequest, DescribeDataRepositoryAssociationsResponse> {
            serializeWith = DescribeDataRepositoryAssociationsOperationSerializer()
            deserializeWith = DescribeDataRepositoryAssociationsOperationDeserializer()
            operationName = "DescribeDataRepositoryAssociations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the description of specific Amazon FSx for Lustre or Amazon File Cache data repository tasks, if one or more `TaskIds` values are provided in the request, or if filters are used in the request. You can use filters to narrow the response to include just tasks for specific file systems or caches, or tasks in a specific lifecycle state. Otherwise, it returns all data repository tasks owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all tasks, you can paginate the response by using the optional `MaxResults` parameter to limit the number of tasks returned in a response. If more tasks remain, a `NextToken` value is returned in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     */
    override suspend fun describeDataRepositoryTasks(input: DescribeDataRepositoryTasksRequest): DescribeDataRepositoryTasksResponse {
        val op = SdkHttpOperation.build<DescribeDataRepositoryTasksRequest, DescribeDataRepositoryTasksResponse> {
            serializeWith = DescribeDataRepositoryTasksOperationSerializer()
            deserializeWith = DescribeDataRepositoryTasksOperationDeserializer()
            operationName = "DescribeDataRepositoryTasks"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the description of a specific Amazon File Cache resource, if a `FileCacheIds` value is provided for that cache. Otherwise, it returns descriptions of all caches owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all cache descriptions, you can optionally specify the `MaxResults` parameter to limit the number of descriptions in a response. If more cache descriptions remain, the operation returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     *
     * This operation is used in an iterative process to retrieve a list of your cache descriptions. `DescribeFileCaches` is called first without a `NextToken`value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken`.
     *
     * When using this operation, keep the following in mind:
     * + The implementation might return fewer than `MaxResults` cache descriptions while still including a `NextToken` value.
     * + The order of caches returned in the response of one `DescribeFileCaches` call and the order of caches returned across the responses of a multicall iteration is unspecified.
     */
    override suspend fun describeFileCaches(input: DescribeFileCachesRequest): DescribeFileCachesResponse {
        val op = SdkHttpOperation.build<DescribeFileCachesRequest, DescribeFileCachesResponse> {
            serializeWith = DescribeFileCachesOperationSerializer()
            deserializeWith = DescribeFileCachesOperationDeserializer()
            operationName = "DescribeFileCaches"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the DNS aliases that are associated with the specified Amazon FSx for Windows File Server file system. A history of all DNS aliases that have been associated with and disassociated from the file system is available in the list of AdministrativeAction provided in the DescribeFileSystems operation response.
     */
    override suspend fun describeFileSystemAliases(input: DescribeFileSystemAliasesRequest): DescribeFileSystemAliasesResponse {
        val op = SdkHttpOperation.build<DescribeFileSystemAliasesRequest, DescribeFileSystemAliasesResponse> {
            serializeWith = DescribeFileSystemAliasesOperationSerializer()
            deserializeWith = DescribeFileSystemAliasesOperationDeserializer()
            operationName = "DescribeFileSystemAliases"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the description of specific Amazon FSx file systems, if a `FileSystemIds` value is provided for that file system. Otherwise, it returns descriptions of all file systems owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all file system descriptions, you can optionally specify the `MaxResults` parameter to limit the number of descriptions in a response. If more file system descriptions remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     *
     * This operation is used in an iterative process to retrieve a list of your file system descriptions. `DescribeFileSystems` is called first without a `NextToken`value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken`.
     *
     * When using this operation, keep the following in mind:
     * + The implementation might return fewer than `MaxResults` file system descriptions while still including a `NextToken` value.
     * + The order of file systems returned in the response of one `DescribeFileSystems` call and the order of file systems returned across the responses of a multicall iteration is unspecified.
     */
    override suspend fun describeFileSystems(input: DescribeFileSystemsRequest): DescribeFileSystemsResponse {
        val op = SdkHttpOperation.build<DescribeFileSystemsRequest, DescribeFileSystemsResponse> {
            serializeWith = DescribeFileSystemsOperationSerializer()
            deserializeWith = DescribeFileSystemsOperationDeserializer()
            operationName = "DescribeFileSystems"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Indicates whether participant accounts in your organization can create Amazon FSx for NetApp ONTAP Multi-AZ file systems in subnets that are shared by a virtual private cloud (VPC) owner. For more information, see [Creating FSx for ONTAP file systems in shared subnets](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/creating-file-systems.html#fsxn-vpc-shared-subnets).
     */
    override suspend fun describeSharedVpcConfiguration(input: DescribeSharedVpcConfigurationRequest): DescribeSharedVpcConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeSharedVpcConfigurationRequest, DescribeSharedVpcConfigurationResponse> {
            serializeWith = DescribeSharedVpcConfigurationOperationSerializer()
            deserializeWith = DescribeSharedVpcConfigurationOperationDeserializer()
            operationName = "DescribeSharedVpcConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the description of specific Amazon FSx for OpenZFS snapshots, if a `SnapshotIds` value is provided. Otherwise, this operation returns all snapshots owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all snapshots, you can optionally specify the `MaxResults` parameter to limit the number of snapshots in a response. If more backups remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     *
     * Use this operation in an iterative process to retrieve a list of your snapshots. `DescribeSnapshots` is called first without a `NextToken` value. Then the operation continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken` value.
     *
     * When using this operation, keep the following in mind:
     * + The operation might return fewer than the `MaxResults` value of snapshot descriptions while still including a `NextToken` value.
     * + The order of snapshots returned in the response of one `DescribeSnapshots` call and the order of backups returned across the responses of a multi-call iteration is unspecified.
     */
    override suspend fun describeSnapshots(input: DescribeSnapshotsRequest): DescribeSnapshotsResponse {
        val op = SdkHttpOperation.build<DescribeSnapshotsRequest, DescribeSnapshotsResponse> {
            serializeWith = DescribeSnapshotsOperationSerializer()
            deserializeWith = DescribeSnapshotsOperationDeserializer()
            operationName = "DescribeSnapshots"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more Amazon FSx for NetApp ONTAP storage virtual machines (SVMs).
     */
    override suspend fun describeStorageVirtualMachines(input: DescribeStorageVirtualMachinesRequest): DescribeStorageVirtualMachinesResponse {
        val op = SdkHttpOperation.build<DescribeStorageVirtualMachinesRequest, DescribeStorageVirtualMachinesResponse> {
            serializeWith = DescribeStorageVirtualMachinesOperationSerializer()
            deserializeWith = DescribeStorageVirtualMachinesOperationDeserializer()
            operationName = "DescribeStorageVirtualMachines"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volumes.
     */
    override suspend fun describeVolumes(input: DescribeVolumesRequest): DescribeVolumesResponse {
        val op = SdkHttpOperation.build<DescribeVolumesRequest, DescribeVolumesResponse> {
            serializeWith = DescribeVolumesOperationSerializer()
            deserializeWith = DescribeVolumesOperationDeserializer()
            operationName = "DescribeVolumes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Use this action to disassociate, or remove, one or more Domain Name Service (DNS) aliases from an Amazon FSx for Windows File Server file system. If you attempt to disassociate a DNS alias that is not associated with the file system, Amazon FSx responds with an HTTP status code 400 (Bad Request). For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html).
     *
     * The system generated response showing the DNS aliases that Amazon FSx is attempting to disassociate from the file system. Use the API operation to monitor the status of the aliases Amazon FSx is disassociating with the file system.
     */
    override suspend fun disassociateFileSystemAliases(input: DisassociateFileSystemAliasesRequest): DisassociateFileSystemAliasesResponse {
        val op = SdkHttpOperation.build<DisassociateFileSystemAliasesRequest, DisassociateFileSystemAliasesResponse> {
            serializeWith = DisassociateFileSystemAliasesOperationSerializer()
            deserializeWith = DisassociateFileSystemAliasesOperationDeserializer()
            operationName = "DisassociateFileSystemAliases"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists tags for Amazon FSx resources.
     *
     * When retrieving all tags, you can optionally specify the `MaxResults` parameter to limit the number of tags in a response. If more tags remain, Amazon FSx returns a `NextToken` value in the response. In this case, send a later request with the `NextToken` request parameter set to the value of `NextToken` from the last response.
     *
     * This action is used in an iterative process to retrieve a list of your tags. `ListTagsForResource` is called first without a `NextToken`value. Then the action continues to be called with the `NextToken` parameter set to the value of the last `NextToken` value until a response has no `NextToken`.
     *
     * When using this action, keep the following in mind:
     * + The implementation might return fewer than `MaxResults` file system descriptions while still including a `NextToken` value.
     * + The order of tags returned in the response of one `ListTagsForResource` call and the order of tags returned across the responses of a multi-call iteration is unspecified.
     *
     * @sample aws.sdk.kotlin.services.fsx.samples.ListTagsForResource.sample
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializeWith = ListTagsForResourceOperationSerializer()
            deserializeWith = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Releases the file system lock from an Amazon FSx for OpenZFS file system.
     */
    override suspend fun releaseFileSystemNfsV3Locks(input: ReleaseFileSystemNfsV3LocksRequest): ReleaseFileSystemNfsV3LocksResponse {
        val op = SdkHttpOperation.build<ReleaseFileSystemNfsV3LocksRequest, ReleaseFileSystemNfsV3LocksResponse> {
            serializeWith = ReleaseFileSystemNfsV3LocksOperationSerializer()
            deserializeWith = ReleaseFileSystemNfsV3LocksOperationDeserializer()
            operationName = "ReleaseFileSystemNfsV3Locks"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns an Amazon FSx for OpenZFS volume to the state saved by the specified snapshot.
     */
    override suspend fun restoreVolumeFromSnapshot(input: RestoreVolumeFromSnapshotRequest): RestoreVolumeFromSnapshotResponse {
        val op = SdkHttpOperation.build<RestoreVolumeFromSnapshotRequest, RestoreVolumeFromSnapshotResponse> {
            serializeWith = RestoreVolumeFromSnapshotOperationSerializer()
            deserializeWith = RestoreVolumeFromSnapshotOperationDeserializer()
            operationName = "RestoreVolumeFromSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * After performing steps to repair the Active Directory configuration of an FSx for Windows File Server file system, use this action to initiate the process of Amazon FSx attempting to reconnect to the file system.
     */
    override suspend fun startMisconfiguredStateRecovery(input: StartMisconfiguredStateRecoveryRequest): StartMisconfiguredStateRecoveryResponse {
        val op = SdkHttpOperation.build<StartMisconfiguredStateRecoveryRequest, StartMisconfiguredStateRecoveryResponse> {
            serializeWith = StartMisconfiguredStateRecoveryOperationSerializer()
            deserializeWith = StartMisconfiguredStateRecoveryOperationDeserializer()
            operationName = "StartMisconfiguredStateRecovery"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Tags an Amazon FSx resource.
     *
     * @sample aws.sdk.kotlin.services.fsx.samples.TagResource.sample
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializeWith = TagResourceOperationSerializer()
            deserializeWith = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This action removes a tag from an Amazon FSx resource.
     *
     * @sample aws.sdk.kotlin.services.fsx.samples.UntagResource.sample
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializeWith = UntagResourceOperationSerializer()
            deserializeWith = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration of an existing data repository association on an Amazon FSx for Lustre file system. Data repository associations are supported on all FSx for Lustre 2.12 and 2.15 file systems, excluding `scratch_1` deployment type.
     */
    override suspend fun updateDataRepositoryAssociation(input: UpdateDataRepositoryAssociationRequest): UpdateDataRepositoryAssociationResponse {
        val op = SdkHttpOperation.build<UpdateDataRepositoryAssociationRequest, UpdateDataRepositoryAssociationResponse> {
            serializeWith = UpdateDataRepositoryAssociationOperationSerializer()
            deserializeWith = UpdateDataRepositoryAssociationOperationDeserializer()
            operationName = "UpdateDataRepositoryAssociation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration of an existing Amazon File Cache resource. You can update multiple properties in a single request.
     */
    override suspend fun updateFileCache(input: UpdateFileCacheRequest): UpdateFileCacheResponse {
        val op = SdkHttpOperation.build<UpdateFileCacheRequest, UpdateFileCacheResponse> {
            serializeWith = UpdateFileCacheOperationSerializer()
            deserializeWith = UpdateFileCacheOperationDeserializer()
            operationName = "UpdateFileCache"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Use this operation to update the configuration of an existing Amazon FSx file system. You can update multiple properties in a single request.
     *
     * For FSx for Windows File Server file systems, you can update the following properties:
     * + `AuditLogConfiguration`
     * + `AutomaticBackupRetentionDays`
     * + `DailyAutomaticBackupStartTime`
     * + `SelfManagedActiveDirectoryConfiguration`
     * + `StorageCapacity`
     * + `StorageType`
     * + `ThroughputCapacity`
     * + `DiskIopsConfiguration`
     * + `WeeklyMaintenanceStartTime`
     *
     * For FSx for Lustre file systems, you can update the following properties:
     * + `AutoImportPolicy`
     * + `AutomaticBackupRetentionDays`
     * + `DailyAutomaticBackupStartTime`
     * + `DataCompressionType`
     * + `LogConfiguration`
     * + `LustreRootSquashConfiguration`
     * + `PerUnitStorageThroughput`
     * + `StorageCapacity`
     * + `WeeklyMaintenanceStartTime`
     *
     * For FSx for ONTAP file systems, you can update the following properties:
     * + `AddRouteTableIds`
     * + `AutomaticBackupRetentionDays`
     * + `DailyAutomaticBackupStartTime`
     * + `DiskIopsConfiguration`
     * + `FsxAdminPassword`
     * + `HAPairs`
     * + `RemoveRouteTableIds`
     * + `StorageCapacity`
     * + `ThroughputCapacity`
     * + `ThroughputCapacityPerHAPair`
     * + `WeeklyMaintenanceStartTime`
     *
     * For FSx for OpenZFS file systems, you can update the following properties:
     * + `AddRouteTableIds`
     * + `AutomaticBackupRetentionDays`
     * + `CopyTagsToBackups`
     * + `CopyTagsToVolumes`
     * + `DailyAutomaticBackupStartTime`
     * + `DiskIopsConfiguration`
     * + `RemoveRouteTableIds`
     * + `StorageCapacity`
     * + `ThroughputCapacity`
     * + `WeeklyMaintenanceStartTime`
     */
    override suspend fun updateFileSystem(input: UpdateFileSystemRequest): UpdateFileSystemResponse {
        val op = SdkHttpOperation.build<UpdateFileSystemRequest, UpdateFileSystemResponse> {
            serializeWith = UpdateFileSystemOperationSerializer()
            deserializeWith = UpdateFileSystemOperationDeserializer()
            operationName = "UpdateFileSystem"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Configures whether participant accounts in your organization can create Amazon FSx for NetApp ONTAP Multi-AZ file systems in subnets that are shared by a virtual private cloud (VPC) owner. For more information, see the [Amazon FSx for NetApp ONTAP User Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/maz-shared-vpc.html).
     *
     * We strongly recommend that participant-created Multi-AZ file systems in the shared VPC are deleted before you disable this feature. Once the feature is disabled, these file systems will enter a `MISCONFIGURED` state and behave like Single-AZ file systems. For more information, see [Important considerations before disabling shared VPC support for Multi-AZ file systems](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/maz-shared-vpc.html#disabling-maz-vpc-sharing).
     */
    override suspend fun updateSharedVpcConfiguration(input: UpdateSharedVpcConfigurationRequest): UpdateSharedVpcConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateSharedVpcConfigurationRequest, UpdateSharedVpcConfigurationResponse> {
            serializeWith = UpdateSharedVpcConfigurationOperationSerializer()
            deserializeWith = UpdateSharedVpcConfigurationOperationDeserializer()
            operationName = "UpdateSharedVpcConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the name of an Amazon FSx for OpenZFS snapshot.
     */
    override suspend fun updateSnapshot(input: UpdateSnapshotRequest): UpdateSnapshotResponse {
        val op = SdkHttpOperation.build<UpdateSnapshotRequest, UpdateSnapshotResponse> {
            serializeWith = UpdateSnapshotOperationSerializer()
            deserializeWith = UpdateSnapshotOperationDeserializer()
            operationName = "UpdateSnapshot"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an FSx for ONTAP storage virtual machine (SVM).
     */
    override suspend fun updateStorageVirtualMachine(input: UpdateStorageVirtualMachineRequest): UpdateStorageVirtualMachineResponse {
        val op = SdkHttpOperation.build<UpdateStorageVirtualMachineRequest, UpdateStorageVirtualMachineResponse> {
            serializeWith = UpdateStorageVirtualMachineOperationSerializer()
            deserializeWith = UpdateStorageVirtualMachineOperationDeserializer()
            operationName = "UpdateStorageVirtualMachine"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration of an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.
     */
    override suspend fun updateVolume(input: UpdateVolumeRequest): UpdateVolumeResponse {
        val op = SdkHttpOperation.build<UpdateVolumeRequest, UpdateVolumeResponse> {
            serializeWith = UpdateVolumeOperationSerializer()
            deserializeWith = UpdateVolumeOperationDeserializer()
            operationName = "UpdateVolume"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSSimbaAPIService_v20180301", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(SdkClientOption.IdempotencyTokenProvider, config.idempotencyTokenProvider)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "fsx")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
