// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecastquery.model



class QueryForecastRequest private constructor(builder: BuilderImpl) {
    /**
     * The end date for the forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss
     * (ISO 8601 format). For example, 2015-01-01T20:00:00.
     */
    val endDate: String? = builder.endDate
    /**
     * The filtering criteria to apply when retrieving the forecast. For example, to get the
     * forecast for client_21 in the electricity usage dataset, specify the
     * following:
     * {"item_id" : "client_21"}
     * To get the full forecast, use the <a href="https://docs.aws.amazon.com/en_us/forecast/latest/dg/API_CreateForecastExportJob.html">CreateForecastExportJob operation.
     */
    val filters: Map<String, String>? = builder.filters
    /**
     * The Amazon Resource Name (ARN) of the forecast to query.
     */
    val forecastArn: String? = builder.forecastArn
    /**
     * If the result of the previous request was truncated, the response includes a
     * NextToken. To retrieve the next set of results, use the token in the next
     * request. Tokens expire after 24 hours.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The start date for the forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss
     * (ISO 8601 format). For example, 2015-01-01T08:00:00.
     */
    val startDate: String? = builder.startDate

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): QueryForecastRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("QueryForecastRequest(")
        append("endDate=$endDate,")
        append("filters=$filters,")
        append("forecastArn=$forecastArn,")
        append("nextToken=$nextToken,")
        append("startDate=$startDate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endDate?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (forecastArn?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as QueryForecastRequest

        if (endDate != other.endDate) return false
        if (filters != other.filters) return false
        if (forecastArn != other.forecastArn) return false
        if (nextToken != other.nextToken) return false
        if (startDate != other.startDate) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): QueryForecastRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): QueryForecastRequest
        /**
         * The end date for the forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss
         * (ISO 8601 format). For example, 2015-01-01T20:00:00.
         */
        fun endDate(endDate: String): FluentBuilder
        /**
         * The filtering criteria to apply when retrieving the forecast. For example, to get the
         * forecast for client_21 in the electricity usage dataset, specify the
         * following:
         * {"item_id" : "client_21"}
         * To get the full forecast, use the <a href="https://docs.aws.amazon.com/en_us/forecast/latest/dg/API_CreateForecastExportJob.html">CreateForecastExportJob operation.
         */
        fun filters(filters: Map<String, String>): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the forecast to query.
         */
        fun forecastArn(forecastArn: String): FluentBuilder
        /**
         * If the result of the previous request was truncated, the response includes a
         * NextToken. To retrieve the next set of results, use the token in the next
         * request. Tokens expire after 24 hours.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The start date for the forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss
         * (ISO 8601 format). For example, 2015-01-01T08:00:00.
         */
        fun startDate(startDate: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The end date for the forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss
         * (ISO 8601 format). For example, 2015-01-01T20:00:00.
         */
        var endDate: String?
        /**
         * The filtering criteria to apply when retrieving the forecast. For example, to get the
         * forecast for client_21 in the electricity usage dataset, specify the
         * following:
         * {"item_id" : "client_21"}
         * To get the full forecast, use the <a href="https://docs.aws.amazon.com/en_us/forecast/latest/dg/API_CreateForecastExportJob.html">CreateForecastExportJob operation.
         */
        var filters: Map<String, String>?
        /**
         * The Amazon Resource Name (ARN) of the forecast to query.
         */
        var forecastArn: String?
        /**
         * If the result of the previous request was truncated, the response includes a
         * NextToken. To retrieve the next set of results, use the token in the next
         * request. Tokens expire after 24 hours.
         */
        var nextToken: String?
        /**
         * The start date for the forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss
         * (ISO 8601 format). For example, 2015-01-01T08:00:00.
         */
        var startDate: String?

        fun build(): QueryForecastRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var endDate: String? = null
        override var filters: Map<String, String>? = null
        override var forecastArn: String? = null
        override var nextToken: String? = null
        override var startDate: String? = null

        constructor(x: QueryForecastRequest) : this() {
            this.endDate = x.endDate
            this.filters = x.filters
            this.forecastArn = x.forecastArn
            this.nextToken = x.nextToken
            this.startDate = x.startDate
        }

        override fun build(): QueryForecastRequest = QueryForecastRequest(this)
        override fun endDate(endDate: String): FluentBuilder = apply { this.endDate = endDate }
        override fun filters(filters: Map<String, String>): FluentBuilder = apply { this.filters = filters }
        override fun forecastArn(forecastArn: String): FluentBuilder = apply { this.forecastArn = forecastArn }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun startDate(startDate: String): FluentBuilder = apply { this.startDate = startDate }
    }
}
