// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecastquery

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.services.forecastquery.model.*
import aws.sdk.kotlin.services.forecastquery.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "forecastquery"
const val ServiceApiVersion: String = "2018-06-26"
const val SdkVersion: String = "0.8.0-alpha"

internal class DefaultForecastqueryClient(override val config: ForecastqueryClient.Config) : ForecastqueryClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Retrieves a forecast for a single item, filtered by the supplied criteria.
     * The criteria is a key-value pair. The key is either item_id (or the
     * equivalent non-timestamp, non-target field) from the TARGET_TIME_SERIES dataset,
     * or one of the forecast dimensions specified as part of the FeaturizationConfig
     * object.
     * By default, QueryForecast returns the complete date range for the filtered
     * forecast. You can request a specific date range.
     * To get the full forecast, use the <a href="https://docs.aws.amazon.com/en_us/forecast/latest/dg/API_CreateForecastExportJob.html">CreateForecastExportJob operation.
     * The forecasts generated by Amazon Forecast are in the same timezone as the dataset that was
     * used to create the predictor.
     */
    override suspend fun queryForecast(input: QueryForecastRequest): QueryForecastResponse {
        val op = SdkHttpOperation.build<QueryForecastRequest, QueryForecastResponse> {
            serializer = QueryForecastOperationSerializer()
            deserializer = QueryForecastOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "QueryForecast"
            }
        }
        registerQueryForecastMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
