// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecastquery.model



public class QueryWhatIfForecastRequest private constructor(builder: Builder) {
    /**
     * The end date for the what-if forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss (ISO 8601 format). For example, 2015-01-01T20:00:00.
     */
    public val endDate: kotlin.String? = builder.endDate
    /**
     * The filtering criteria to apply when retrieving the forecast. For example, to get the forecast for `client_21` in the electricity usage dataset, specify the following:
     *
     * `{"item_id" : "client_21"}`
     *
     * To get the full what-if forecast, use the [CreateForecastExportJob](https://docs.aws.amazon.com/en_us/forecast/latest/dg/API_CreateWhatIfForecastExport.html) operation.
     */
    public val filters: Map<String, String>? = builder.filters
    /**
     * If the result of the previous request was truncated, the response includes a `NextToken`. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The start date for the what-if forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss (ISO 8601 format). For example, 2015-01-01T08:00:00.
     */
    public val startDate: kotlin.String? = builder.startDate
    /**
     * The Amazon Resource Name (ARN) of the what-if forecast to query.
     */
    public val whatIfForecastArn: kotlin.String? = builder.whatIfForecastArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.forecastquery.model.QueryWhatIfForecastRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryWhatIfForecastRequest(")
        append("endDate=$endDate,")
        append("filters=$filters,")
        append("nextToken=$nextToken,")
        append("startDate=$startDate,")
        append("whatIfForecastArn=$whatIfForecastArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endDate?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (whatIfForecastArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryWhatIfForecastRequest

        if (endDate != other.endDate) return false
        if (filters != other.filters) return false
        if (nextToken != other.nextToken) return false
        if (startDate != other.startDate) return false
        if (whatIfForecastArn != other.whatIfForecastArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.forecastquery.model.QueryWhatIfForecastRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The end date for the what-if forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss (ISO 8601 format). For example, 2015-01-01T20:00:00.
         */
        public var endDate: kotlin.String? = null
        /**
         * The filtering criteria to apply when retrieving the forecast. For example, to get the forecast for `client_21` in the electricity usage dataset, specify the following:
         *
         * `{"item_id" : "client_21"}`
         *
         * To get the full what-if forecast, use the [CreateForecastExportJob](https://docs.aws.amazon.com/en_us/forecast/latest/dg/API_CreateWhatIfForecastExport.html) operation.
         */
        public var filters: Map<String, String>? = null
        /**
         * If the result of the previous request was truncated, the response includes a `NextToken`. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The start date for the what-if forecast. Specify the date using this format: yyyy-MM-dd'T'HH:mm:ss (ISO 8601 format). For example, 2015-01-01T08:00:00.
         */
        public var startDate: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the what-if forecast to query.
         */
        public var whatIfForecastArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.forecastquery.model.QueryWhatIfForecastRequest) : this() {
            this.endDate = x.endDate
            this.filters = x.filters
            this.nextToken = x.nextToken
            this.startDate = x.startDate
            this.whatIfForecastArn = x.whatIfForecastArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.forecastquery.model.QueryWhatIfForecastRequest = QueryWhatIfForecastRequest(this)
    }
}
