// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecastquery.serde

import aws.sdk.kotlin.services.forecastquery.model.Forecast
import aws.sdk.kotlin.services.forecastquery.model.ForecastqueryException
import aws.sdk.kotlin.services.forecastquery.model.QueryForecastResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class QueryForecastOperationDeserializer: HttpDeserializer.NonStreaming<QueryForecastResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): QueryForecastResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwQueryForecastError(context, call, payload)
        }
        val builder = QueryForecastResponse.Builder()

        if (payload != null) {
            deserializeQueryForecastOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwQueryForecastError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ForecastqueryException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceInUseException" -> ResourceInUseExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ForecastqueryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeQueryForecastOperationBody(builder: QueryForecastResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FORECAST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Forecast"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FORECAST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FORECAST_DESCRIPTOR.index -> builder.forecast = deserializeForecastDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
