// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.forecast.serde

import aws.sdk.kotlin.services.forecast.model.DescribeWhatIfForecastResponse
import aws.sdk.kotlin.services.forecast.model.ForecastException
import aws.sdk.kotlin.services.forecast.model.TimeSeriesReplacementsDataSource
import aws.sdk.kotlin.services.forecast.model.TimeSeriesTransformation
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeWhatIfForecastOperationDeserializer: HttpDeserializer.NonStreaming<DescribeWhatIfForecastResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeWhatIfForecastResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeWhatIfForecastError(context, call, payload)
        }
        val builder = DescribeWhatIfForecastResponse.Builder()

        if (payload != null) {
            deserializeDescribeWhatIfForecastOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeWhatIfForecastError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ForecastException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ForecastException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeWhatIfForecastOperationBody(builder: DescribeWhatIfForecastResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("EstimatedTimeRemainingInMinutes"))
    val FORECASTTYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ForecastTypes"))
    val LASTMODIFICATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModificationTime"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Message"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val TIMESERIESREPLACEMENTSDATASOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TimeSeriesReplacementsDataSource"))
    val TIMESERIESTRANSFORMATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TimeSeriesTransformations"))
    val WHATIFANALYSISARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WhatIfAnalysisArn"))
    val WHATIFFORECASTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WhatIfForecastArn"))
    val WHATIFFORECASTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WhatIfForecastName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR)
        field(FORECASTTYPES_DESCRIPTOR)
        field(LASTMODIFICATIONTIME_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TIMESERIESREPLACEMENTSDATASOURCE_DESCRIPTOR)
        field(TIMESERIESTRANSFORMATIONS_DESCRIPTOR)
        field(WHATIFANALYSISARN_DESCRIPTOR)
        field(WHATIFFORECASTARN_DESCRIPTOR)
        field(WHATIFFORECASTNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ESTIMATEDTIMEREMAININGINMINUTES_DESCRIPTOR.index -> builder.estimatedTimeRemainingInMinutes = deserializeLong()
                FORECASTTYPES_DESCRIPTOR.index -> builder.forecastTypes =
                    deserializer.deserializeList(FORECASTTYPES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LASTMODIFICATIONTIME_DESCRIPTOR.index -> builder.lastModificationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                TIMESERIESREPLACEMENTSDATASOURCE_DESCRIPTOR.index -> builder.timeSeriesReplacementsDataSource = deserializeTimeSeriesReplacementsDataSourceDocument(deserializer)
                TIMESERIESTRANSFORMATIONS_DESCRIPTOR.index -> builder.timeSeriesTransformations =
                    deserializer.deserializeList(TIMESERIESTRANSFORMATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<TimeSeriesTransformation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTimeSeriesTransformationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                WHATIFANALYSISARN_DESCRIPTOR.index -> builder.whatIfAnalysisArn = deserializeString()
                WHATIFFORECASTARN_DESCRIPTOR.index -> builder.whatIfForecastArn = deserializeString()
                WHATIFFORECASTNAME_DESCRIPTOR.index -> builder.whatIfForecastName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
